/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ValueAdjuster;
import de.matthiasmann.twl.model.FloatModel;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.IllegalFormatException;
import java.util.Locale;

public class ValueAdjusterFloat
extends ValueAdjuster {
    private float value;
    private float minValue;
    private float maxValue = 100.0f;
    private float dragStartValue;
    private float stepSize = 1.0f;
    private FloatModel model;
    private Runnable modelCallback;
    private String format = "%.2f";
    private Locale locale = Locale.ENGLISH;

    public ValueAdjusterFloat() {
        this.setTheme("valueadjuster");
        this.setDisplayText();
    }

    public ValueAdjusterFloat(FloatModel model) {
        this.setTheme("valueadjuster");
        this.setModel(model);
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinMaxValue(float minValue, float maxValue) {
        if (maxValue < minValue) {
            throw new IllegalArgumentException("maxValue < minValue");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.setValue(this.value);
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        if (value > this.maxValue) {
            value = this.maxValue;
        } else if (value < this.minValue) {
            value = this.minValue;
        }
        if (this.value != value) {
            this.value = value;
            if (this.model != null) {
                this.model.setValue(value);
            }
            this.setDisplayText();
        }
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float stepSize) {
        if (!(stepSize > 0.0f)) {
            throw new IllegalArgumentException("stepSize");
        }
        this.stepSize = stepSize;
    }

    public FloatModel getModel() {
        return this.model;
    }

    public void setModel(FloatModel model) {
        if (this.model != model) {
            this.removeModelCallback();
            this.model = model;
            if (model != null) {
                this.minValue = model.getMinValue();
                this.maxValue = model.getMaxValue();
                this.addModelCallback();
            }
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) throws IllegalFormatException {
        String.format(this.locale, format, Float.valueOf(42.0f));
        this.format = format;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        this.locale = locale;
    }

    @Override
    protected String onEditStart() {
        return this.formatText();
    }

    @Override
    protected boolean onEditEnd(String text) {
        try {
            this.setValue(this.parseText(text));
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    @Override
    protected String validateEdit(String text) {
        try {
            this.parseText(text);
            return null;
        }
        catch (ParseException ex) {
            return ex.toString();
        }
    }

    @Override
    protected void onEditCanceled() {
    }

    @Override
    protected boolean shouldStartEdit(char ch) {
        return ch >= '0' && ch <= '9' || ch == '-' || ch == '.';
    }

    @Override
    protected void onDragStart() {
        this.dragStartValue = this.value;
    }

    @Override
    protected void onDragUpdate(int dragDelta) {
        float range = Math.max(1.0E-4f, Math.abs(this.getMaxValue() - this.getMinValue()));
        this.setValue(this.dragStartValue + (float)dragDelta / Math.max(3.0f, (float)this.getWidth() / range));
    }

    @Override
    protected void onDragCancelled() {
        this.setValue(this.dragStartValue);
    }

    @Override
    protected void doDecrement() {
        this.setValue(this.value - this.getStepSize());
    }

    @Override
    protected void doIncrement() {
        this.setValue(this.value + this.getStepSize());
    }

    @Override
    protected String formatText() {
        return String.format(this.locale, this.format, Float.valueOf(this.value));
    }

    protected float parseText(String value) throws ParseException {
        return NumberFormat.getNumberInstance(this.locale).parse(value).floatValue();
    }

    @Override
    protected void syncWithModel() {
        this.cancelEdit();
        this.minValue = this.model.getMinValue();
        this.maxValue = this.model.getMaxValue();
        this.value = this.model.getValue();
        this.setDisplayText();
    }

    @Override
    protected void afterAddToGUI(GUI gui) {
        super.afterAddToGUI(gui);
        this.addModelCallback();
    }

    @Override
    protected void beforeRemoveFromGUI(GUI gui) {
        this.removeModelCallback();
        super.beforeRemoveFromGUI(gui);
    }

    protected void removeModelCallback() {
        if (this.model != null && this.modelCallback != null) {
            this.model.removeCallback(this.modelCallback);
        }
    }

    protected void addModelCallback() {
        if (this.model != null && this.getGUI() != null) {
            if (this.modelCallback == null) {
                this.modelCallback = new ValueAdjuster.ModelCallback();
            }
            this.model.addCallback(this.modelCallback);
            this.syncWithModel();
        }
    }
}

