/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AbstractColorSpace;

public class ColorSpaceHSL
extends AbstractColorSpace {
    public ColorSpaceHSL() {
        super("HSL", "Hue", "Saturation", "Lightness");
    }

    @Override
    public String getComponentShortName(int component) {
        return "HSL".substring(component, component + 1);
    }

    @Override
    public float getMaxValue(int component) {
        return component == 0 ? 360.0f : 100.0f;
    }

    @Override
    public float getDefaultValue(int component) {
        return component == 0 ? 0.0f : 50.0f;
    }

    @Override
    public float[] fromRGB(int rgb) {
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        float max = Math.max(Math.max(r, g), b);
        float min = Math.min(Math.min(r, g), b);
        float summe = max + min;
        float saturation = max - min;
        if (saturation > 0.0f) {
            saturation /= summe > 1.0f ? 2.0f - summe : summe;
        }
        return new float[]{360.0f * ColorSpaceHSL.getHue(r, g, b, max, min), 100.0f * saturation, 50.0f * summe};
    }

    @Override
    public int toRGB(float[] color) {
        float b;
        float g;
        float r;
        float hue = color[0] / 360.0f;
        float saturation = color[1] / 100.0f;
        float lightness = color[2] / 100.0f;
        if (saturation > 0.0f) {
            hue = hue < 1.0f ? hue * 6.0f : 0.0f;
            float q = lightness + saturation * (lightness > 0.5f ? 1.0f - lightness : lightness);
            float p = 2.0f * lightness - q;
            r = ColorSpaceHSL.normalize(q, p, hue < 4.0f ? hue + 2.0f : hue - 4.0f);
            g = ColorSpaceHSL.normalize(q, p, hue);
            b = ColorSpaceHSL.normalize(q, p, hue < 2.0f ? hue + 4.0f : hue - 2.0f);
        } else {
            g = b = lightness;
            r = b;
        }
        return ColorSpaceHSL.toByte(r) << 16 | ColorSpaceHSL.toByte(g) << 8 | ColorSpaceHSL.toByte(b);
    }

    static float getHue(float red, float green, float blue, float max, float min) {
        float hue = max - min;
        if (hue > 0.0f) {
            if (max == red) {
                if ((hue = (green - blue) / hue) < 0.0f) {
                    hue += 6.0f;
                }
            } else {
                hue = max == green ? 2.0f + (blue - red) / hue : 4.0f + (red - green) / hue;
            }
            hue /= 6.0f;
        }
        return hue;
    }

    private static float normalize(float q, float p, float color) {
        if (color < 1.0f) {
            return p + (q - p) * color;
        }
        if (color < 3.0f) {
            return q;
        }
        if (color < 4.0f) {
            return p + (q - p) * (4.0f - color);
        }
        return p;
    }

    private static int toByte(float value) {
        return Math.max(0, Math.min(255, (int)(255.0f * value)));
    }
}

