/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.HasCallback;
import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.model.ListSelectionModel;

public class SimpleListSelectionModel<T>
extends HasCallback
implements ListSelectionModel<T> {
    private final ListModel<T> listModel;
    private int selected;

    public SimpleListSelectionModel(ListModel<T> listModel) {
        if (listModel == null) {
            throw new NullPointerException("listModel");
        }
        this.listModel = listModel;
    }

    @Override
    public ListModel<T> getListModel() {
        return this.listModel;
    }

    @Override
    public T getSelectedEntry() {
        if (this.selected >= 0 && this.selected < this.listModel.getNumEntries()) {
            return this.listModel.getEntry(this.selected);
        }
        return null;
    }

    @Override
    public boolean setSelectedEntry(T entry) {
        return this.setSelectedEntry(entry, -1);
    }

    @Override
    public boolean setSelectedEntry(T entry, int defaultIndex) {
        if (entry != null) {
            int n = this.listModel.getNumEntries();
            for (int i = 0; i < n; ++i) {
                if (!entry.equals(this.listModel.getEntry(i))) continue;
                this.setValue(i);
                return true;
            }
        }
        this.setValue(defaultIndex);
        return false;
    }

    @Override
    public int getMaxValue() {
        return this.listModel.getNumEntries() - 1;
    }

    @Override
    public int getMinValue() {
        return -1;
    }

    @Override
    public int getValue() {
        return this.selected;
    }

    @Override
    public void setValue(int value) {
        if (value < -1) {
            throw new IllegalArgumentException("value");
        }
        if (this.selected != value) {
            this.selected = value;
            this.doCallback();
        }
    }
}

