/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import de.matthiasmann.twl.Rect;

public class ClipStack {
    private Entry[] clipRects = new Entry[8];
    private int numClipRects;

    public void push(int x, int y, int w, int h) {
        Entry tos = this.push();
        tos.setXYWH(x, y, w, h);
        this.intersect(tos);
    }

    public void push(Rect rect) {
        if (rect == null) {
            throw new NullPointerException("rect");
        }
        Entry tos = this.push();
        tos.set(rect);
        this.intersect(tos);
    }

    public void pushDisable() {
        Entry rect = this.push();
        rect.disabled = true;
    }

    public void pop() {
        if (this.numClipRects == 0) {
            this.underflow();
        }
        --this.numClipRects;
    }

    public boolean isClipEmpty() {
        Entry tos = this.clipRects[this.numClipRects - 1];
        return tos.isEmpty() && !tos.disabled;
    }

    public boolean getClipRect(Rect rect) {
        if (this.numClipRects == 0) {
            return false;
        }
        Entry tos = this.clipRects[this.numClipRects - 1];
        rect.set(tos);
        return !tos.disabled;
    }

    public int getStackSize() {
        return this.numClipRects;
    }

    public void clearStack() {
        this.numClipRects = 0;
    }

    protected Entry push() {
        Entry rect;
        if (this.numClipRects == this.clipRects.length) {
            this.grow();
        }
        if ((rect = this.clipRects[this.numClipRects]) == null) {
            this.clipRects[this.numClipRects] = rect = new Entry();
        }
        rect.disabled = false;
        ++this.numClipRects;
        return rect;
    }

    protected void intersect(Rect tos) {
        if (this.numClipRects > 1) {
            Entry prev = this.clipRects[this.numClipRects - 2];
            if (!prev.disabled) {
                tos.intersect(prev);
            }
        }
    }

    private void grow() {
        Entry[] newRects = new Entry[this.numClipRects * 2];
        System.arraycopy(this.clipRects, 0, newRects, 0, this.numClipRects);
        this.clipRects = newRects;
    }

    private void underflow() {
        throw new IllegalStateException("empty");
    }

    protected static class Entry
    extends Rect {
        boolean disabled;

        protected Entry() {
        }
    }
}

