package uk.co.toomuchminecraft.sabermod;

import java.util.Random;

import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import cpw.mods.fml.common.IWorldGenerator;

public class OreGenerator implements IWorldGenerator
{

	@Override
	public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider)
	{
		switch (world.provider.dimensionId)
        {
            case 0:
                generateSurface(world, random, chunkX*16, chunkZ*16);
                break;
        }
	}

	private void generateSurface(World world, Random random, int i, int j)
	{
		for (int k = 0; k < 1; k++)
        {
            int l1 = i + random.nextInt(16);
            int i3 = random.nextInt(16);
            int j4 = j + random.nextInt(16);
            (new WorldGenMinable(SaberMod.oreAmethyst.blockID, 8)).generate(world, random, l1, i3, j4);
        }
        for (int k = 0; k < 1; k++)
        {
            int l1 = i + random.nextInt(16);
            int i3 = random.nextInt(16);
            int j4 = j + random.nextInt(16);
            (new WorldGenMinable(SaberMod.oreRuby.blockID, 8)).generate(world, random, l1, i3, j4);
        }
        for (int k = 0; k < 1; k++)
        {
            int l1 = i + random.nextInt(16);
            int i3 = random.nextInt(16);
            int j4 = j + random.nextInt(16);
            (new WorldGenMinable(SaberMod.oreAmber.blockID, 8)).generate(world, random, l1, i3, j4);
        }
        for (int k = 0; k < 1; k++)
        {
            int l1 = i + random.nextInt(16);
            int i3 = random.nextInt(16);
            int j4 = j + random.nextInt(16);
            (new WorldGenMinable(SaberMod.oreOnyx.blockID, 8)).generate(world, random, l1, i3, j4);
        }
        for (int k = 0; k < 1; k++)
        {
            int l1 = i + random.nextInt(16);
            int i3 = random.nextInt(16);
            int j4 = j + random.nextInt(16);
            (new WorldGenMinable(SaberMod.oreJade.blockID, 8)).generate(world, random, l1, i3, j4);
        }
        for (int k = 0; k < 1; k++)
        {
            int l1 = i + random.nextInt(16);
            int i3 = random.nextInt(16);
            int j4 = j + random.nextInt(16);
            (new WorldGenMinable(SaberMod.oreIolite.blockID, 8)).generate(world, random, l1, i3, j4);
        }
        for (int k = 0; k < 1; k++)
        {
            int l1 = i + random.nextInt(16);
            int i3 = random.nextInt(16);
            int j4 = j + random.nextInt(16);
            (new WorldGenMinable(SaberMod.oreSapphire.blockID, 8)).generate(world, random, l1, i3, j4);
        }
        for (int k = 0; k < 1; k++)
        {
            int l1 = i + random.nextInt(16);
            int i3 = random.nextInt(16);
            int j4 = j + random.nextInt(16);
            (new WorldGenMinable(SaberMod.oreTopaz.blockID, 8)).generate(world, random, l1, i3, j4);
        }
		for (int k = 0; k < 1; k++)
        {
            int l1 = i + random.nextInt(16);
            int i3 = random.nextInt(16);
            int j4 = j + random.nextInt(16);
            (new WorldGenMinable(SaberMod.orePower.blockID, 1)).generate(world, random, l1, i3, j4);
        }
	}

}
