package uk.co.toomuchminecraft.sabermod;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.world.World;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;

public class PacketHandler implements IPacketHandler
{
	@SideOnly(Side.CLIENT)
	Minecraft mc;
	
	@Override
	public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player)
	{
		if (packet.channel.equals("SaberExtend"))
		{
			handleExtendPacket(packet, player);
		}
		
		if (packet.channel.equals("SaberSound"))
		{
			handleSoundPacket(packet, player);
		}
	}

	private void handleExtendPacket(Packet250CustomPayload packet, Player player)
	{
		DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.data));
		
    	int itemID;
    	int itemDamage;
    	int slot;
    	int action;
    	int saberID;
    	
		try
		{
			itemID = inputStream.readInt();
			itemDamage = inputStream.readInt();
			slot = inputStream.readInt();
			action = inputStream.readInt();
			saberID = inputStream.readInt();
		}
		catch (IOException e)
		{
			e.printStackTrace();
			return;
		}
		
		Side side = FMLCommonHandler.instance().getEffectiveSide();
		if (side == Side.SERVER)
		{
			extendSaber(saberID, action, (EntityPlayerMP)player);
			PacketDispatcher.sendPacketToAllPlayers(packet);
			closeInventoryChange((EntityPlayerMP)player);
		}
		else if (side == Side.CLIENT)
		{
			extendSaber(saberID, action, (EntityClientPlayerMP)player);
			closeInventoryChange((EntityClientPlayerMP)player);
		}
	}
	
	private void handleSoundPacket(Packet250CustomPayload packet, Player player)
	{
		DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.data));
		
    	int sound;
    	
		try
		{
			sound = inputStream.readInt();
		}
		catch (IOException e)
		{
			e.printStackTrace();
			return;
		}
		
		Side side = FMLCommonHandler.instance().getEffectiveSide();
		if (side == Side.SERVER)
		{
			playSound(sound, (EntityPlayer)player);
		}
	}
	
	private void playSound(int sound, EntityPlayer player)
	{
		World world = player.worldObj;
		if(sound == 0)
		{
			world.playSoundAtEntity(player, "sabermod.sabers.saberoff", 1F, 1F);
		}
		if(sound == 1)
		{
			world.playSoundAtEntity(player, "sabermod.sabers.saberon", 1F, 1F);
		}
		if(sound == 2)
		{
			world.playSoundAtEntity(player, "sabermod.sabers.saberswing", 1F, 1F);
		}
		if(sound == 3)
		{
			world.playSoundAtEntity(player, "sabermod.blaster.blasterammo", 1F, 1F);
		}
		if(sound == 4)
		{
			world.playSoundAtEntity(player, "sabermod.blaster.blastershoot", 1F, 1F);
		}
	}
	
	private void closeInventoryChange(EntityClientPlayerMP player)
	{
		player.inventory.inventoryChanged = false;
	}
	
	private void closeInventoryChange(EntityPlayerMP player)
	{
		player.inventory.inventoryChanged = false;
	}
	
	private void extendSaber(int saberID, int action, EntityPlayerMP player)
    {
		
		
		if(saberID == 0)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberPurpleOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberPurpleOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 1)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberRedOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberRedOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 2)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberYellowOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberYellowOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 3)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberGreenOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberGreenOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 4)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberBlackOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberBlackOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 5)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberIndigoOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberIndigoOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 6)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberDarkBlueOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberDarkBlueOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 7)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberGoldOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberGoldOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 8)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberLightBlueOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberLightBlueOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    }
	
	private void extendSaber(int saberID, int action, EntityClientPlayerMP player)
    {
		
		
		if(saberID == 0)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberPurpleOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberPurpleOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 1)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberRedOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberRedOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 2)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberYellowOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberYellowOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 3)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberGreenOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberGreenOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 4)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberBlackOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberBlackOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 5)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberIndigoOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberIndigoOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 6)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberDarkBlueOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberDarkBlueOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 7)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberGoldOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberGoldOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    	if(saberID == 8)
    	{
    		if(action == 0)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberLightBlueOff.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    		if(action == 1)
    		{
    			InventoryPlayer inventoryplayer = player.inventory;
    			inventoryplayer.setInventorySlotContents(inventoryplayer.currentItem, new ItemStack(SaberMod.saberLightBlueOn.itemID, 1, inventoryplayer.getCurrentItem().getItemDamage()));
    			player.inventory.inventoryChanged = true;
    		}
    	}
    }
}