package uk.co.toomuchminecraft.sabermod;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.world.World;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cpw.mods.fml.common.network.PacketDispatcher;

public class SaberBlaster extends Item
{

	public SaberBlaster(int par1)
	{
		super(par1);
		this.iconIndex = 72;
		this.bFull3D = true;
		setCreativeTab(CreativeTabs.tabCombat);
		this.maxStackSize = 1;
		this.setMaxDamage(500);
	}
	
	@Override
	public String getTextureFile()
	{
		return "/SaberMod/items.png";
	}
	
    /**
     * Returns a slot index in main inventory containing a specific itemID
     */
    private ItemStack getInventoryFirstItemStack(EntityPlayer par2EntityPlayer)
    {
        for (int var1 = 0; var1 < par2EntityPlayer.inventory.mainInventory.length; ++var1)
        {
            if (par2EntityPlayer.inventory.mainInventory[var1] != null && par2EntityPlayer.inventory.mainInventory[var1].itemID == SaberMod.blasterBattery.itemID)
            {
            	if(par2EntityPlayer.inventory.getStackInSlot(var1).getItemDamage() > 0)
            	{
            		return par2EntityPlayer.inventory.getStackInSlot(var1);
            	}
            }
        }
        
        return null;
    }
    
    @SideOnly(Side.CLIENT)
    private void getSoundToPlay(EntityPlayer par2EntityPlayer)
    {
    	ItemStack stack = null;
        for (int var1 = 0; var1 < par2EntityPlayer.inventory.mainInventory.length; ++var1)
        {
            if (par2EntityPlayer.inventory.mainInventory[var1] != null && par2EntityPlayer.inventory.mainInventory[var1].itemID == SaberMod.blasterBattery.itemID)
            {
            		stack = par2EntityPlayer.inventory.getStackInSlot(var1);
            }
        }
        
        if(stack != null)
        {
        	if(stack.getItemDamage() > 0)
        	{
        		sendSoundPacket(4);
        	}
        	else
        	{
        		sendSoundPacket(3);
        	}
        }
    }
	
    /**
     * Called whenever this item is equipped and the right mouse button is pressed. Args: itemStack, world, entityPlayer
     */
    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer)
    {
    	if(getInventoryFirstItemStack(par3EntityPlayer) != null)
    	{
    		EntityBlast blast = new EntityBlast(par2World, par3EntityPlayer);
    		if (!par2World.isRemote)
    		{
    			par2World.spawnEntityInWorld(blast);
        		getSoundToPlay(par3EntityPlayer);
    		}
    		if(!par3EntityPlayer.capabilities.isCreativeMode)
    		{
    			getInventoryFirstItemStack(par3EntityPlayer).setItemDamage(getInventoryFirstItemStack(par3EntityPlayer).getItemDamage() - 1);
    		}
    	}
    	return par1ItemStack;
    }
    
    @SideOnly(Side.CLIENT)
    private void sendSoundPacket(int sound)
    {
    	
    	ByteArrayOutputStream bos = new ByteArrayOutputStream(4);
    	DataOutputStream outputStream = new DataOutputStream(bos);
    	try
    	{
    		outputStream.writeInt(sound);
    	}
    	catch (Exception ex)
    	{
    		ex.printStackTrace();
    	}

    	Packet250CustomPayload packet = new Packet250CustomPayload();
    	packet.channel = "SaberSound";
    	packet.data = bos.toByteArray();
    	packet.length = bos.size();
    	PacketDispatcher.sendPacketToServer(packet);
    }
}
