package uk.co.toomuchminecraft.sabermod;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class SaberPigment extends Item
{
	
	public SaberPigment(int par1, int par2)
	{
		super(par1);
		setIconIndex(par2);
		setCreativeTab(CreativeTabs.tabMaterials);
		this.maxStackSize = 1;
	}
	
	@Override
	public String getTextureFile()
	{
		return "/SaberMod/items.png";
	}
	
	@Override
    public int getIconFromDamage(int par1)
    {
		switch(par1)
		{
			case 0 : par1 = iconIndex + 0;
			break;
			case 1:  par1 = iconIndex + 1;
			break; 
			case 2:  par1 = iconIndex + 2;
			break; 
			case 3:  par1 = iconIndex + 3;
			break; 
			case 4:  par1 = iconIndex + 4;
			break; 
			case 5:  par1 = iconIndex + 5;
			break; 
			case 6:  par1 = iconIndex + 6;
			break; 
			case 7:  par1 = iconIndex + 7;
			break; 
			case 8:  par1 = iconIndex + 8;
			break; 
			default: par1 = iconIndex; 
		}
		return par1;
    }
	
	public String getItemDisplayName(ItemStack par0) 
	{
		String par1 = "";  
		switch(par0.getItemDamage())
		{
			case 0 : par1 = SaberMod.pigmentNames[0] + " saber pigment";
			break;
			case 1:  par1 = SaberMod.pigmentNames[1] + " saber pigment";
			break; 
			case 2:  par1 = SaberMod.pigmentNames[2] + " saber pigment";
			break; 
			case 3:  par1 = SaberMod.pigmentNames[3] + " saber pigment";
			break; 
			case 4:  par1 = SaberMod.pigmentNames[4] + " saber pigment";
			break; 
			case 5:  par1 = SaberMod.pigmentNames[5] + " saber pigment";
			break; 
			case 6:  par1 = SaberMod.pigmentNames[6] + " saber pigment";
			break; 
			case 7:  par1 = SaberMod.pigmentNames[7] + " saber pigment";
			break; 
			case 8:  par1 = SaberMod.pigmentNames[8] + " saber pigment";
			break; 
			default: par1 = "Error"; 
		}
		return par1;
	}
	
	@SideOnly(Side.CLIENT)
	public void getSubItems(int par1, CreativeTabs tab, List subItems)
	{
		for (int x = 0; x < SaberMod.pigmentNames.length; x++)
		{
			subItems.add(new ItemStack(this, 1, x));
		}
	}
}
