package uk.co.toomuchminecraft.sabermod.client;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.item.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import uk.co.toomuchminecraft.sabermod.CommonProxy;
import uk.co.toomuchminecraft.sabermod.EntityBlast;
import uk.co.toomuchminecraft.sabermod.EntityEwok;
import uk.co.toomuchminecraft.sabermod.EntityJawa;
import uk.co.toomuchminecraft.sabermod.EntityStormTrooper;
import uk.co.toomuchminecraft.sabermod.SaberMod;

public class ClientProxy extends CommonProxy
{
	
	@Override
	public void addNames()
	{
		
		//Star maps
		for (int x = 0; x < SaberMod.starMapNames.length; x++)
		{
			ItemStack starMap = new ItemStack(SaberMod.starMap, 1, x);
			LanguageRegistry.addName(starMap, "Star Map: " + SaberMod.starMapNames[x]);
		}
		
		//Blasters
		for (int x = 0; x < 15; x++)
		{
			ItemStack blasterBattery = new ItemStack(SaberMod.blasterBattery, 1, x);
			LanguageRegistry.addName(blasterBattery, "Blaster Battery (" + x + ")");
		}
		
		LanguageRegistry.addName(SaberMod.blaster, "Blaster");
		
		//Saber Construction
		for (int x = 0; x < SaberMod.pigmentNames.length; x++)
		{
			ItemStack pigment = new ItemStack(SaberMod.pigmentGenerator, 1, x);
			LanguageRegistry.addName(pigment, SaberMod.pigmentNames[x] + " saber pigment");
		}
		
		//Random
		LanguageRegistry.addName(SaberMod.energyCore, "Energy Core");
		LanguageRegistry.addName(SaberMod.beamFocuser, "Beam Focuser");
		LanguageRegistry.addName(SaberMod.batteryCharge, "Battery Charge");
		
		//Mobs
		LanguageRegistry.instance().addStringLocalization("entity.Jawa.name", "Jawa");
		LanguageRegistry.instance().addStringLocalization("entity.Ewok.name", "Ewok");
		LanguageRegistry.instance().addStringLocalization("entity.StormTrooper.name", "Storm Trooper");
		
		// gem ores
		LanguageRegistry.addName(SaberMod.oreAmethyst, "Amethyst Ore");
		LanguageRegistry.addName(SaberMod.oreRuby, "Ruby Ore");
		LanguageRegistry.addName(SaberMod.oreAmber, "Amber Ore");
		LanguageRegistry.addName(SaberMod.oreOnyx, "Onyx Ore");
		LanguageRegistry.addName(SaberMod.oreJade, "Jade Ore");
		LanguageRegistry.addName(SaberMod.oreIolite, "Iolite Ore");
		LanguageRegistry.addName(SaberMod.oreSapphire, "Sapphire Ore");
		LanguageRegistry.addName(SaberMod.oreTopaz, "Topaz Ore");
		LanguageRegistry.addName(SaberMod.orePower, "Power Ore");

		// gem blocks
		LanguageRegistry.addName(SaberMod.blockAmethyst, "Amethyst Block");
		LanguageRegistry.addName(SaberMod.blockRuby, "Ruby Block");
		LanguageRegistry.addName(SaberMod.blockAmber, "Amber Block");
		LanguageRegistry.addName(SaberMod.blockOnyx, "Onyx Block");
		LanguageRegistry.addName(SaberMod.blockJade, "Jade Block");
		LanguageRegistry.addName(SaberMod.blockIolite, "Iolite Block");
		LanguageRegistry.addName(SaberMod.blockSapphire, "Sapphire Block");
		LanguageRegistry.addName(SaberMod.blockTopaz, "Topaz Block");
		LanguageRegistry.addName(SaberMod.blockPower, "Power Block");

		// gems
		LanguageRegistry.addName(SaberMod.gemAmethyst, "Amethyst");
		LanguageRegistry.addName(SaberMod.gemRuby, "Ruby");
		LanguageRegistry.addName(SaberMod.gemAmber, "Amber");
		LanguageRegistry.addName(SaberMod.gemOnyx, "Onyx");
		LanguageRegistry.addName(SaberMod.gemJade, "Jade");
		LanguageRegistry.addName(SaberMod.gemIolite, "Iolite");
		LanguageRegistry.addName(SaberMod.gemSapphire, "Sapphire");
		LanguageRegistry.addName(SaberMod.gemTopaz, "Topaz");
		LanguageRegistry.addName(SaberMod.gemPower, "Power Crystal");
		
		//lens
		LanguageRegistry.addName(SaberMod.lens, "Lens");

		// gem tools
		// - Amethyst
		LanguageRegistry.addName(SaberMod.swordAmethyst, "Amethyst Sword");
		LanguageRegistry.addName(SaberMod.pickaxeAmethyst, "Amethyst Pickaxe");
		LanguageRegistry.addName(SaberMod.spadeAmethyst, "Amethyst Spade");
		LanguageRegistry.addName(SaberMod.axeAmethyst, "Amethyst Axe");
		LanguageRegistry.addName(SaberMod.hoeAmethyst, "Amethyst Hoe");

		// - Ruby
		LanguageRegistry.addName(SaberMod.swordRuby, "Ruby Sword");
		LanguageRegistry.addName(SaberMod.pickaxeRuby, "Ruby Pickaxe");
		LanguageRegistry.addName(SaberMod.spadeRuby, "Ruby Spade");
		LanguageRegistry.addName(SaberMod.axeRuby, "Ruby Axe");
		LanguageRegistry.addName(SaberMod.hoeRuby, "Ruby Hoe");

		// - Amber
		LanguageRegistry.addName(SaberMod.swordAmber, "Amber Sword");
		LanguageRegistry.addName(SaberMod.pickaxeAmber, "Amber Pickaxe");
		LanguageRegistry.addName(SaberMod.spadeAmber, "Amber Spade");
		LanguageRegistry.addName(SaberMod.axeAmber, "Amber Axe");
		LanguageRegistry.addName(SaberMod.hoeAmber, "Amber Hoe");

		// - Onyx
		LanguageRegistry.addName(SaberMod.swordOnyx, "Onyx Sword");
		LanguageRegistry.addName(SaberMod.pickaxeOnyx, "Onyx Pickaxe");
		LanguageRegistry.addName(SaberMod.spadeOnyx, "Onyx Spade");
		LanguageRegistry.addName(SaberMod.axeOnyx, "Onyx Axe");
		LanguageRegistry.addName(SaberMod.hoeOnyx, "Onyx Hoe");

		// - Jade
		LanguageRegistry.addName(SaberMod.swordJade, "Jade Sword");
		LanguageRegistry.addName(SaberMod.pickaxeJade, "Jade Pickaxe");
		LanguageRegistry.addName(SaberMod.spadeJade, "Jade Spade");
		LanguageRegistry.addName(SaberMod.axeJade, "Jade Axe");
		LanguageRegistry.addName(SaberMod.hoeJade, "Jade Hoe");

		// - Iolite
		LanguageRegistry.addName(SaberMod.swordIolite, "Iolite Sword");
		LanguageRegistry.addName(SaberMod.pickaxeIolite, "Iolite Pickaxe");
		LanguageRegistry.addName(SaberMod.spadeIolite, "Iolite Spade");
		LanguageRegistry.addName(SaberMod.axeIolite, "Iolite Axe");
		LanguageRegistry.addName(SaberMod.hoeIolite, "Iolite Hoe");

		// - Sapphire
		LanguageRegistry.addName(SaberMod.swordSapphire, "Sapphire Sword");
		LanguageRegistry.addName(SaberMod.pickaxeSapphire, "Sapphire Pickaxe");
		LanguageRegistry.addName(SaberMod.spadeSapphire, "Sapphire Spade");
		LanguageRegistry.addName(SaberMod.axeSapphire, "Sapphire Axe");
		LanguageRegistry.addName(SaberMod.hoeSapphire, "Sapphire Hoe");

		// - Topaz
		LanguageRegistry.addName(SaberMod.swordTopaz, "Topaz Sword");
		LanguageRegistry.addName(SaberMod.pickaxeTopaz, "Topaz Pickaxe");
		LanguageRegistry.addName(SaberMod.spadeTopaz, "Topaz Spade");
		LanguageRegistry.addName(SaberMod.axeTopaz, "Topaz Axe");
		LanguageRegistry.addName(SaberMod.hoeTopaz, "Topaz Hoe");

		// gem armour
		// - Amethyst
		LanguageRegistry.addName(SaberMod.helmetAmethyst, "Amethyst Helmet");
		LanguageRegistry.addName(SaberMod.chestplateAmethyst, "Amethyst Chestplate");
		LanguageRegistry.addName(SaberMod.leggingsAmethyst, "Amethyst Leggings");
		LanguageRegistry.addName(SaberMod.bootsAmethyst, "Amethyst Boots");

		// - Ruby
		LanguageRegistry.addName(SaberMod.helmetRuby, "Ruby Helmet");
		LanguageRegistry.addName(SaberMod.chestplateRuby, "Ruby Chestplate");
		LanguageRegistry.addName(SaberMod.leggingsRuby, "Ruby Leggings");
		LanguageRegistry.addName(SaberMod.bootsRuby, "Ruby Boots");

		// - Amber
		LanguageRegistry.addName(SaberMod.helmetAmber, "Amber Helmet");
		LanguageRegistry.addName(SaberMod.chestplateAmber, "Amber Chestplate");
		LanguageRegistry.addName(SaberMod.leggingsAmber, "Amber Leggings");
		LanguageRegistry.addName(SaberMod.bootsAmber, "Amber Boots");

		// - Onyx
		LanguageRegistry.addName(SaberMod.helmetOnyx, "Onyx Helmet");
		LanguageRegistry.addName(SaberMod.chestplateOnyx, "Onyx Chestplate");
		LanguageRegistry.addName(SaberMod.leggingsOnyx, "Onyx Leggings");
		LanguageRegistry.addName(SaberMod.bootsOnyx, "Onyx Boots");

		// - Jade
		LanguageRegistry.addName(SaberMod.helmetJade, "Jade Helmet");
		LanguageRegistry.addName(SaberMod.chestplateJade, "Jade Chestplate");
		LanguageRegistry.addName(SaberMod.leggingsJade, "Jade Leggings");
		LanguageRegistry.addName(SaberMod.bootsJade, "Jade Boots");

		// - Iolite
		LanguageRegistry.addName(SaberMod.helmetIolite, "Iolite Helmet");
		LanguageRegistry.addName(SaberMod.chestplateIolite, "Iolite Chestplate");
		LanguageRegistry.addName(SaberMod.leggingsIolite, "Iolite Leggings");
		LanguageRegistry.addName(SaberMod.bootsIolite, "Iolite Boots");

		// - Sapphire
		LanguageRegistry.addName(SaberMod.helmetSapphire, "Sapphire Helmet");
		LanguageRegistry.addName(SaberMod.chestplateSapphire, "Sapphire Chestplate");
		LanguageRegistry.addName(SaberMod.leggingsSapphire, "Sapphire Leggings");
		LanguageRegistry.addName(SaberMod.bootsSapphire, "Sapphire Boots");

		// - Topaz
		LanguageRegistry.addName(SaberMod.helmetTopaz, "Topaz Helmet");
		LanguageRegistry.addName(SaberMod.chestplateTopaz, "Topaz Chestplate");
		LanguageRegistry.addName(SaberMod.leggingsTopaz, "Topaz Leggings");
		LanguageRegistry.addName(SaberMod.bootsTopaz, "Topaz Boots");
		

		
		//Sabers
		// - Purple
		LanguageRegistry.addName(SaberMod.saberPurpleOff, "Purple Lightsaber");
		LanguageRegistry.addName(SaberMod.saberPurpleOn, "Purple Lightsaber");
		
		// - Red
		LanguageRegistry.addName(SaberMod.saberRedOff, "Red Lightsaber");
		LanguageRegistry.addName(SaberMod.saberRedOn, "Red Lightsaber");
		
		// - Yellow
		LanguageRegistry.addName(SaberMod.saberYellowOff, "Yellow Lightsaber");
		LanguageRegistry.addName(SaberMod.saberYellowOn, "Yellow Lightsaber");
		
		// - Green
		LanguageRegistry.addName(SaberMod.saberGreenOff, "Green Lightsaber");
		LanguageRegistry.addName(SaberMod.saberGreenOn, "Green Lightsaber");
		
		// - Black
		LanguageRegistry.addName(SaberMod.saberBlackOff, "Black Lightsaber");
		LanguageRegistry.addName(SaberMod.saberBlackOn, "Black Lightsaber");
		
		// - Indigo
		LanguageRegistry.addName(SaberMod.saberIndigoOff, "Indigo Lightsaber");
		LanguageRegistry.addName(SaberMod.saberIndigoOn, "Indigo Lightsaber");
		
		// - Dark Blue
		LanguageRegistry.addName(SaberMod.saberDarkBlueOff, "Dark Blue Lightsaber");
		LanguageRegistry.addName(SaberMod.saberDarkBlueOn, "Dark Blue Lightsaber");
		
		// - Gold
		LanguageRegistry.addName(SaberMod.saberGoldOff, "Golden Lightsaber");
		LanguageRegistry.addName(SaberMod.saberGoldOn, "Golden Lightsaber");
		
		// - Light Blue
		LanguageRegistry.addName(SaberMod.saberLightBlueOff, "Light Blue Lightsaber");
		LanguageRegistry.addName(SaberMod.saberLightBlueOn, "Light Blue Lightsaber");
	}
	
	@Override
	public void preloadTextures()
	{
		//textures
		MinecraftForgeClient.preloadTexture("/SaberMod/terrain.png");
		MinecraftForgeClient.preloadTexture("/SaberMod/items.png");
		
		//Entities
		MinecraftForgeClient.preloadTexture("/SaberMod/blast.png");
		
		//mobs
		MinecraftForgeClient.preloadTexture("/SaberMod/mobs/jawa.png");
		MinecraftForgeClient.preloadTexture("/SaberMod/mobs/ewok.png");
		MinecraftForgeClient.preloadTexture("/SaberMod/mobs/stormtrooper.png");
		
		// - armour
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/amethyst_1.png");
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/amethyst_2.png");
		
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/ruby_1.png");
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/ruby_2.png");
		
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/amber_1.png");
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/amber_2.png");
		
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/onyx_1.png");
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/onyx_2.png");
		
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/jade_1.png");
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/jade_2.png");
		
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/iolite_1.png");
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/iolite_2.png");
		
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/sapphire_1.png");
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/sapphire_2.png");
		
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/topaz_1.png");
		MinecraftForgeClient.preloadTexture("/SaberMod/armor/topaz_2.png");
	}
	
	@Override
	public void initializeRenderers()
	{
		SaberMod.amethystRenderer = ModLoader.addArmor("Amethyst");
		SaberMod.rubyRenderer = ModLoader.addArmor("Ruby");
		SaberMod.amberRenderer = ModLoader.addArmor("Amber");
		SaberMod.jadeRenderer = ModLoader.addArmor("Jade");
		SaberMod.ioliteRenderer = ModLoader.addArmor("Iolite");
		SaberMod.onyxRenderer = ModLoader.addArmor("Onyx");
		SaberMod.sapphireRenderer = ModLoader.addArmor("Sapphire");
		SaberMod.topazRenderer = ModLoader.addArmor("Topaz");
	}
	
	@Override
	public void registerTickHandler()
	{
		TickRegistry.registerTickHandler(new ClientTickHandler(), Side.CLIENT);
	}
	
	@Override
	public void registerKeyBindings()
	{
		KeyBindingRegistry.registerKeyBinding(new SaberExtendKeyHandler());
		KeyBindingRegistry.registerKeyBinding(new ForceUseKeyHandler());
		KeyBindingRegistry.registerKeyBinding(new ForceSelectKeyHandler());
	}
	
	@Override
	public void initializeSounds()
	{
		MinecraftForge.EVENT_BUS.register(new SaberSounds());
	}
	
	@Override
	public void renderEntities()
	{
		RenderingRegistry.registerEntityRenderingHandler(EntityJawa.class, new RenderJawa(new ModelJawa(), 0.5f));
		RenderingRegistry.registerEntityRenderingHandler(EntityEwok.class, new RenderEwok(new ModelEwok(), 0.5f));
		RenderingRegistry.registerEntityRenderingHandler(EntityStormTrooper.class, new RenderStormTrooper());
		RenderingRegistry.registerEntityRenderingHandler(EntityBlast.class, new RenderBlast());
	}
}
