package uk.co.toomuchminecraft.sabermod.client;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.EnumSet;
import java.util.Random;

import uk.co.toomuchminecraft.sabermod.SaberMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.src.ModLoader;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.PacketDispatcher;

public class ClientTickHandler implements ITickHandler
{
	private long lastPlayed;
	Minecraft mc;
	
	public ClientTickHandler()
	{
		mc = ModLoader.getMinecraftInstance();
	}
	
    @Override
    public void tickStart(EnumSet<TickType> type, Object... tickData) {}

    @Override
    public void tickEnd(EnumSet<TickType> type, Object... tickData)
    {
        if (type.equals(EnumSet.of(TickType.RENDER)))
        {
            onRenderTick();
        }
        else if (type.equals(EnumSet.of(TickType.CLIENT)))
        {
            GuiScreen guiscreen = Minecraft.getMinecraft().currentScreen;
            if (guiscreen != null)
            {
                onTickInGUI(guiscreen);
            }
            else 
            {
                onTickInGame();
            }
        }
    }

    @Override
    public EnumSet<TickType> ticks()
    {
        return EnumSet.of(TickType.RENDER, TickType.CLIENT);
        // In my testing only RENDER, CLIENT, & PLAYER did anything on the client side.
        // Read 'cpw.mods.fml.common.TickType.java' for a full list and description of available types
    }

    @Override
    public String getLabel()
    {
    	return null;
    }


    public void onRenderTick()
    {
    	
    }

    public void onTickInGUI(GuiScreen guiscreen)
    {
    	
    }

    public void onTickInGame()
    {
    	Random rand = new Random();
        rand.nextInt(8);
        if (mc.gameSettings.keyBindAttack.pressed)
        {
            if (mc.theWorld.getWorldTime() >= lastPlayed + 5)
            {
                ItemStack itemstack = mc.thePlayer.inventory.getCurrentItem();
                                                                                                            
                if(itemstack != null)
                {
                    if(itemstack.itemID == SaberMod.saberPurpleOn.itemID)
                    {
                    	sendSoundPacket(2);
                    }
                    
                    if(itemstack.itemID == SaberMod.saberRedOn.itemID)
                    {
                    	sendSoundPacket(2);
                    }
                    
                    if(itemstack.itemID == SaberMod.saberYellowOn.itemID)
                    {
                    	sendSoundPacket(2);
                    }
                    
                    if(itemstack.itemID == SaberMod.saberGreenOn.itemID)
                    {
                    	sendSoundPacket(2);
                    }
                    
                    if(itemstack.itemID == SaberMod.saberBlackOn.itemID)
                    {
                    	sendSoundPacket(2);
                    }
                    
                    if(itemstack.itemID == SaberMod.saberIndigoOn.itemID)
                    {
                    	sendSoundPacket(2);
                    }
                    
                    if(itemstack.itemID == SaberMod.saberDarkBlueOn.itemID)
                    {
                    	sendSoundPacket(2);
                    }
                    
                    if(itemstack.itemID == SaberMod.saberGoldOn.itemID)
                    {
                    	sendSoundPacket(2);
                    }
                    
                    if(itemstack.itemID == SaberMod.saberLightBlueOn.itemID)
                    {
                        sendSoundPacket(2);
                    }
                }
            }
            lastPlayed = mc.theWorld.getWorldTime();
        }
    }
    
    private void sendSoundPacket(int sound)
    {
    	
    	ByteArrayOutputStream bos = new ByteArrayOutputStream(4);
    	DataOutputStream outputStream = new DataOutputStream(bos);
    	try
    	{
    		outputStream.writeInt(sound);
    	}
    	catch (Exception ex)
    	{
    		ex.printStackTrace();
    	}

    	Packet250CustomPayload packet = new Packet250CustomPayload();
    	packet.channel = "SaberSound";
    	packet.data = bos.toByteArray();
    	packet.length = bos.size();
    	PacketDispatcher.sendPacketToServer(packet);
    }
}