/*
 * Decompiled with CFR 0.152.
 */
package b.a.a;

import b.a.Channel;
import b.a.FilenameURL;
import b.a.ListenerData;
import b.a.SoundBuffer;
import b.a.SoundSystemConfig;
import b.a.Source;
import b.a.Vector3D;
import b.a.a.ChannelJavaSound;
import b.a.a.LibraryJavaSound;
import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;

public class SourceJavaSound
extends Source {
    protected ChannelJavaSound channelJavaSound;
    public ListenerData listener;
    private float pan;

    public SourceJavaSound(ListenerData listenerData, boolean bl2, boolean bl3, boolean bl4, String string, FilenameURL filenameURL, SoundBuffer soundBuffer, float f10, float f11, float f12, int n10, float f13, boolean bl5) {
        super(bl2, bl3, bl4, string, filenameURL, soundBuffer, f10, f11, f12, n10, f13, bl5);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        this.pan = 0.0f;
        this.libraryType = LibraryJavaSound.class;
        this.listener = listenerData;
        this.positionChanged();
    }

    public SourceJavaSound(ListenerData listenerData, Source source, SoundBuffer soundBuffer) {
        super(source, soundBuffer);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        this.pan = 0.0f;
        this.libraryType = LibraryJavaSound.class;
        this.listener = listenerData;
        this.positionChanged();
    }

    public SourceJavaSound(ListenerData listenerData, AudioFormat audioFormat, boolean bl2, String string, float f10, float f11, float f12, int n10, float f13) {
        super(audioFormat, bl2, string, f10, f11, f12, n10, f13);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        this.pan = 0.0f;
        this.libraryType = LibraryJavaSound.class;
        this.listener = listenerData;
        this.positionChanged();
    }

    public void cleanup() {
        super.cleanup();
    }

    public void changeSource(boolean bl2, boolean bl3, boolean bl4, String string, FilenameURL filenameURL, SoundBuffer soundBuffer, float f10, float f11, float f12, int n10, float f13, boolean bl5) {
        super.changeSource(bl2, bl3, bl4, string, filenameURL, soundBuffer, f10, f11, f12, n10, f13, bl5);
        if (this.channelJavaSound != null) {
            this.channelJavaSound.setLooping(bl4);
        }
        this.positionChanged();
    }

    public void listenerMoved() {
        this.positionChanged();
    }

    public void setVelocity(float f10, float f11, float f12) {
        super.setVelocity(f10, f11, f12);
        this.positionChanged();
    }

    public void setPosition(float f10, float f11, float f12) {
        super.setPosition(f10, f11, f12);
        this.positionChanged();
    }

    public void positionChanged() {
        this.calculateGain();
        this.calculatePan();
        this.calculatePitch();
    }

    public void setPitch(float f10) {
        super.setPitch(f10);
        this.calculatePitch();
    }

    public void setAttenuation(int n10) {
        super.setAttenuation(n10);
        this.calculateGain();
    }

    public void setDistOrRoll(float f10) {
        super.setDistOrRoll(f10);
        this.calculateGain();
    }

    public void play(Channel channel) {
        boolean bl2;
        if (!this.active()) {
            if (this.toLoop) {
                this.toPlay = true;
            }
            return;
        }
        if (channel == null) {
            this.errorMessage("Unable to play source, because channel was null");
            return;
        }
        boolean bl3 = bl2 = this.channel != channel;
        if (this.channel != null && this.channel.attachedSource != this) {
            bl2 = true;
        }
        boolean bl4 = this.paused();
        boolean bl5 = this.stopped();
        super.play(channel);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        if (bl2) {
            if (this.channelJavaSound != null) {
                this.channelJavaSound.setLooping(this.toLoop);
            }
            if (!this.toStream) {
                if (this.soundBuffer == null) {
                    this.errorMessage("No sound buffer to play");
                    return;
                }
                this.channelJavaSound.attachBuffer(this.soundBuffer);
            }
        }
        this.positionChanged();
        if (bl5 || !this.playing()) {
            if (this.toStream && !bl4) {
                this.preLoad = true;
            }
            this.channel.play();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preLoad() {
        if (this.codec == null) {
            return false;
        }
        boolean bl2 = false;
        LinkedList<byte[]> linkedList = this.soundSequenceLock;
        synchronized (linkedList) {
            if (this.nextBuffers == null || this.nextBuffers.isEmpty()) {
                bl2 = true;
            }
        }
        linkedList = new LinkedList<byte[]>();
        if (this.nextCodec != null && !bl2) {
            this.codec = this.nextCodec;
            this.nextCodec = null;
            Object object = this.soundSequenceLock;
            synchronized (object) {
                while (!this.nextBuffers.isEmpty()) {
                    this.soundBuffer = (SoundBuffer)this.nextBuffers.remove(0);
                    if (this.soundBuffer == null || this.soundBuffer.audioData == null) continue;
                    linkedList.add(this.soundBuffer.audioData);
                }
            }
        } else {
            this.codec.initialize(this.filenameURL.getURL());
            for (int i10 = 0; i10 < SoundSystemConfig.getNumberStreamingBuffers(); ++i10) {
                this.soundBuffer = this.codec.read();
                if (this.soundBuffer == null || this.soundBuffer.audioData == null) break;
                linkedList.add(this.soundBuffer.audioData);
            }
            this.channelJavaSound.resetStream(this.codec.getAudioFormat());
        }
        this.positionChanged();
        this.channel.preLoadBuffers(linkedList);
        this.preLoad = false;
        return true;
    }

    public void calculateGain() {
        float f10 = this.position.x - this.listener.position.x;
        float f11 = this.position.y - this.listener.position.y;
        float f12 = this.position.z - this.listener.position.z;
        this.distanceFromListener = (float)Math.sqrt(f10 * f10 + f11 * f11 + f12 * f12);
        switch (this.attModel) {
            case 2: {
                if (this.distanceFromListener <= 0.0f) {
                    this.gain = 1.0f;
                    break;
                }
                if (this.distanceFromListener >= this.distOrRoll) {
                    this.gain = 0.0f;
                    break;
                }
                this.gain = 1.0f - this.distanceFromListener / this.distOrRoll;
                break;
            }
            case 1: {
                if (this.distanceFromListener <= 0.0f) {
                    this.gain = 1.0f;
                    break;
                }
                float f13 = 5.0E-4f;
                float f14 = this.distOrRoll * this.distanceFromListener * this.distanceFromListener * f13;
                if (f14 < 0.0f) {
                    f14 = 0.0f;
                }
                this.gain = 1.0f / (1.0f + f14);
                break;
            }
            default: {
                this.gain = 1.0f;
            }
        }
        if (this.gain > 1.0f) {
            this.gain = 1.0f;
        }
        if (this.gain < 0.0f) {
            this.gain = 0.0f;
        }
        this.gain *= this.sourceVolume * SoundSystemConfig.getMasterGain() * Math.abs(this.fadeOutGain) * this.fadeInGain;
        if (this.channel != null && this.channel.attachedSource == this && this.channelJavaSound != null) {
            this.channelJavaSound.setGain(this.gain);
        }
    }

    public void calculatePan() {
        Vector3D vector3D = this.listener.up.cross(this.listener.lookAt);
        vector3D.normalize();
        float f10 = this.position.dot(this.position.subtract(this.listener.position), vector3D);
        float f11 = this.position.dot(this.position.subtract(this.listener.position), this.listener.lookAt);
        vector3D = null;
        float f12 = (float)Math.atan2(f10, f11);
        this.pan = (float)(-Math.sin(f12));
        if (this.channel != null && this.channel.attachedSource == this && this.channelJavaSound != null) {
            if (this.attModel == 0) {
                this.channelJavaSound.setPan(0.0f);
            } else {
                this.channelJavaSound.setPan(this.pan);
            }
        }
    }

    public void calculatePitch() {
        if (this.channel != null && this.channel.attachedSource == this && this.channelJavaSound != null) {
            if (SoundSystemConfig.getDopplerFactor() == 0.0f) {
                this.channelJavaSound.setPitch(this.pitch);
            } else {
                float f10 = 343.3f;
                Vector3D vector3D = this.velocity;
                Vector3D vector3D2 = this.listener.velocity;
                float f11 = SoundSystemConfig.getDopplerVelocity();
                float f12 = SoundSystemConfig.getDopplerFactor();
                Vector3D vector3D3 = this.listener.position.subtract(this.position);
                float f13 = vector3D3.dot(vector3D2) / vector3D3.length();
                float f14 = vector3D3.dot(vector3D) / vector3D3.length();
                f14 = this.min(f14, f10 / f12);
                float f15 = this.pitch * (f10 * f11 - f12 * (f13 = this.min(f13, f10 / f12))) / (f10 * f11 - f12 * f14);
                if (f15 < 0.5f) {
                    f15 = 0.5f;
                } else if (f15 > 2.0f) {
                    f15 = 2.0f;
                }
                this.channelJavaSound.setPitch(f15);
            }
        }
    }

    public float min(float f10, float f11) {
        if (f10 < f11) {
            return f10;
        }
        return f11;
    }
}

