/*
 * Decompiled with CFR 0.152.
 */
package net.Vivid;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class VividCustomFont {
    private int texID;
    private int[] xPos;
    private int[] yPos;
    private int startChar;
    private int endChar;
    private FontMetrics metrics;

    public VividCustomFont(Minecraft mc2, Object font, int size) {
        this(mc2, font, size, 32, 126);
    }

    public VividCustomFont(Minecraft mc2, Object font, int size, int startChar, int endChar) {
        this.startChar = startChar;
        this.endChar = endChar;
        this.xPos = new int[endChar - startChar];
        this.yPos = new int[endChar - startChar];
        BufferedImage img = new BufferedImage(256, 256, 2);
        Graphics g2 = img.getGraphics();
        try {
            if (font instanceof String) {
                String fontName = (String)font;
                if (fontName.contains("Arial")) {
                    g2.setFont(Font.createFont(0, new File(fontName)).deriveFont((float)size));
                } else {
                    g2.setFont(new Font(fontName, 0, size));
                }
            } else if (font instanceof InputStream) {
                g2.setFont(Font.createFont(0, (InputStream)font).deriveFont((float)size));
            } else if (font instanceof File) {
                g2.setFont(Font.createFont(0, (File)font).deriveFont((float)size));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        g2.setColor(new Color(255, 255, 255, 0));
        g2.fillRect(0, 0, 256, 256);
        g2.setColor(Color.white);
        this.metrics = g2.getFontMetrics();
        int x2 = 2;
        int y2 = 2;
        for (int i2 = startChar; i2 < endChar; ++i2) {
            g2.drawString("" + (char)i2, x2, y2 + g2.getFontMetrics().getAscent());
            this.xPos[i2 - startChar] = x2;
            this.yPos[i2 - startChar] = y2 - this.metrics.getMaxDescent();
            if ((x2 += this.metrics.stringWidth("" + (char)i2) + 2) < 250 - this.metrics.getMaxAdvance()) continue;
            x2 = 2;
            y2 += this.metrics.getMaxAscent() + this.metrics.getMaxDescent() + size / 2;
        }
        this.texID = mc2.o.a(img);
    }

    public void drawStringS(ats gui, String text, int x2, int y2, int color) {
        int l2 = color & 0xFF000000;
        int shade = (color & 0xFCFCFC) >> 2;
        this.drawString(gui, text, x2 + 1, y2 + 1, shade += l2);
        this.drawString(gui, text, x2, y2, color);
    }

    public void drawString(ats gui, String text, int x2, int y2, int color) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.texID);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        int startX = x2;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            if (c2 == '\\') {
                char type = text.charAt(i2 + 1);
                if (type == 'n') {
                    y2 += this.metrics.getAscent() + 2;
                    x2 = startX;
                }
                ++i2;
                continue;
            }
            this.drawChar(gui, c2, x2, y2);
            x2 = (int)((double)x2 + this.metrics.getStringBounds("" + c2, null).getWidth());
        }
    }

    public FontMetrics getMetrics() {
        return this.metrics;
    }

    public int getStringWidth(String text) {
        return (int)this.getBounds(text).getWidth();
    }

    public int getStringHeight(String text) {
        return (int)this.getBounds(text).getHeight();
    }

    private Rectangle getBounds(String text) {
        int w2 = 0;
        int h2 = 0;
        int tw2 = 0;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            if (c2 == '\\') {
                char type = text.charAt(i2 + 1);
                if (type == 'n') {
                    h2 += this.metrics.getAscent() + 2;
                    if (tw2 > w2) {
                        w2 = tw2;
                    }
                    tw2 = 0;
                }
                ++i2;
                continue;
            }
            tw2 += this.metrics.stringWidth("" + c2);
        }
        if (tw2 > w2) {
            w2 = tw2;
        }
        return new Rectangle(0, 0, w2, h2 += this.metrics.getAscent());
    }

    private void drawChar(ats gui, char c2, int x2, int y2) {
        Rectangle2D bounds = this.metrics.getStringBounds("" + c2, null);
        gui.b(x2, y2, this.xPos[(byte)c2 - this.startChar], this.yPos[(byte)c2 - this.startChar], (int)bounds.getWidth(), (int)bounds.getHeight() + this.metrics.getMaxDescent());
    }
}

