/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.KeyStroke;
import de.matthiasmann.twl.utils.XMLParser;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public final class InputMap {
    private static final InputMap EMPTY_MAP = new InputMap(new KeyStroke[0]);
    private final KeyStroke[] keyStrokes;

    private InputMap(KeyStroke[] keyStrokes) {
        this.keyStrokes = keyStrokes;
    }

    public String mapEvent(Event event) {
        if (event.isKeyEvent()) {
            int mappedEventModifiers = KeyStroke.convertModifier(event);
            for (KeyStroke ks : this.keyStrokes) {
                if (!ks.match(event, mappedEventModifiers)) continue;
                return ks.getAction();
            }
        }
        return null;
    }

    public InputMap addKeyStrokes(LinkedHashSet<KeyStroke> newKeyStrokes) {
        int size = newKeyStrokes.size();
        if (size == 0) {
            return this;
        }
        KeyStroke[] combined = new KeyStroke[this.keyStrokes.length + size];
        newKeyStrokes.toArray(combined);
        for (KeyStroke ks : this.keyStrokes) {
            if (newKeyStrokes.contains(ks)) continue;
            combined[size++] = ks;
        }
        return new InputMap(InputMap.shrink(combined, size));
    }

    public InputMap addKeyStrokes(InputMap map) {
        if (map == this || map.keyStrokes.length == 0) {
            return this;
        }
        if (this.keyStrokes.length == 0) {
            return map;
        }
        return this.addKeyStrokes(new LinkedHashSet<KeyStroke>(Arrays.asList(map.keyStrokes)));
    }

    public InputMap addKeyStroke(KeyStroke keyStroke) {
        LinkedHashSet<KeyStroke> newKeyStrokes = new LinkedHashSet<KeyStroke>(1, 1.0f);
        newKeyStrokes.add(keyStroke);
        return this.addKeyStrokes(newKeyStrokes);
    }

    public InputMap removeKeyStrokes(Set<KeyStroke> keyStrokes) {
        if (keyStrokes.isEmpty()) {
            return this;
        }
        int size = 0;
        KeyStroke[] result = new KeyStroke[this.keyStrokes.length];
        for (KeyStroke ks : this.keyStrokes) {
            if (keyStrokes.contains(ks)) continue;
            result[size++] = ks;
        }
        return new InputMap(InputMap.shrink(result, size));
    }

    public KeyStroke[] getKeyStrokes() {
        return (KeyStroke[])this.keyStrokes.clone();
    }

    public static InputMap empty() {
        return EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputMap parse(URL url) throws IOException {
        InputMap inputMap;
        XMLParser xmlp = new XMLParser(url);
        try {
            xmlp.require(0, null, null);
            xmlp.nextTag();
            xmlp.require(2, null, "inputMapDef");
            xmlp.nextTag();
            LinkedHashSet<KeyStroke> keyStrokes = InputMap.parseBody(xmlp);
            xmlp.require(3, null, "inputMapDef");
            inputMap = new InputMap(keyStrokes.toArray(new KeyStroke[keyStrokes.size()]));
        }
        catch (Throwable throwable) {
            try {
                xmlp.close();
                throw throwable;
            }
            catch (XmlPullParserException ex) {
                throw (IOException)new IOException("Can't parse XML").initCause(ex);
            }
        }
        xmlp.close();
        return inputMap;
    }

    public void writeXML(OutputStream os) throws IOException {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            XmlSerializer serializer = factory.newSerializer();
            serializer.setOutput(os, "UTF8");
            serializer.startDocument("UTF8", Boolean.TRUE);
            serializer.text("\n");
            serializer.startTag(null, "inputMapDef");
            for (KeyStroke ks : this.keyStrokes) {
                serializer.text("\n    ");
                serializer.startTag(null, "action");
                serializer.attribute(null, "name", ks.getAction());
                serializer.text(ks.getStroke());
                serializer.endTag(null, "action");
            }
            serializer.text("\n");
            serializer.endTag(null, "inputMapDef");
            serializer.endDocument();
        }
        catch (XmlPullParserException ex) {
            throw (IOException)new IOException("Can't generate XML").initCause(ex);
        }
    }

    public static LinkedHashSet<KeyStroke> parseBody(XMLParser xmlp) throws XmlPullParserException, IOException {
        LinkedHashSet<KeyStroke> newStrokes = new LinkedHashSet<KeyStroke>();
        while (!xmlp.isEndTag()) {
            xmlp.require(2, null, "action");
            String name = xmlp.getAttributeNotNull("name");
            String key = xmlp.nextText();
            try {
                KeyStroke ks = KeyStroke.parse(key, name);
                if (!newStrokes.add(ks)) {
                    Logger.getLogger(InputMap.class.getName()).log(Level.WARNING, "Duplicate key stroke: {0}", ks.getStroke());
                }
            }
            catch (IllegalArgumentException ex) {
                throw xmlp.error("can't parse Keystroke", ex);
            }
            xmlp.require(3, null, "action");
            xmlp.nextTag();
        }
        return newStrokes;
    }

    private static KeyStroke[] shrink(KeyStroke[] keyStrokes, int size) {
        if (size != keyStrokes.length) {
            KeyStroke[] tmp = new KeyStroke[size];
            System.arraycopy(keyStrokes, 0, tmp, 0, size);
            keyStrokes = tmp;
        }
        return keyStrokes;
    }
}

