/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Container;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Widget;

public class PopupWindow
extends Container {
    private final Widget owner;
    private boolean closeOnClickedOutside = true;
    private boolean closeOnEscape = true;
    private Runnable requestCloseCallback;

    public PopupWindow(Widget owner) {
        if (owner == null) {
            throw new NullPointerException("owner");
        }
        this.owner = owner;
    }

    public Widget getOwner() {
        return this.owner;
    }

    public boolean isCloseOnClickedOutside() {
        return this.closeOnClickedOutside;
    }

    public void setCloseOnClickedOutside(boolean closeOnClickedOutside) {
        this.closeOnClickedOutside = closeOnClickedOutside;
    }

    public boolean isCloseOnEscape() {
        return this.closeOnEscape;
    }

    public void setCloseOnEscape(boolean closeOnEscape) {
        this.closeOnEscape = closeOnEscape;
    }

    public Runnable getRequestCloseCallback() {
        return this.requestCloseCallback;
    }

    public void setRequestCloseCallback(Runnable requestCloseCallback) {
        this.requestCloseCallback = requestCloseCallback;
    }

    public boolean openPopup() {
        GUI gui = this.owner.getGUI();
        if (gui != null) {
            super.setVisible(true);
            super.setEnabled(true);
            gui.openPopup(this);
            this.requestKeyboardFocus();
            this.focusFirstChild();
            return this.isOpen();
        }
        return false;
    }

    public void openPopupCentered() {
        if (this.openPopup()) {
            this.adjustSize();
            this.centerPopup();
        }
    }

    public void openPopupCentered(int width, int height) {
        if (this.openPopup()) {
            this.setSize(Math.min(this.getParent().getInnerWidth(), width), Math.min(this.getParent().getInnerHeight(), height));
            this.centerPopup();
        }
    }

    public void closePopup() {
        GUI gui = this.getGUI();
        if (gui != null) {
            gui.closePopup(this);
            this.owner.requestKeyboardFocus();
        }
    }

    public final boolean isOpen() {
        return this.getParent() != null;
    }

    public void centerPopup() {
        Widget parent = this.getParent();
        if (parent != null) {
            this.setPosition(parent.getInnerX() + (parent.getInnerWidth() - this.getWidth()) / 2, parent.getInnerY() + (parent.getInnerHeight() - this.getHeight()) / 2);
        }
    }

    public boolean bindMouseDrag(Runnable cb) {
        GUI gui = this.getGUI();
        if (gui != null) {
            return gui.bindDragEvent(this, cb);
        }
        return false;
    }

    @Override
    public int getPreferredWidth() {
        int parentWidth = this.getParent() != null ? this.getParent().getInnerWidth() : Short.MAX_VALUE;
        return Math.min(parentWidth, super.getPreferredWidth());
    }

    @Override
    public int getPreferredHeight() {
        int parentHeight = this.getParent() != null ? this.getParent().getInnerHeight() : Short.MAX_VALUE;
        return Math.min(parentHeight, super.getPreferredHeight());
    }

    @Override
    protected final boolean handleEvent(Event evt) {
        if (this.handleEventPopup(evt)) {
            return true;
        }
        if (evt.getType() == Event.Type.MOUSE_CLICKED && !this.isInside(evt.getMouseX(), evt.getMouseY())) {
            this.mouseClickedOutside(evt);
            return true;
        }
        if (this.closeOnEscape && evt.isKeyPressedEvent() && evt.getKeyCode() == 1) {
            this.requestPopupClose();
            return true;
        }
        return true;
    }

    protected boolean handleEventPopup(Event evt) {
        return super.handleEvent(evt);
    }

    @Override
    protected final boolean isMouseInside(Event evt) {
        return true;
    }

    protected void requestPopupClose() {
        if (this.requestCloseCallback != null) {
            this.requestCloseCallback.run();
        } else {
            this.closePopup();
        }
    }

    protected void mouseClickedOutside(Event evt) {
        if (this.closeOnClickedOutside) {
            this.requestPopupClose();
        }
    }

    @Override
    void setParent(Widget parent) {
        if (!(parent instanceof GUI)) {
            throw new IllegalArgumentException("PopupWindow can't be used as child widget");
        }
        super.setParent(parent);
    }
}

