/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.DynamicImage;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLRenderer;
import de.matthiasmann.twl.renderer.lwjgl.TextureAreaBase;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;

public class LWJGLDynamicImage
extends TextureAreaBase
implements DynamicImage {
    private final LWJGLRenderer renderer;
    private final int target;
    private final Color tintColor;
    private int id;

    public LWJGLDynamicImage(LWJGLRenderer renderer, int target, int id, int width, int height, int texWidth, int texHeight, Color tintColor) {
        super(0, 0, width, height, target == 3553 ? (float)texWidth : 1.0f, target == 3553 ? (float)texHeight : 1.0f);
        this.renderer = renderer;
        this.tintColor = tintColor;
        this.target = target;
        this.id = id;
    }

    LWJGLDynamicImage(LWJGLDynamicImage src, Color tintColor) {
        super(src);
        this.renderer = src.renderer;
        this.tintColor = tintColor;
        this.target = src.target;
        this.id = src.id;
    }

    @Override
    public void destroy() {
        if (this.id != 0) {
            GL11.glDeleteTextures((int)this.id);
            this.renderer.dynamicImages.remove(this);
        }
    }

    @Override
    public void update(ByteBuffer data, DynamicImage.Format format) {
        this.update(0, 0, this.width, this.height, data, this.width * 4, format);
    }

    @Override
    public void update(ByteBuffer data, int stride, DynamicImage.Format format) {
        this.update(0, 0, this.width, this.height, data, stride, format);
    }

    @Override
    public void update(int xoffset, int yoffset, int width, int height, ByteBuffer data, DynamicImage.Format format) {
        this.update(xoffset, yoffset, width, height, data, width * 4, format);
    }

    @Override
    public void update(int xoffset, int yoffset, int width, int height, ByteBuffer data, int stride, DynamicImage.Format format) {
        if (xoffset < 0 || yoffset < 0 || this.getWidth() <= 0 || this.getHeight() <= 0) {
            throw new IllegalArgumentException("Negative offsets or size <= 0");
        }
        if (xoffset >= this.getWidth() || yoffset >= this.getHeight()) {
            throw new IllegalArgumentException("Offset outside of texture");
        }
        if (width > this.getWidth() - xoffset || height > this.getHeight() - yoffset) {
            throw new IllegalArgumentException("Rectangle outside of texture");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (stride < 0 || (stride & 3) != 0) {
            throw new IllegalArgumentException("stride");
        }
        if (stride < width * 4) {
            throw new IllegalArgumentException("stride too short for width");
        }
        if (data.remaining() < stride * (height - 1) + width * 4) {
            throw new IllegalArgumentException("Not enough data remaining in the buffer");
        }
        int glFormat = format == DynamicImage.Format.RGBA ? 6408 : 32993;
        this.bind();
        GL11.glPixelStorei((int)3314, (int)(stride / 4));
        GL11.glTexSubImage2D((int)this.target, (int)0, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)glFormat, (int)5121, (ByteBuffer)data);
        GL11.glPixelStorei((int)3314, (int)0);
    }

    @Override
    public Image createTintedVersion(Color color) {
        if (color == null) {
            throw new NullPointerException("color");
        }
        Color newTintColor = this.tintColor.multiply(color);
        if (newTintColor.equals(this.tintColor)) {
            return this;
        }
        return new LWJGLDynamicImage(this, newTintColor);
    }

    @Override
    public void draw(AnimationState as, int x, int y) {
        this.draw(as, x, y, this.width, this.height);
    }

    @Override
    public void draw(AnimationState as, int x, int y, int width, int height) {
        this.bind();
        this.renderer.tintStack.setColor(this.tintColor);
        if (this.target != 3553) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)this.target);
        }
        GL11.glBegin((int)7);
        this.drawQuad(x, y, width, height);
        GL11.glEnd();
        if (this.target != 3553) {
            GL11.glDisable((int)this.target);
            GL11.glEnable((int)3553);
        }
    }

    private void bind() {
        if (this.id == 0) {
            throw new IllegalStateException("destroyed");
        }
        GL11.glBindTexture((int)this.target, (int)this.id);
    }
}

