/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.MouseCursor;
import de.matthiasmann.twl.renderer.Resource;
import de.matthiasmann.twl.renderer.Texture;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLCursor;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLRenderer;
import de.matthiasmann.twl.renderer.lwjgl.SWCursor;
import de.matthiasmann.twl.renderer.lwjgl.TextureArea;
import de.matthiasmann.twl.renderer.lwjgl.TextureAreaRotated;
import de.matthiasmann.twl.renderer.lwjgl.TextureAreaTiled;
import de.matthiasmann.twl.utils.PNGDecoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Util;

public class LWJGLTexture
implements Texture,
Resource {
    final LWJGLRenderer renderer;
    private int id;
    private final int width;
    private final int height;
    private final int texWidth;
    private final int texHeight;
    private ByteBuffer texData;
    private Format texDataFmt;
    private ArrayList<LWJGLCursor> cursors;

    public LWJGLTexture(LWJGLRenderer renderer, int width, int height, ByteBuffer buf, Format fmt, Filter filter) {
        this.renderer = renderer;
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.id = GL11.glGenTextures();
        if (this.id == 0) {
            throw new OpenGLException("failed to allocate texture ID");
        }
        GL11.glBindTexture((int)3553, (int)this.id);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3317, (int)1);
        if (GLContext.getCapabilities().OpenGL12) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        }
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter.glValue);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter.glValue);
        this.texWidth = LWJGLTexture.roundUpPOT(width);
        this.texHeight = LWJGLTexture.roundUpPOT(height);
        if (this.texWidth != width || this.texHeight != height) {
            GL11.glTexImage2D((int)3553, (int)0, (int)fmt.glInternalFormat, (int)this.texWidth, (int)this.texHeight, (int)0, (int)fmt.glFormat, (int)5121, (ByteBuffer)null);
            if (buf != null) {
                Util.checkGLError();
                GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)fmt.glFormat, (int)5121, (ByteBuffer)buf);
            }
        } else {
            GL11.glTexImage2D((int)3553, (int)0, (int)fmt.glInternalFormat, (int)this.texWidth, (int)this.texHeight, (int)0, (int)fmt.glFormat, (int)5121, (ByteBuffer)buf);
        }
        Util.checkGLError();
        this.width = width;
        this.height = height;
        this.texData = buf;
        this.texDataFmt = fmt;
    }

    @Override
    public void destroy() {
        if (this.id != 0) {
            GL11.glBindTexture((int)3553, (int)0);
            GL11.glDeleteTextures((int)this.id);
            this.id = 0;
        }
        if (this.cursors != null) {
            for (LWJGLCursor cursor : this.cursors) {
                cursor.destroy();
            }
            this.cursors.clear();
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getTexWidth() {
        return this.texWidth;
    }

    public int getTexHeight() {
        return this.texHeight;
    }

    public boolean bind(Color color) {
        if (this.id != 0) {
            GL11.glBindTexture((int)3553, (int)this.id);
            this.renderer.tintStack.setColor(color);
            return true;
        }
        return false;
    }

    public boolean bind() {
        if (this.id != 0) {
            GL11.glBindTexture((int)3553, (int)this.id);
            return true;
        }
        return false;
    }

    @Override
    public Image getImage(int x, int y, int width, int height, Color tintColor, boolean tiled, Texture.Rotation rotation) {
        if (x < 0 || x >= this.getWidth()) {
            throw new IllegalArgumentException("x");
        }
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("y");
        }
        if (x + Math.abs(width) > this.getWidth()) {
            throw new IllegalArgumentException("width");
        }
        if (y + Math.abs(height) > this.getHeight()) {
            throw new IllegalArgumentException("height");
        }
        if (rotation != Texture.Rotation.NONE || tiled && (width < 0 || height < 0)) {
            return new TextureAreaRotated(this, x, y, width, height, tintColor, tiled, rotation);
        }
        if (tiled) {
            return new TextureAreaTiled(this, x, y, width, height, tintColor);
        }
        return new TextureArea(this, x, y, width, height, tintColor);
    }

    @Override
    public MouseCursor createCursor(int x, int y, int width, int height, int hotSpotX, int hotSpotY, Image imageRef) {
        if (this.renderer.isUseSWMouseCursors() || imageRef != null) {
            return new SWCursor(this, x, y, width, height, hotSpotX, hotSpotY, imageRef);
        }
        if (this.texData != null) {
            LWJGLCursor cursor = new LWJGLCursor(this.texData, this.texDataFmt, this.texDataFmt.getPixelSize() * this.width, x, y, width, height, hotSpotX, hotSpotY);
            if (this.cursors == null) {
                this.cursors = new ArrayList();
            }
            this.cursors.add(cursor);
            return cursor;
        }
        return null;
    }

    @Override
    public void themeLoadingDone() {
    }

    static int roundUpPOT(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public static enum Filter {
        NEAREST(9728),
        LINEAR(9729);

        final int glValue;

        private Filter(int value) {
            this.glValue = value;
        }
    }

    public static enum Format {
        ALPHA(6406, 32828, PNGDecoder.Format.ALPHA),
        LUMINANCE(6409, 32832, PNGDecoder.Format.LUMINANCE),
        LUMINANCE_ALPHA(6410, 32837, PNGDecoder.Format.LUMINANCE_ALPHA),
        RGB(6407, 32849, PNGDecoder.Format.RGB),
        RGB_SMALL(6407, 32855, PNGDecoder.Format.RGB),
        RGBA(6408, 32856, PNGDecoder.Format.RGBA),
        BGRA(32993, 32856, PNGDecoder.Format.BGRA),
        ABGR(32768, 32856, PNGDecoder.Format.ABGR),
        COLOR(-1, -1, null);

        final int glFormat;
        final int glInternalFormat;
        final PNGDecoder.Format pngFormat;

        private Format(int fmt, int ifmt, PNGDecoder.Format pf) {
            this.glFormat = fmt;
            this.glInternalFormat = ifmt;
            this.pngFormat = pf;
        }

        public int getPixelSize() {
            return this.pngFormat.getNumComponents();
        }

        public PNGDecoder.Format getPngFormat() {
            return this.pngFormat;
        }
    }
}

