/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.minecraft.client.Minecraft;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class Config {
    public static final String OF_NAME = "OptiFine";
    public static final String MC_VERSION = "1.5.0";
    public static final String OF_EDITION = "HD_U";
    public static final String OF_RELEASE = "A2";
    public static final String VERSION = "OptiFine_1.5.0_HD_U_A2";
    private static String newRelease = null;
    private static avs gameSettings = null;
    private static Minecraft minecraft = null;
    private static Thread minecraftThread = null;
    private static int iconWidthTerrain = 16;
    private static int iconWidthItems = 16;
    private static Map foundClassesMap = new HashMap();
    private static long textureUpdateTime = 0L;
    private static DisplayMode desktopDisplayMode = null;
    private static int antialiasingLevel = 0;
    private static int availableProcessors = 0;
    public static boolean zoomMode = false;
    private static File logFile = null;
    public static final Boolean DEF_FOG_FANCY = true;
    public static final Float DEF_FOG_START = Float.valueOf(0.2f);
    public static final Boolean DEF_OPTIMIZE_RENDER_DISTANCE = false;
    public static final Boolean DEF_OCCLUSION_ENABLED = false;
    public static final Integer DEF_MIPMAP_LEVEL = 0;
    public static final Integer DEF_MIPMAP_TYPE = 9984;
    public static final Float DEF_ALPHA_FUNC_LEVEL = Float.valueOf(0.1f);
    public static final Boolean DEF_LOAD_CHUNKS_FAR = false;
    public static final Integer DEF_PRELOADED_CHUNKS = 0;
    public static final Integer DEF_CHUNKS_LIMIT = 25;
    public static final Integer DEF_UPDATES_PER_FRAME = 3;
    public static final Boolean DEF_DYNAMIC_UPDATES = false;

    public static String getVersion() {
        return VERSION;
    }

    private static void checkOpenGlCaps() {
        Config.log("");
        Config.log(Config.getVersion());
        Config.log("" + new Date());
        Config.log("OS: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version"));
        Config.log("Java: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        Config.log("VM: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
        Config.log("LWJGL: " + Sys.getVersion());
        Config.log("OpenGL: " + GL11.glGetString((int)7937) + " version " + GL11.glGetString((int)7938) + ", " + GL11.glGetString((int)7936));
        int var0 = Config.getOpenGlVersion();
        String var1 = "" + var0 / 10 + "." + var0 % 10;
        Config.log("OpenGL Version: " + var1);
        if (!GLContext.getCapabilities().OpenGL12) {
            Config.log("OpenGL Mipmap levels: Not available (GL12.GL_TEXTURE_MAX_LEVEL)");
        }
        if (!GLContext.getCapabilities().GL_NV_fog_distance) {
            Config.log("OpenGL Fancy fog: Not available (GL_NV_fog_distance)");
        }
        if (!GLContext.getCapabilities().GL_ARB_occlusion_query) {
            Config.log("OpenGL Occlussion culling: Not available (GL_ARB_occlusion_query)");
        }
    }

    public static boolean isFancyFogAvailable() {
        return GLContext.getCapabilities().GL_NV_fog_distance;
    }

    public static boolean isOcclusionAvailable() {
        return GLContext.getCapabilities().GL_ARB_occlusion_query;
    }

    private static int getOpenGlVersion() {
        return !GLContext.getCapabilities().OpenGL11 ? 10 : (!GLContext.getCapabilities().OpenGL12 ? 11 : (!GLContext.getCapabilities().OpenGL13 ? 12 : (!GLContext.getCapabilities().OpenGL14 ? 13 : (!GLContext.getCapabilities().OpenGL15 ? 14 : (!GLContext.getCapabilities().OpenGL20 ? 15 : (!GLContext.getCapabilities().OpenGL21 ? 20 : (!GLContext.getCapabilities().OpenGL30 ? 21 : (!GLContext.getCapabilities().OpenGL31 ? 30 : (!GLContext.getCapabilities().OpenGL32 ? 31 : (!GLContext.getCapabilities().OpenGL33 ? 32 : (!GLContext.getCapabilities().OpenGL40 ? 33 : 40)))))))))));
    }

    public static void setGameSettings(avs var0) {
        if (gameSettings == null) {
            if (!Display.isCreated()) {
                return;
            }
            Config.checkOpenGlCaps();
            Config.startVersionCheckThread();
        }
        gameSettings = var0;
        minecraft = Config.gameSettings.X;
        minecraftThread = Thread.currentThread();
        if (gameSettings != null) {
            antialiasingLevel = Config.gameSettings.ofAaLevel;
        }
        Config.updateThreadPriorities();
    }

    public static void updateThreadPriorities() {
        try {
            ThreadGroup var0 = Thread.currentThread().getThreadGroup();
            if (var0 == null) {
                return;
            }
            int var1 = (var0.activeCount() + 10) * 2;
            Thread[] var2 = new Thread[var1];
            var0.enumerate(var2, false);
            int var3 = 5;
            int var4 = 5;
            if (Config.isSmoothWorld()) {
                var4 = 3;
            }
            minecraftThread.setPriority(var3);
            for (int var5 = 0; var5 < var2.length; ++var5) {
                Thread var6 = var2[var5];
                if (var6 == null || !(var6 instanceof gp)) continue;
                var6.setPriority(var4);
            }
        }
        catch (Throwable var7) {
            Config.dbg(var7.getMessage());
        }
    }

    public static boolean isMinecraftThread() {
        return Thread.currentThread() == minecraftThread;
    }

    private static void startVersionCheckThread() {
        VersionCheckThread var0 = new VersionCheckThread();
        var0.start();
    }

    public static boolean isUseMipmaps() {
        int var0 = Config.getMipmapLevel();
        return var0 > 0;
    }

    public static int getMipmapLevel() {
        return gameSettings == null ? DEF_MIPMAP_LEVEL : Config.gameSettings.ofMipmapLevel;
    }

    public static int getMipmapType() {
        return gameSettings == null ? DEF_MIPMAP_TYPE : (Config.gameSettings.ofMipmapLinear ? 9986 : 9984);
    }

    public static boolean isUseAlphaFunc() {
        float var0 = Config.getAlphaFuncLevel();
        return var0 > DEF_ALPHA_FUNC_LEVEL.floatValue() + 1.0E-5f;
    }

    public static float getAlphaFuncLevel() {
        return DEF_ALPHA_FUNC_LEVEL.floatValue();
    }

    public static boolean isFogFancy() {
        return !Config.isFancyFogAvailable() ? false : (gameSettings == null ? false : Config.gameSettings.ofFogType == 2);
    }

    public static boolean isFogFast() {
        return gameSettings == null ? false : Config.gameSettings.ofFogType == 1;
    }

    public static boolean isFogOff() {
        return gameSettings == null ? false : Config.gameSettings.ofFogType == 3;
    }

    public static float getFogStart() {
        return gameSettings == null ? DEF_FOG_START.floatValue() : Config.gameSettings.ofFogStart;
    }

    public static boolean isOcclusionEnabled() {
        return gameSettings == null ? DEF_OCCLUSION_ENABLED : Config.gameSettings.h;
    }

    public static boolean isOcclusionFancy() {
        return !Config.isOcclusionEnabled() ? false : (gameSettings == null ? false : Config.gameSettings.ofOcclusionFancy);
    }

    public static boolean isLoadChunksFar() {
        return gameSettings == null ? DEF_LOAD_CHUNKS_FAR : Config.gameSettings.ofLoadFar;
    }

    public static int getPreloadedChunks() {
        return gameSettings == null ? DEF_PRELOADED_CHUNKS : Config.gameSettings.ofPreloadedChunks;
    }

    public static void dbg(String var0) {
        System.out.println(var0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String var0) {
        Config.dbg(var0);
        try {
            if (logFile == null) {
                logFile = new File(Minecraft.b(), "optifog.log");
                logFile.delete();
                logFile.createNewFile();
            }
            FileOutputStream var1 = new FileOutputStream(logFile, true);
            OutputStreamWriter var2 = new OutputStreamWriter((OutputStream)var1, "ASCII");
            try {
                var2.write(var0);
                var2.write("\n");
                var2.flush();
            }
            finally {
                var2.close();
            }
        }
        catch (IOException var7) {
            var7.printStackTrace();
        }
    }

    public static int getUpdatesPerFrame() {
        return gameSettings != null ? Config.gameSettings.ofChunkUpdates : 1;
    }

    public static boolean isDynamicUpdates() {
        return gameSettings != null ? Config.gameSettings.ofChunkUpdatesDynamic : true;
    }

    public static boolean isRainFancy() {
        return Config.gameSettings.ofRain == 0 ? Config.gameSettings.j : Config.gameSettings.ofRain == 2;
    }

    public static boolean isWaterFancy() {
        return Config.gameSettings.ofWater == 0 ? Config.gameSettings.j : Config.gameSettings.ofWater == 2;
    }

    public static boolean isRainOff() {
        return Config.gameSettings.ofRain == 3;
    }

    public static boolean isCloudsFancy() {
        return Config.gameSettings.ofClouds == 0 ? Config.gameSettings.j : Config.gameSettings.ofClouds == 2;
    }

    public static boolean isCloudsOff() {
        return Config.gameSettings.ofClouds == 3;
    }

    public static boolean isTreesFancy() {
        return Config.gameSettings.ofTrees == 0 ? Config.gameSettings.j : Config.gameSettings.ofTrees == 2;
    }

    public static boolean isGrassFancy() {
        return Config.gameSettings.ofGrass == 0 ? Config.gameSettings.j : Config.gameSettings.ofGrass == 2;
    }

    public static boolean isDroppedItemsFancy() {
        return Config.gameSettings.ofDroppedItems == 0 ? Config.gameSettings.j : Config.gameSettings.ofDroppedItems == 2;
    }

    public static int limit(int var0, int var1, int var2) {
        return var0 < var1 ? var1 : (var0 > var2 ? var2 : var0);
    }

    public static float limit(float var0, float var1, float var2) {
        return var0 < var1 ? var1 : (var0 > var2 ? var2 : var0);
    }

    public static float limitTo1(float var0) {
        return var0 < 0.0f ? 0.0f : (var0 > 1.0f ? 1.0f : var0);
    }

    public static boolean isAnimatedWater() {
        return gameSettings != null ? Config.gameSettings.ofAnimatedWater != 2 : true;
    }

    public static boolean isGeneratedWater() {
        return gameSettings != null ? Config.gameSettings.ofAnimatedWater == 1 : true;
    }

    public static boolean isAnimatedPortal() {
        return gameSettings != null ? Config.gameSettings.ofAnimatedPortal : true;
    }

    public static boolean isAnimatedLava() {
        return gameSettings != null ? Config.gameSettings.ofAnimatedLava != 2 : true;
    }

    public static boolean isGeneratedLava() {
        return gameSettings != null ? Config.gameSettings.ofAnimatedLava == 1 : true;
    }

    public static boolean isAnimatedFire() {
        return gameSettings != null ? Config.gameSettings.ofAnimatedFire : true;
    }

    public static boolean isAnimatedRedstone() {
        return gameSettings != null ? Config.gameSettings.ofAnimatedRedstone : true;
    }

    public static boolean isAnimatedExplosion() {
        return gameSettings != null ? Config.gameSettings.ofAnimatedExplosion : true;
    }

    public static boolean isAnimatedFlame() {
        return gameSettings != null ? Config.gameSettings.ofAnimatedFlame : true;
    }

    public static boolean isAnimatedSmoke() {
        return gameSettings != null ? Config.gameSettings.ofAnimatedSmoke : true;
    }

    public static boolean isVoidParticles() {
        return gameSettings != null ? Config.gameSettings.ofVoidParticles : true;
    }

    public static boolean isWaterParticles() {
        return gameSettings != null ? Config.gameSettings.ofWaterParticles : true;
    }

    public static boolean isRainSplash() {
        return gameSettings != null ? Config.gameSettings.ofRainSplash : true;
    }

    public static boolean isPortalParticles() {
        return gameSettings != null ? Config.gameSettings.ofPortalParticles : true;
    }

    public static boolean isDepthFog() {
        return gameSettings != null ? Config.gameSettings.ofDepthFog : true;
    }

    public static float getAmbientOcclusionLevel() {
        return gameSettings != null ? Config.gameSettings.ofAoLevel : 0.0f;
    }

    private static Method getMethod(Class var0, String var1, Object[] var2) {
        Method[] var3 = var0.getMethods();
        for (int var4 = 0; var4 < var3.length; ++var4) {
            Method var5 = var3[var4];
            if (!var5.getName().equals(var1) || var5.getParameterTypes().length != var2.length) continue;
            return var5;
        }
        Config.dbg("No method found for: " + var0.getName() + "." + var1 + "(" + Config.arrayToString(var2) + ")");
        return null;
    }

    public static String arrayToString(Object[] var0) {
        StringBuffer var1 = new StringBuffer(var0.length * 5);
        for (int var2 = 0; var2 < var0.length; ++var2) {
            Object var3 = var0[var2];
            if (var2 > 0) {
                var1.append(", ");
            }
            var1.append(String.valueOf(var3));
        }
        return var1.toString();
    }

    public static Minecraft getMinecraft() {
        return minecraft;
    }

    public static int getIconWidthTerrain() {
        return iconWidthTerrain;
    }

    public static int getIconWidthItems() {
        return iconWidthItems;
    }

    public static void setIconWidthItems(int var0) {
        iconWidthItems = var0;
    }

    public static void setIconWidthTerrain(int var0) {
        iconWidthTerrain = var0;
    }

    public static int getMaxDynamicTileWidth() {
        return 64;
    }

    public static lx getSideGrassTexture(aae var0, int var1, int var2, int var3, int var4, lx var5) {
        if (!Config.isBetterGrass()) {
            return var5;
        }
        lx var6 = TextureUtils.iconGrassTop;
        int var7 = 2;
        if (var5 == TextureUtils.iconMycelSide) {
            var6 = TextureUtils.iconMycelTop;
            var7 = 110;
        }
        if (Config.isBetterGrassFancy()) {
            --var2;
            switch (var4) {
                case 2: {
                    --var3;
                    break;
                }
                case 3: {
                    ++var3;
                    break;
                }
                case 4: {
                    --var1;
                    break;
                }
                case 5: {
                    ++var1;
                }
            }
            int var8 = var0.a(var1, var2, var3);
            if (var8 != var7) {
                return var5;
            }
        }
        return var6;
    }

    public static lx getSideSnowGrassTexture(aae var0, int var1, int var2, int var3, int var4) {
        if (!Config.isBetterGrass()) {
            return TextureUtils.iconSnowSide;
        }
        if (Config.isBetterGrassFancy()) {
            switch (var4) {
                case 2: {
                    --var3;
                    break;
                }
                case 3: {
                    ++var3;
                    break;
                }
                case 4: {
                    --var1;
                    break;
                }
                case 5: {
                    ++var1;
                }
            }
            int var5 = var0.a(var1, var2, var3);
            if (var5 != 78 && var5 != 80) {
                return TextureUtils.iconSnowSide;
            }
        }
        return TextureUtils.iconSnow;
    }

    public static boolean isBetterGrass() {
        return gameSettings == null ? false : Config.gameSettings.ofBetterGrass != 3;
    }

    public static boolean isBetterGrassFancy() {
        return gameSettings == null ? false : Config.gameSettings.ofBetterGrass == 2;
    }

    public static long getTextureUpdateTime() {
        return textureUpdateTime;
    }

    public static void setTextureUpdateTime(long var0) {
        textureUpdateTime = var0;
    }

    public static boolean isWeatherEnabled() {
        return gameSettings == null ? true : Config.gameSettings.ofWeather;
    }

    public static boolean isSkyEnabled() {
        return gameSettings == null ? true : Config.gameSettings.ofSky;
    }

    public static boolean isSunMoonEnabled() {
        return gameSettings == null ? true : Config.gameSettings.ofSunMoon;
    }

    public static boolean isStarsEnabled() {
        return gameSettings == null ? true : Config.gameSettings.ofStars;
    }

    public static void sleep(long var0) {
        try {
            Thread.currentThread();
            Thread.sleep(var0);
        }
        catch (InterruptedException var3) {
            var3.printStackTrace();
        }
    }

    public static boolean isTimeDayOnly() {
        return gameSettings == null ? false : Config.gameSettings.ofTime == 1;
    }

    public static boolean isTimeDefault() {
        return gameSettings == null ? false : Config.gameSettings.ofTime == 0 || Config.gameSettings.ofTime == 2;
    }

    public static boolean isTimeNightOnly() {
        return gameSettings == null ? false : Config.gameSettings.ofTime == 3;
    }

    public static boolean isClearWater() {
        return gameSettings == null ? false : Config.gameSettings.ofClearWater;
    }

    public static int getAnisotropicFilterLevel() {
        return gameSettings == null ? 1 : Config.gameSettings.ofAfLevel;
    }

    public static int getAntialiasingLevel() {
        return antialiasingLevel;
    }

    public static boolean between(int var0, int var1, int var2) {
        return var0 >= var1 && var0 <= var2;
    }

    public static boolean isMultiTexture() {
        return Config.getAnisotropicFilterLevel() > 1 ? true : Config.getAntialiasingLevel() > 0;
    }

    public static boolean isDrippingWaterLava() {
        return gameSettings == null ? false : Config.gameSettings.ofDrippingWaterLava;
    }

    public static boolean isBetterSnow() {
        return gameSettings == null ? false : Config.gameSettings.ofBetterSnow;
    }

    public static Dimension getFullscreenDimension() {
        if (desktopDisplayMode == null) {
            return null;
        }
        if (gameSettings == null) {
            return new Dimension(desktopDisplayMode.getWidth(), desktopDisplayMode.getHeight());
        }
        String var0 = Config.gameSettings.ofFullscreenMode;
        if (var0.equals("Default")) {
            return new Dimension(desktopDisplayMode.getWidth(), desktopDisplayMode.getHeight());
        }
        String[] var1 = Config.tokenize(var0, " x");
        return var1.length < 2 ? new Dimension(desktopDisplayMode.getWidth(), desktopDisplayMode.getHeight()) : new Dimension(Config.parseInt(var1[0], -1), Config.parseInt(var1[1], -1));
    }

    public static int parseInt(String var0, int var1) {
        try {
            return var0 == null ? var1 : Integer.parseInt(var0);
        }
        catch (NumberFormatException var3) {
            return var1;
        }
    }

    public static float parseFloat(String var0, float var1) {
        try {
            return var0 == null ? var1 : Float.parseFloat(var0);
        }
        catch (NumberFormatException var3) {
            return var1;
        }
    }

    public static String[] tokenize(String var0, String var1) {
        StringTokenizer var2 = new StringTokenizer(var0, var1);
        ArrayList<String> var3 = new ArrayList<String>();
        while (var2.hasMoreTokens()) {
            String var4 = var2.nextToken();
            var3.add(var4);
        }
        String[] var5 = var3.toArray(new String[var3.size()]);
        return var5;
    }

    public static DisplayMode getDesktopDisplayMode() {
        return desktopDisplayMode;
    }

    public static void setDesktopDisplayMode(DisplayMode var0) {
        desktopDisplayMode = var0;
    }

    public static DisplayMode[] getFullscreenDisplayModes() {
        try {
            DisplayMode[] var0 = Display.getAvailableDisplayModes();
            ArrayList<DisplayMode> var1 = new ArrayList<DisplayMode>();
            for (int var2 = 0; var2 < var0.length; ++var2) {
                DisplayMode var3 = var0[var2];
                if (desktopDisplayMode != null && (var3.getBitsPerPixel() != desktopDisplayMode.getBitsPerPixel() || var3.getFrequency() != desktopDisplayMode.getFrequency())) continue;
                var1.add(var3);
            }
            DisplayMode[] var5 = var1.toArray(new DisplayMode[var1.size()]);
            Config$1 var6 = new Config$1();
            Arrays.sort(var5, var6);
            return var5;
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return new DisplayMode[]{desktopDisplayMode};
        }
    }

    public static String[] getFullscreenModes() {
        DisplayMode[] var0 = Config.getFullscreenDisplayModes();
        String[] var1 = new String[var0.length];
        for (int var2 = 0; var2 < var0.length; ++var2) {
            String var4;
            DisplayMode var3 = var0[var2];
            var1[var2] = var4 = "" + var3.getWidth() + "x" + var3.getHeight();
        }
        return var1;
    }

    public static DisplayMode getDisplayMode(Dimension var0) throws LWJGLException {
        DisplayMode[] var1 = Display.getAvailableDisplayModes();
        for (int var2 = 0; var2 < var1.length; ++var2) {
            DisplayMode var3 = var1[var2];
            if (var3.getWidth() != var0.width || var3.getHeight() != var0.height || desktopDisplayMode != null && (var3.getBitsPerPixel() != desktopDisplayMode.getBitsPerPixel() || var3.getFrequency() != desktopDisplayMode.getFrequency())) continue;
            return var3;
        }
        return desktopDisplayMode;
    }

    public static boolean isAnimatedTerrain() {
        return gameSettings != null ? Config.gameSettings.ofAnimatedTerrain : true;
    }

    public static boolean isAnimatedItems() {
        return gameSettings != null ? Config.gameSettings.ofAnimatedItems : true;
    }

    public static boolean isSwampColors() {
        return gameSettings != null ? Config.gameSettings.ofSwampColors : true;
    }

    public static boolean isRandomMobs() {
        return gameSettings != null ? Config.gameSettings.ofRandomMobs : true;
    }

    public static void checkGlError(String var0) {
        int var1 = GL11.glGetError();
        if (var1 != 0) {
            String var2 = GLU.gluErrorString((int)var1);
            System.out.println("OpenGlError: " + var1 + " (" + var2 + "), at: " + var0);
        }
    }

    public static boolean isSmoothBiomes() {
        return gameSettings != null ? Config.gameSettings.ofSmoothBiomes : true;
    }

    public static boolean isCustomColors() {
        return gameSettings != null ? Config.gameSettings.ofCustomColors : true;
    }

    public static boolean isCustomSky() {
        return gameSettings != null ? Config.gameSettings.ofCustomSky : true;
    }

    public static boolean isShowCapes() {
        return gameSettings != null ? Config.gameSettings.ofShowCapes : true;
    }

    public static boolean isConnectedTextures() {
        return gameSettings != null ? Config.gameSettings.ofConnectedTextures != 3 : false;
    }

    public static boolean isNaturalTextures() {
        return gameSettings != null ? Config.gameSettings.ofNaturalTextures : false;
    }

    public static boolean isConnectedTexturesFancy() {
        return gameSettings != null ? Config.gameSettings.ofConnectedTextures == 2 : false;
    }

    public static String[] readLines(File var0) throws IOException {
        ArrayList<String> var1 = new ArrayList<String>();
        FileInputStream var2 = new FileInputStream(var0);
        InputStreamReader var3 = new InputStreamReader((InputStream)var2, "ASCII");
        BufferedReader var4 = new BufferedReader(var3);
        while (true) {
            String var5;
            if ((var5 = var4.readLine()) == null) {
                String[] var6 = var1.toArray(new String[var1.size()]);
                return var6;
            }
            var1.add(var5);
        }
    }

    public static String readFile(File var0) throws IOException {
        FileInputStream var1 = new FileInputStream(var0);
        return Config.readInputStream(var1, "ASCII");
    }

    public static String readInputStream(InputStream var0) throws IOException {
        return Config.readInputStream(var0, "ASCII");
    }

    public static String readInputStream(InputStream var0, String var1) throws IOException {
        InputStreamReader var2 = new InputStreamReader(var0, var1);
        BufferedReader var3 = new BufferedReader(var2);
        StringBuffer var4 = new StringBuffer();
        String var5;
        while ((var5 = var3.readLine()) != null) {
            var4.append(var5);
            var4.append("\n");
        }
        return var4.toString();
    }

    public static avs getGameSettings() {
        return gameSettings;
    }

    public static String getNewRelease() {
        return newRelease;
    }

    public static void setNewRelease(String var0) {
        newRelease = var0;
    }

    public static int compareRelease(String var0, String var1) {
        int var7;
        String[] var3;
        String var5;
        String[] var2 = Config.splitRelease(var0);
        String var4 = var2[0];
        if (!var4.equals(var5 = (var3 = Config.splitRelease(var1))[0])) {
            return var4.compareTo(var5);
        }
        int var6 = Config.parseInt(var2[1], -1);
        if (var6 != (var7 = Config.parseInt(var3[1], -1))) {
            return var6 - var7;
        }
        String var8 = var2[2];
        String var9 = var3[2];
        return var8.compareTo(var9);
    }

    private static String[] splitRelease(String var0) {
        if (var0 != null && var0.length() > 0) {
            int var2;
            String var1 = var0.substring(0, 1);
            if (var0.length() <= 1) {
                return new String[]{var1, "", ""};
            }
            for (var2 = 1; var2 < var0.length() && Character.isDigit(var0.charAt(var2)); ++var2) {
            }
            String var3 = var0.substring(1, var2);
            if (var2 >= var0.length()) {
                return new String[]{var1, var3, ""};
            }
            String var4 = var0.substring(var2);
            return new String[]{var1, var3, var4};
        }
        return new String[]{"", "", ""};
    }

    public static int intHash(int var0) {
        var0 = var0 ^ 0x3D ^ var0 >> 16;
        var0 += var0 << 3;
        var0 ^= var0 >> 4;
        var0 *= 668265261;
        var0 ^= var0 >> 15;
        return var0;
    }

    public static int getRandom(int var0, int var1, int var2, int var3) {
        int var4 = Config.intHash(var3 + 37);
        var4 = Config.intHash(var4 + var0);
        var4 = Config.intHash(var4 + var2);
        var4 = Config.intHash(var4 + var1);
        return var4;
    }

    public static void fixWorldTime(Minecraft var0) {
        iz var6;
        int var5;
        ach var4;
        ajp var3;
        bja var2;
        bdm var1 = var0.e;
        if (var1 != null && (var2 = var0.D()) != null && (var3 = var1.x) != null && var3.r().a() == 1 && (var4 = var1.t) != null && (var5 = var4.h) == 0 && (var6 = var2.a(var5)) != null) {
            long var7 = var6.H();
            long var9 = var7 % 24000L;
            if (Config.isTimeDayOnly()) {
                if (var9 <= 1000L) {
                    var6.b(var7 - var9 + 1001L);
                }
                if (var9 >= 11000L) {
                    var6.b(var7 - var9 + 24001L);
                }
            }
            if (Config.isTimeNightOnly()) {
                if (var9 <= 14000L) {
                    var6.b(var7 - var9 + 14001L);
                }
                if (var9 >= 22000L) {
                    var6.b(var7 - var9 + 24000L + 14001L);
                }
            }
        }
    }

    public static iz getWorldServer() {
        if (minecraft == null) {
            return null;
        }
        bdm var0 = Config.minecraft.e;
        if (var0 == null) {
            return null;
        }
        ach var1 = var0.t;
        if (var1 == null) {
            return null;
        }
        int var2 = var1.h;
        bja var3 = minecraft.D();
        if (var3 == null) {
            return null;
        }
        iz var4 = var3.a(var2);
        return var4;
    }

    public static int getAvailableProcessors() {
        if (availableProcessors < 1) {
            availableProcessors = Runtime.getRuntime().availableProcessors();
        }
        return availableProcessors;
    }

    public static boolean isSingleProcessor() {
        return Config.getAvailableProcessors() <= 1;
    }

    public static boolean isSmoothWorld() {
        return Config.getAvailableProcessors() > 1 ? false : (gameSettings == null ? true : Config.gameSettings.ofSmoothWorld);
    }

    public static boolean isLazyChunkLoading() {
        return Config.getAvailableProcessors() > 1 ? false : (gameSettings == null ? true : Config.gameSettings.ofLazyChunkLoading);
    }

    public static int getChunkViewDistance() {
        if (gameSettings == null) {
            return 10;
        }
        int var0 = Config.gameSettings.ofRenderDistanceFine / 16;
        return var0 <= 16 ? 10 : var0;
    }
}

