/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class NaturalTextures {
    private static bfy renderEngine = null;
    private static NaturalProperties[] propertiesByIndex = new NaturalProperties[0];

    public static void update(bfy var0) {
        propertiesByIndex = new NaturalProperties[0];
        renderEngine = var0;
        if (Config.isNaturalTextures()) {
            String var1 = "/natural.properties";
            try {
                InputStream var2 = var0.g.e().a(var1);
                if (var2 == null) {
                    Config.dbg("NaturalTextures: configuration \"" + var1 + "\" not found");
                    propertiesByIndex = NaturalTextures.makeDefaultProperties();
                    return;
                }
                ArrayList<Object> var3 = new ArrayList<Object>(1024);
                String var4 = Config.readInputStream(var2);
                var2.close();
                String[] var5 = Config.tokenize(var4, "\n\r");
                Config.dbg("Natural Textures: Parsing configuration \"" + var1 + "\"");
                for (int var6 = 0; var6 < var5.length; ++var6) {
                    String var7 = var5[var6].trim();
                    if (var7.startsWith("#")) continue;
                    String[] var8 = Config.tokenize(var7, "=");
                    if (var8.length != 2) {
                        Config.dbg("Natural Textures: Invalid \"" + var1 + "\" line: " + var7);
                        continue;
                    }
                    String var9 = var8[0].trim();
                    String var10 = var8[1].trim();
                    bif var12 = var0.i.getIconSafe(var9);
                    if (var12 == null) {
                        Config.dbg("Natural Textures: Texture not found: \"" + var1 + "\" line: " + var7);
                        continue;
                    }
                    int var13 = var12.getIndexInTexture();
                    if (var13 < 0) {
                        Config.dbg("Natural Textures: Invalid \"" + var1 + "\" line: " + var7);
                        continue;
                    }
                    NaturalProperties var14 = new NaturalProperties(var10);
                    if (!var14.isValid()) continue;
                    while (var3.size() <= var13) {
                        var3.add(null);
                    }
                    var3.set(var13, var14);
                }
                propertiesByIndex = var3.toArray(new NaturalProperties[var3.size()]);
            }
            catch (FileNotFoundException var15) {
                Config.dbg("NaturalTextures: configuration \"" + var1 + "\" not found");
                propertiesByIndex = NaturalTextures.makeDefaultProperties();
                return;
            }
            catch (Exception var16) {
                var16.printStackTrace();
            }
        }
    }

    public static NaturalProperties getNaturalProperties(lx var0) {
        if (!(var0 instanceof bif)) {
            return null;
        }
        bif var1 = (bif)var0;
        int var2 = var1.getIndexInTexture();
        if (var2 >= propertiesByIndex.length) {
            return null;
        }
        NaturalProperties var3 = propertiesByIndex[var2];
        return var3;
    }

    private static NaturalProperties[] makeDefaultProperties() {
        if (!(NaturalTextures.renderEngine.g.e() instanceof bjk)) {
            Config.dbg("NaturalTextures: Texture pack is not default, ignoring default configuration.");
            return new NaturalProperties[0];
        }
        Config.dbg("Natural Textures: Using default configuration.");
        ArrayList var0 = new ArrayList();
        NaturalTextures.setIconProperties(var0, "grass_top", "4F");
        NaturalTextures.setIconProperties(var0, "stone", "2F");
        NaturalTextures.setIconProperties(var0, "dirt", "4F");
        NaturalTextures.setIconProperties(var0, "grass_side", "F");
        NaturalTextures.setIconProperties(var0, "grass_side_overlay", "F");
        NaturalTextures.setIconProperties(var0, "stoneslab_top", "F");
        NaturalTextures.setIconProperties(var0, "bedrock", "2F");
        NaturalTextures.setIconProperties(var0, "sand", "4F");
        NaturalTextures.setIconProperties(var0, "gravel", "2");
        NaturalTextures.setIconProperties(var0, "tree_side", "2F");
        NaturalTextures.setIconProperties(var0, "tree_top", "4F");
        NaturalTextures.setIconProperties(var0, "oreGold", "2F");
        NaturalTextures.setIconProperties(var0, "oreIron", "2F");
        NaturalTextures.setIconProperties(var0, "oreCoal", "2F");
        NaturalTextures.setIconProperties(var0, "oreDiamond", "2F");
        NaturalTextures.setIconProperties(var0, "oreRedstone", "2F");
        NaturalTextures.setIconProperties(var0, "oreLapis", "2F");
        NaturalTextures.setIconProperties(var0, "obsidian", "4F");
        NaturalTextures.setIconProperties(var0, "leaves", "2F");
        NaturalTextures.setIconProperties(var0, "leaves_opaque", "2F");
        NaturalTextures.setIconProperties(var0, "leaves_jungle", "2");
        NaturalTextures.setIconProperties(var0, "leaves_jungle_opaque", "2");
        NaturalTextures.setIconProperties(var0, "snow", "4F");
        NaturalTextures.setIconProperties(var0, "snow_side", "F");
        NaturalTextures.setIconProperties(var0, "cactus_side", "2F");
        NaturalTextures.setIconProperties(var0, "clay", "4F");
        NaturalTextures.setIconProperties(var0, "mycel_side", "F");
        NaturalTextures.setIconProperties(var0, "mycel_top", "4F");
        NaturalTextures.setIconProperties(var0, "farmland_wet", "2F");
        NaturalTextures.setIconProperties(var0, "farmland_dry", "2F");
        NaturalTextures.setIconProperties(var0, "hellrock", "4F");
        NaturalTextures.setIconProperties(var0, "hellsand", "4F");
        NaturalTextures.setIconProperties(var0, "lightgem", "4");
        NaturalTextures.setIconProperties(var0, "tree_spruce", "2F");
        NaturalTextures.setIconProperties(var0, "tree_birch", "F");
        NaturalTextures.setIconProperties(var0, "leaves_spruce", "2F");
        NaturalTextures.setIconProperties(var0, "leaves_spruce_opaque", "2F");
        NaturalTextures.setIconProperties(var0, "tree_jungle", "2F");
        NaturalTextures.setIconProperties(var0, "whiteStone", "4");
        NaturalTextures.setIconProperties(var0, "sandstone_top", "4");
        NaturalTextures.setIconProperties(var0, "sandstone_bottom", "4F");
        NaturalTextures.setIconProperties(var0, "redstoneLight_lit", "4F");
        NaturalProperties[] var1 = var0.toArray(new NaturalProperties[var0.size()]);
        return var1;
    }

    private static void setIconProperties(List var0, String var1, String var2) {
        bil var3 = NaturalTextures.renderEngine.i;
        lx var4 = var3.a(var1);
        if (var4 == null) {
            Config.dbg("*** NaturalProperties: Icon not found: " + var1 + " ***");
        } else if (!(var4 instanceof bif)) {
            Config.dbg("*** NaturalProperties: Icon is not IconStitched: " + var1 + ": " + var4.getClass().getName() + " ***");
        } else {
            bif var5 = (bif)var4;
            int var6 = var5.getIndexInTexture();
            if (var6 < 0) {
                Config.dbg("*** NaturalProperties: Invalid index for icon: " + var1 + ": " + var6 + " ***");
            } else {
                while (var6 >= var0.size()) {
                    var0.add(null);
                }
                NaturalProperties var7 = new NaturalProperties(var2);
                var0.set(var6, var7);
            }
        }
    }

    public static void updateIcons(bil var0) {
    }
}

