/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;

public class WrUpdaterThreaded
implements IWrUpdater {
    private WrUpdateThread updateThread = null;
    private float timePerUpdateMs = 10.0f;
    private long updateStartTimeNs = 0L;
    private boolean firstUpdate = true;
    private int updateTargetNum = 0;

    @Override
    public void terminate() {
        if (this.updateThread != null) {
            this.updateThread.terminate();
            this.updateThread.unpauseToEndOfUpdate();
        }
    }

    @Override
    public void initialize() {
    }

    private void delayedInit() {
        if (this.updateThread == null) {
            this.createUpdateThread(Display.getDrawable());
        }
    }

    @Override
    public bfg makeWorldRenderer(zv var1, List var2, int var3, int var4, int var5, int var6) {
        return new WorldRendererThreaded(var1, var2, var3, var4, var5, var6);
    }

    public WrUpdateThread createUpdateThread(Drawable var1) {
        if (this.updateThread != null) {
            throw new IllegalStateException("UpdateThread is already existing");
        }
        try {
            Pbuffer var2 = new Pbuffer(1, 1, new PixelFormat(), var1);
            this.updateThread = new WrUpdateThread(var2);
            this.updateThread.setPriority(1);
            this.updateThread.start();
            this.updateThread.pause();
            return this.updateThread;
        }
        catch (Exception var3) {
            throw new RuntimeException(var3);
        }
    }

    public boolean isUpdateThread() {
        return Thread.currentThread() == this.updateThread;
    }

    public static boolean isBackgroundChunkLoading() {
        return true;
    }

    @Override
    public void preRender(bfs var1, ng var2) {
        this.updateTargetNum = 0;
        if (this.updateThread != null) {
            if (this.updateStartTimeNs == 0L) {
                this.updateStartTimeNs = System.nanoTime();
            }
            if (this.updateThread.hasWorkToDo()) {
                this.updateTargetNum = Config.getUpdatesPerFrame();
                if (Config.isDynamicUpdates() && !var1.isMoving(var2)) {
                    this.updateTargetNum *= 3;
                }
                this.updateTargetNum = Math.min(this.updateTargetNum, this.updateThread.getPendingUpdatesCount());
                if (this.updateTargetNum > 0) {
                    this.updateThread.unpause();
                }
            }
        }
    }

    @Override
    public void postRender() {
        if (this.updateThread != null) {
            float var1 = 0.0f;
            if (this.updateTargetNum > 0) {
                long var2 = System.nanoTime() - this.updateStartTimeNs;
                float var4 = this.timePerUpdateMs * (1.0f + (float)(this.updateTargetNum - 1) / 2.0f);
                if (var4 > 0.0f) {
                    int var5 = (int)var4;
                    Config.sleep(var5);
                }
                this.updateThread.pause();
            }
            float var6 = 0.2f;
            if (this.updateTargetNum > 0) {
                int var3 = this.updateThread.resetUpdateCount();
                if (var3 < this.updateTargetNum) {
                    this.timePerUpdateMs += var6;
                }
                if (var3 > this.updateTargetNum) {
                    this.timePerUpdateMs -= var6;
                }
                if (var3 == this.updateTargetNum) {
                    this.timePerUpdateMs -= var6;
                }
            } else {
                this.timePerUpdateMs -= var6 / 5.0f;
            }
            if (this.timePerUpdateMs < 0.0f) {
                this.timePerUpdateMs = 0.0f;
            }
            this.updateStartTimeNs = System.nanoTime();
        }
    }

    @Override
    public boolean updateRenderers(bfs var1, ng var2, boolean var3) {
        int var13;
        float var12;
        int var10;
        this.delayedInit();
        if (var1.j.size() <= 0) {
            return true;
        }
        int var4 = 0;
        int var5 = 4;
        int var6 = 0;
        bfg var7 = null;
        float var8 = Float.MAX_VALUE;
        int var9 = -1;
        for (var10 = 0; var10 < var1.j.size(); ++var10) {
            bfg var11 = (bfg)var1.j.get(var10);
            if (var11 == null) continue;
            ++var6;
            if (var11.isUpdating) continue;
            if (!var11.q) {
                var1.j.set(var10, null);
                continue;
            }
            var12 = var11.a(var2);
            if (var12 < 512.0f) {
                if (var12 < 256.0f && var1.isActingNow() && var11.l || this.firstUpdate) {
                    if (this.updateThread != null) {
                        this.updateThread.unpauseToEndOfUpdate();
                    }
                    var11.a();
                    var11.q = false;
                    var1.j.set(var10, null);
                    ++var4;
                    continue;
                }
                if (this.updateThread != null) {
                    this.updateThread.addRendererToUpdate(var11, true);
                    var11.q = false;
                    var1.j.set(var10, null);
                    ++var4;
                    continue;
                }
            }
            if (!var11.l) {
                var12 *= (float)var5;
            }
            if (var7 == null) {
                var7 = var11;
                var8 = var12;
                var9 = var10;
                continue;
            }
            if (!(var12 < var8)) continue;
            var7 = var11;
            var8 = var12;
            var9 = var10;
        }
        var10 = Config.getUpdatesPerFrame();
        boolean var17 = false;
        if (Config.isDynamicUpdates() && !var1.isMoving(var2)) {
            var10 *= 3;
            var17 = true;
        }
        if (this.updateThread != null && (var10 = this.updateThread.getUpdateCapacity()) <= 0) {
            return true;
        }
        if (var7 != null) {
            this.updateRenderer(var7);
            var1.j.set(var9, null);
            ++var4;
            var12 = var8 / 5.0f;
            for (var13 = 0; var13 < var1.j.size() && var4 < var10; ++var13) {
                float var16;
                bfg var14 = (bfg)var1.j.get(var13);
                if (var14 == null || var14.isUpdating) continue;
                float var15 = var14.a(var2);
                if (!var14.l) {
                    var15 *= (float)var5;
                }
                if (!((var16 = Math.abs(var15 - var8)) < var12)) continue;
                this.updateRenderer(var14);
                var1.j.set(var13, null);
                ++var4;
            }
        }
        if (var6 == 0) {
            var1.j.clear();
        }
        if (var1.j.size() > 100 && var6 < var1.j.size() * 4 / 5) {
            int var18 = 0;
            for (var13 = 0; var13 < var1.j.size(); ++var13) {
                Object var19 = var1.j.get(var13);
                if (var19 == null) continue;
                if (var13 != var18) {
                    var1.j.set(var18, var19);
                }
                ++var18;
            }
            for (var13 = var1.j.size() - 1; var13 >= var18; --var13) {
                var1.j.remove(var13);
            }
        }
        this.firstUpdate = false;
        return true;
    }

    private void updateRenderer(bfg var1) {
        WrUpdateThread var2 = this.updateThread;
        if (var2 != null) {
            var2.addRendererToUpdate(var1, false);
            var1.q = false;
        } else {
            var1.a();
            var1.q = false;
            var1.isUpdating = false;
        }
    }

    @Override
    public void finishCurrentUpdate() {
        if (this.updateThread != null) {
            this.updateThread.unpauseToEndOfUpdate();
        }
    }

    @Override
    public void resumeBackgroundUpdates() {
        if (this.updateThread != null) {
            this.updateThread.unpause();
        }
    }

    @Override
    public void pauseBackgroundUpdates() {
        if (this.updateThread != null) {
            this.updateThread.pause();
        }
    }
}

