/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lwjgl.opengl.GL11;

public class GLTextureBufferedImage
extends BufferedImage {
    private static final ByteBuffer buffer = auw.c(262144);
    private static final HashMap registerImage = new HashMap();
    private static final Lock lock = new ReentrantLock();
    public byte[] data;
    private int register;
    private boolean magFiltering;
    private boolean minFiltering;
    private boolean clampTexture;

    private GLTextureBufferedImage(ColorModel var1, WritableRaster var2, boolean var3, Hashtable var4) {
        super(var1, var2, var3, var4);
        this.data = ((DataBufferByte)var2.getDataBuffer()).getData();
    }

    public static GLTextureBufferedImage create(int var0, int var1) {
        ColorSpace var2 = ColorSpace.getInstance(1000);
        int[] var3 = new int[]{8, 8, 8, 8};
        int[] var4 = new int[]{0, 1, 2, 3};
        ComponentColorModel var5 = new ComponentColorModel(var2, var3, true, false, 3, 0);
        WritableRaster var6 = Raster.createInterleavedRaster(0, var0, var1, var0 * 4, 4, var4, (Point)null);
        return new GLTextureBufferedImage((ColorModel)var5, var6, false, (Hashtable)null);
    }

    public static GLTextureBufferedImage create(BufferedImage var0) {
        GLTextureBufferedImage var1 = GLTextureBufferedImage.create(var0.getWidth(), var0.getHeight());
        Graphics var2 = var1.getGraphics();
        var2.drawImage(var0, 0, 0, null);
        var2.dispose();
        return var1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int register() {
        int var2;
        lock.lock();
        try {
            if (this.register != 0) {
                int var22;
                GL11.glBindTexture((int)3553, (int)this.register);
                GL11.glTexParameteri((int)3553, (int)10241, (int)(this.minFiltering ? 9729 : 9728));
                GL11.glTexParameteri((int)3553, (int)10240, (int)(this.magFiltering ? 9729 : 9728));
                int var1 = this.clampTexture ? 10496 : 10497;
                GL11.glTexParameteri((int)3553, (int)10242, (int)var1);
                GL11.glTexParameteri((int)3553, (int)10243, (int)var1);
                buffer.clear();
                buffer.put(this.data);
                buffer.flip();
                GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)6408, (int)5121, (ByteBuffer)buffer);
                int n2 = var22 = this.register;
                return n2;
            }
            this.register = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)this.register);
            GL11.glTexParameteri((int)3553, (int)10241, (int)(this.minFiltering ? 9729 : 9728));
            GL11.glTexParameteri((int)3553, (int)10240, (int)(this.magFiltering ? 9729 : 9728));
            int var1 = this.clampTexture ? 10496 : 10497;
            GL11.glTexParameteri((int)3553, (int)10242, (int)var1);
            GL11.glTexParameteri((int)3553, (int)10243, (int)var1);
            buffer.clear();
            buffer.put(this.data);
            buffer.flip();
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
            registerImage.put(this.register, this);
            var2 = this.register;
        }
        finally {
            lock.unlock();
        }
        return var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind() {
        boolean var1;
        lock.lock();
        try {
            if (this.register == 0) {
                boolean var12;
                boolean bl2 = var12 = false;
                return bl2;
            }
            GL11.glBindTexture((int)3553, (int)this.register);
            var1 = true;
        }
        finally {
            lock.unlock();
        }
        return var1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        lock.lock();
        try {
            if (this.register != 0) {
                GL11.glDeleteTextures((int)this.register);
                this.register = 0;
                registerImage.remove(this.register);
                return;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(int var0) {
        lock.lock();
        try {
            GLTextureBufferedImage var1 = (GLTextureBufferedImage)registerImage.get(var0);
            if (var1 != null) {
                var1.unregister();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void setMagFilter(boolean var1) {
        this.magFiltering = var1;
    }

    public void setMinFilter(boolean var1) {
        this.minFiltering = var1;
    }

    public int getId() {
        return this.register;
    }

    public boolean getMagFilter() {
        return this.magFiltering;
    }

    public boolean getMinFilter() {
        return this.minFiltering;
    }

    public void setClampTexture(boolean var1) {
        this.clampTexture = var1;
    }

    public boolean isClampTexture() {
        return this.clampTexture;
    }

    public void setRGBA(int var1, int var2, byte var3, byte var4, byte var5, byte var6) {
        int var7 = (var2 * this.getWidth() + var1) * 4;
        this.data[var7++] = var3;
        this.data[var7++] = var4;
        this.data[var7++] = var5;
        this.data[var7] = var6;
    }

    public void setRGB(int var1, int var2, byte var3, byte var4, byte var5) {
        int var6 = (var2 * this.getWidth() + var1) * 4;
        this.data[var6++] = var3;
        this.data[var6++] = var4;
        this.data[var6++] = var5;
        this.data[var6] = -1;
    }

    @Override
    public void setRGB(int var1, int var2, int var3) {
        int var4 = (var2 * this.getWidth() + var1) * 4;
        this.data[var4++] = (byte)(var3 >> 16);
        this.data[var4++] = (byte)(var3 >> 8);
        this.data[var4++] = (byte)(var3 >> 0);
        this.data[var4] = (byte)(var3 >> 24);
    }

    public static void createTexture(int[] var0, int var1, int var2, int var3, boolean var4, boolean var5) {
        byte[] var6 = new byte[var1 * var2 * 4];
        int var8 = var0.length;
        int var9 = 0;
        for (int var7 = 0; var7 < var8; ++var7) {
            int var10 = var0[var7];
            var6[var9++] = (byte)(var10 >> 16);
            var6[var9++] = (byte)(var10 >> 8);
            var6[var9++] = (byte)(var10 >> 0);
            var6[var9++] = (byte)(var10 >> 24);
        }
        GLTextureBufferedImage.createTexture(var6, var1, var2, var3, var4, var5);
    }

    public static void createTexture(byte[] var0, int var1, int var2, int var3, boolean var4, boolean var5) {
        GL11.glBindTexture((int)3553, (int)var3);
        GL11.glTexParameteri((int)3553, (int)10241, (int)(var4 ? 9729 : 9728));
        GL11.glTexParameteri((int)3553, (int)10240, (int)(var4 ? 9729 : 9728));
        GL11.glTexParameteri((int)3553, (int)10242, (int)(var5 ? 10496 : 10497));
        GL11.glTexParameteri((int)3553, (int)10243, (int)(var5 ? 10496 : 10497));
        buffer.clear();
        buffer.put(var0);
        buffer.flip();
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)var1, (int)var2, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
    }
}

