/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.io.File;
import java.io.PrintWriter;
import java.util.Scanner;
import org.lwjgl.input.Keyboard;
import reifnsk.minimap.ReiMinimap;

public enum KeyInput {
    MENU_KEY(52),
    TOGGLE_ENABLE(0),
    TOGGLE_RENDER_TYPE(0),
    TOGGLE_ZOOM(39),
    TOGGLE_LARGE_MAP(0),
    TOGGLE_LARGE_MAP_LABEL(0),
    TOGGLE_WAYPOINTS_VISIBLE(0),
    TOGGLE_WAYPOINTS_MARKER(0),
    TOGGLE_WAYPOINTS_DIMENSION(0),
    TOGGLE_ENTITIES_RADAR(0),
    SET_WAYPOINT(0),
    WAYPOINT_LIST(0),
    ZOOM_IN(0),
    ZOOM_OUT(0);

    private static File configFile;
    private final int defaultKeyIndex;
    private String label;
    private int keyIndex;
    private boolean keyDown;
    private boolean oldKeyDown;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private KeyInput() {
        void var3;
        this.defaultKeyIndex = var3;
        this.keyIndex = var3;
        this.label = ReiMinimap.capitalize(this.name());
    }

    /*
     * WARNING - void declaration
     */
    private KeyInput() {
        void var4;
        void var3;
        this.label = var3;
        this.defaultKeyIndex = var4;
        this.keyIndex = var4;
    }

    public void setKey(int var1) {
        if (var1 == 1) {
            var1 = 0;
        }
        if (var1 != 0 || this != MENU_KEY) {
            if (var1 != 0) {
                for (KeyInput var5 : KeyInput.values()) {
                    if (var5.keyIndex != var1) continue;
                    if (var5 == MENU_KEY && this.keyIndex == 0) {
                        return;
                    }
                    var5.keyIndex = this.keyIndex;
                    var5.keyDown = false;
                    var5.oldKeyDown = false;
                    break;
                }
            }
            this.keyIndex = var1;
            this.keyDown = false;
            this.oldKeyDown = false;
        }
    }

    public int getKey() {
        return this.keyIndex;
    }

    public String label() {
        return this.label;
    }

    public String getKeyName() {
        String var1 = Keyboard.getKeyName((int)this.keyIndex);
        return var1 == null ? String.format("#%02X", this.keyIndex) : ReiMinimap.capitalize(var1);
    }

    public void setKey(String var1) {
        int var2 = Keyboard.getKeyIndex((String)var1);
        if (var1.startsWith("#")) {
            try {
                var2 = Integer.parseInt(var1.substring(1), 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setKey(var2);
    }

    public boolean isKeyDown() {
        return this.keyDown;
    }

    public boolean isKeyPush() {
        return this.keyDown && !this.oldKeyDown;
    }

    public boolean isKeyPushUp() {
        return !this.keyDown && this.oldKeyDown;
    }

    public static void update() {
        for (KeyInput var3 : KeyInput.values()) {
            var3.oldKeyDown = var3.keyDown;
            var3.keyDown = var3.keyIndex != 0 && Keyboard.isKeyDown((int)var3.keyIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveKeyConfig() {
        boolean var2;
        PrintWriter var0 = null;
        try {
            var0 = new PrintWriter(configFile);
            for (KeyInput var4 : KeyInput.values()) {
                var0.println(var4.toString());
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception var8) {
            var2 = false;
        }
        finally {
            if (var0 != null) {
                var0.flush();
                var0.close();
            }
        }
        return var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadKeyConfig() {
        Scanner var0 = null;
        try {
            var0 = new Scanner(configFile);
            while (var0.hasNextLine()) {
                try {
                    String[] var1 = var0.nextLine().split(":");
                    KeyInput.valueOf(ReiMinimap.toUpperCase(var1[0].trim())).setKey(ReiMinimap.toUpperCase(var1[1].trim()));
                }
                catch (Exception var6) {}
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (var0 != null) {
                var0.close();
            }
        }
    }

    public void setDefault() {
        this.keyIndex = this.defaultKeyIndex;
    }

    public boolean isDefault() {
        return this.keyIndex == this.defaultKeyIndex;
    }

    public String toString() {
        return ReiMinimap.capitalize(this.name()) + ": " + this.getKeyName();
    }

    static {
        configFile = new File(ReiMinimap.directory, "keyconfig.txt");
        KeyInput.loadKeyConfig();
        KeyInput.saveKeyConfig();
    }
}

