/*
 * Decompiled with CFR 0.152.
 */
package a.a.a;

import a.a.Channel;
import a.a.FilenameURL;
import a.a.ICodec;
import a.a.Library;
import a.a.ListenerData;
import a.a.SoundBuffer;
import a.a.SoundSystemConfig;
import a.a.Source;
import a.a.a.ChannelLWJGLOpenAL;
import a.a.a.LibraryLWJGLOpenAL$Exception;
import a.a.a.SourceLWJGLOpenAL;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;

public class LibraryLWJGLOpenAL
extends Library {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final boolean XXX = false;
    private FloatBuffer listenerPositionAL = null;
    private FloatBuffer listenerOrientation = null;
    private FloatBuffer listenerVelocity = null;
    private HashMap ALBufferMap = new HashMap();
    private static boolean alPitchSupported = true;

    public LibraryLWJGLOpenAL() {
        this.reverseByteOrder = true;
    }

    public void init() {
        boolean bl2 = false;
        try {
            AL.create();
            bl2 = this.checkALError();
        }
        catch (LWJGLException lWJGLException) {
            this.errorMessage("Unable to initialize OpenAL.  Probable cause: OpenAL not supported.");
            this.printStackTrace((Exception)((Object)lWJGLException));
            throw new LibraryLWJGLOpenAL$Exception(lWJGLException.getMessage(), 101);
        }
        if (bl2) {
            this.importantMessage("OpenAL did not initialize properly!");
        } else {
            this.message("OpenAL initialized.");
        }
        this.listenerPositionAL = BufferUtils.createFloatBuffer((int)3).put(new float[]{this.listener.position.x, this.listener.position.y, this.listener.position.z});
        this.listenerOrientation = BufferUtils.createFloatBuffer((int)6).put(new float[]{this.listener.lookAt.x, this.listener.lookAt.y, this.listener.lookAt.z, this.listener.up.x, this.listener.up.y, this.listener.up.z});
        this.listenerVelocity = BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f});
        this.listenerPositionAL.flip();
        this.listenerOrientation.flip();
        this.listenerVelocity.flip();
        AL10.alListener((int)4100, (FloatBuffer)this.listenerPositionAL);
        bl2 = this.checkALError() || bl2;
        AL10.alListener((int)4111, (FloatBuffer)this.listenerOrientation);
        bl2 = this.checkALError() || bl2;
        AL10.alListener((int)4102, (FloatBuffer)this.listenerVelocity);
        bl2 = this.checkALError() || bl2;
        AL10.alDopplerFactor((float)SoundSystemConfig.getDopplerFactor());
        bl2 = this.checkALError() || bl2;
        AL10.alDopplerVelocity((float)SoundSystemConfig.getDopplerVelocity());
        boolean bl3 = bl2 = this.checkALError() || bl2;
        if (bl2) {
            this.importantMessage("OpenAL did not initialize properly!");
            throw new LibraryLWJGLOpenAL$Exception("Problem encountered while loading OpenAL or creating the listener.  Probable cause:  OpenAL not supported", 101);
        }
        super.init();
        ChannelLWJGLOpenAL channelLWJGLOpenAL = (ChannelLWJGLOpenAL)this.normalChannels.get(1);
        try {
            AL10.alSourcef((int)channelLWJGLOpenAL.ALSource.get(0), (int)4099, (float)1.0f);
            if (this.checkALError()) {
                LibraryLWJGLOpenAL.alPitchSupported(true, false);
                throw new LibraryLWJGLOpenAL$Exception("OpenAL: AL_PITCH not supported.", 108);
            }
            LibraryLWJGLOpenAL.alPitchSupported(true, true);
        }
        catch (Exception exception) {
            LibraryLWJGLOpenAL.alPitchSupported(true, false);
            throw new LibraryLWJGLOpenAL$Exception("OpenAL: AL_PITCH not supported.", 108);
        }
    }

    public static boolean libraryCompatible() {
        if (AL.isCreated()) {
            return true;
        }
        try {
            AL.create();
        }
        catch (Exception exception) {
            return false;
        }
        try {
            AL.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected Channel createChannel(int n10) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        try {
            AL10.alGenSources((IntBuffer)intBuffer);
        }
        catch (Exception exception) {
            AL10.alGetError();
            return null;
        }
        if (AL10.alGetError() != 0) {
            return null;
        }
        ChannelLWJGLOpenAL channelLWJGLOpenAL = new ChannelLWJGLOpenAL(n10, intBuffer);
        return channelLWJGLOpenAL;
    }

    public void cleanup() {
        super.cleanup();
        Set set = this.bufferMap.keySet();
        for (String string : set) {
            IntBuffer intBuffer = (IntBuffer)this.ALBufferMap.get(string);
            if (intBuffer == null) continue;
            AL10.alDeleteBuffers((IntBuffer)intBuffer);
            this.checkALError();
            intBuffer.clear();
        }
        this.bufferMap.clear();
        AL.destroy();
        this.bufferMap = null;
        this.listenerPositionAL = null;
        this.listenerOrientation = null;
        this.listenerVelocity = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean loadSound(FilenameURL filenameURL) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.ALBufferMap == null) {
            this.ALBufferMap = new HashMap();
            this.importantMessage("Open AL Buffer Map was null in method'loadSound'");
        }
        if (this.errorCheck(filenameURL == null, "Filename/URL not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(filenameURL.getFilename()) != null) {
            return true;
        }
        ICodec iCodec = SoundSystemConfig.getCodec(filenameURL.getFilename());
        if (this.errorCheck(iCodec == null, "No codec found for file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.reverseByteOrder(true);
        URL uRL = filenameURL.getURL();
        if (this.errorCheck(uRL == null, "Unable to open file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.initialize(uRL);
        SoundBuffer soundBuffer = iCodec.readAll();
        iCodec.cleanup();
        iCodec = null;
        if (this.errorCheck(soundBuffer == null, "Sound buffer null in method 'loadSound'")) {
            return false;
        }
        this.bufferMap.put(filenameURL.getFilename(), soundBuffer);
        AudioFormat audioFormat = soundBuffer.audioFormat;
        int n10 = 0;
        if (audioFormat.getChannels() == 1) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                n10 = 4352;
            } else {
                if (audioFormat.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                n10 = 4353;
            }
        } else {
            if (audioFormat.getChannels() != 2) {
                this.errorMessage("File neither mono nor stereo in method 'loadSound'");
                return false;
            }
            if (audioFormat.getSampleSizeInBits() == 8) {
                n10 = 4354;
            } else {
                if (audioFormat.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                n10 = 4355;
            }
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGenBuffers((IntBuffer)intBuffer);
        if (this.errorCheck(AL10.alGetError() != 0, "alGenBuffers error when loading " + filenameURL.getFilename())) {
            return false;
        }
        AL10.alBufferData((int)intBuffer.get(0), (int)n10, (ByteBuffer)((ByteBuffer)BufferUtils.createByteBuffer((int)soundBuffer.audioData.length).put(soundBuffer.audioData).flip()), (int)((int)audioFormat.getSampleRate()));
        if (this.errorCheck(AL10.alGetError() != 0, "alBufferData error when loading " + filenameURL.getFilename()) && this.errorCheck(intBuffer == null, "Sound buffer was not created for " + filenameURL.getFilename())) {
            return false;
        }
        this.ALBufferMap.put(filenameURL.getFilename(), intBuffer);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean loadSound(SoundBuffer soundBuffer, String string) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.ALBufferMap == null) {
            this.ALBufferMap = new HashMap();
            this.importantMessage("Open AL Buffer Map was null in method'loadSound'");
        }
        if (this.errorCheck(string == null, "Identifier not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(string) != null) {
            return true;
        }
        if (this.errorCheck(soundBuffer == null, "Sound buffer null in method 'loadSound'")) {
            return false;
        }
        this.bufferMap.put(string, soundBuffer);
        AudioFormat audioFormat = soundBuffer.audioFormat;
        int n10 = 0;
        if (audioFormat.getChannels() == 1) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                n10 = 4352;
            } else {
                if (audioFormat.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                n10 = 4353;
            }
        } else {
            if (audioFormat.getChannels() != 2) {
                this.errorMessage("File neither mono nor stereo in method 'loadSound'");
                return false;
            }
            if (audioFormat.getSampleSizeInBits() == 8) {
                n10 = 4354;
            } else {
                if (audioFormat.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                n10 = 4355;
            }
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGenBuffers((IntBuffer)intBuffer);
        if (this.errorCheck(AL10.alGetError() != 0, "alGenBuffers error when saving " + string)) {
            return false;
        }
        AL10.alBufferData((int)intBuffer.get(0), (int)n10, (ByteBuffer)((ByteBuffer)BufferUtils.createByteBuffer((int)soundBuffer.audioData.length).put(soundBuffer.audioData).flip()), (int)((int)audioFormat.getSampleRate()));
        if (this.errorCheck(AL10.alGetError() != 0, "alBufferData error when saving " + string) && this.errorCheck(intBuffer == null, "Sound buffer was not created for " + string)) {
            return false;
        }
        this.ALBufferMap.put(string, intBuffer);
        return true;
    }

    public void unloadSound(String string) {
        this.ALBufferMap.remove(string);
        super.unloadSound(string);
    }

    public void setMasterVolume(float f10) {
        super.setMasterVolume(f10);
        AL10.alListenerf((int)4106, (float)f10);
        this.checkALError();
    }

    public void newSource(boolean bl2, boolean bl3, boolean bl4, String string, FilenameURL filenameURL, float f10, float f11, float f12, int n10, float f13) {
        IntBuffer intBuffer = null;
        if (!bl3) {
            intBuffer = (IntBuffer)this.ALBufferMap.get(filenameURL.getFilename());
            if (intBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + string + "' was not created " + "because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            intBuffer = (IntBuffer)this.ALBufferMap.get(filenameURL.getFilename());
            if (intBuffer == null) {
                this.errorMessage("Source '" + string + "' was not created " + "because a sound buffer was not found for " + filenameURL.getFilename());
                return;
            }
        }
        SoundBuffer soundBuffer = null;
        if (!bl3) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + string + "' was not created " + "because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + string + "' was not created " + "because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        this.sourceMap.put(string, new SourceLWJGLOpenAL(this.listenerPositionAL, intBuffer, bl2, bl3, bl4, string, filenameURL, soundBuffer, f10, f11, f12, n10, f13, false));
    }

    public void rawDataStream(AudioFormat audioFormat, boolean bl2, String string, float f10, float f11, float f12, int n10, float f13) {
        this.sourceMap.put(string, new SourceLWJGLOpenAL(this.listenerPositionAL, audioFormat, bl2, string, f10, f11, f12, n10, f13));
    }

    public void quickPlay(boolean bl2, boolean bl3, boolean bl4, String string, FilenameURL filenameURL, float f10, float f11, float f12, int n10, float f13, boolean bl5) {
        IntBuffer intBuffer = null;
        if (!bl3) {
            intBuffer = (IntBuffer)this.ALBufferMap.get(filenameURL.getFilename());
            if (intBuffer == null) {
                this.loadSound(filenameURL);
            }
            if ((intBuffer = (IntBuffer)this.ALBufferMap.get(filenameURL.getFilename())) == null) {
                this.errorMessage("Sound buffer was not created for " + filenameURL.getFilename());
                return;
            }
        }
        SoundBuffer soundBuffer = null;
        if (!bl3) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + string + "' was not created " + "because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + string + "' was not created " + "because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        SourceLWJGLOpenAL sourceLWJGLOpenAL = new SourceLWJGLOpenAL(this.listenerPositionAL, intBuffer, bl2, bl3, bl4, string, filenameURL, soundBuffer, f10, f11, f12, n10, f13, false);
        this.sourceMap.put(string, sourceLWJGLOpenAL);
        this.play(sourceLWJGLOpenAL);
        if (bl5) {
            sourceLWJGLOpenAL.setTemporary(true);
        }
    }

    public void copySources(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'copySources'");
        }
        if (this.ALBufferMap == null) {
            this.ALBufferMap = new HashMap();
            this.importantMessage("Open AL Buffer Map was null in method'copySources'");
        }
        this.sourceMap.clear();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Source source = (Source)hashMap.get(string);
            if (source == null) continue;
            SoundBuffer soundBuffer = null;
            if (!source.toStream) {
                this.loadSound(source.filenameURL);
                soundBuffer = (SoundBuffer)this.bufferMap.get(source.filenameURL.getFilename());
            }
            if (!source.toStream && soundBuffer == null) continue;
            this.sourceMap.put(string, new SourceLWJGLOpenAL(this.listenerPositionAL, (IntBuffer)this.ALBufferMap.get(source.filenameURL.getFilename()), source, soundBuffer));
        }
    }

    public void setListenerPosition(float f10, float f11, float f12) {
        super.setListenerPosition(f10, f11, f12);
        this.listenerPositionAL.put(0, f10);
        this.listenerPositionAL.put(1, f11);
        this.listenerPositionAL.put(2, f12);
        AL10.alListener((int)4100, (FloatBuffer)this.listenerPositionAL);
        this.checkALError();
    }

    public void setListenerAngle(float f10) {
        super.setListenerAngle(f10);
        this.listenerOrientation.put(0, this.listener.lookAt.x);
        this.listenerOrientation.put(2, this.listener.lookAt.z);
        AL10.alListener((int)4111, (FloatBuffer)this.listenerOrientation);
        this.checkALError();
    }

    public void setListenerOrientation(float f10, float f11, float f12, float f13, float f14, float f15) {
        super.setListenerOrientation(f10, f11, f12, f13, f14, f15);
        this.listenerOrientation.put(0, f10);
        this.listenerOrientation.put(1, f11);
        this.listenerOrientation.put(2, f12);
        this.listenerOrientation.put(3, f13);
        this.listenerOrientation.put(4, f14);
        this.listenerOrientation.put(5, f15);
        AL10.alListener((int)4111, (FloatBuffer)this.listenerOrientation);
        this.checkALError();
    }

    public void setListenerData(ListenerData listenerData) {
        super.setListenerData(listenerData);
        this.listenerPositionAL.put(0, listenerData.position.x);
        this.listenerPositionAL.put(1, listenerData.position.y);
        this.listenerPositionAL.put(2, listenerData.position.z);
        AL10.alListener((int)4100, (FloatBuffer)this.listenerPositionAL);
        this.checkALError();
        this.listenerOrientation.put(0, listenerData.lookAt.x);
        this.listenerOrientation.put(1, listenerData.lookAt.y);
        this.listenerOrientation.put(2, listenerData.lookAt.z);
        this.listenerOrientation.put(3, listenerData.up.x);
        this.listenerOrientation.put(4, listenerData.up.y);
        this.listenerOrientation.put(5, listenerData.up.z);
        AL10.alListener((int)4111, (FloatBuffer)this.listenerOrientation);
        this.checkALError();
        this.listenerVelocity.put(0, listenerData.velocity.x);
        this.listenerVelocity.put(1, listenerData.velocity.y);
        this.listenerVelocity.put(2, listenerData.velocity.z);
        AL10.alListener((int)4102, (FloatBuffer)this.listenerVelocity);
        this.checkALError();
    }

    public void setListenerVelocity(float f10, float f11, float f12) {
        super.setListenerVelocity(f10, f11, f12);
        this.listenerVelocity.put(0, this.listener.velocity.x);
        this.listenerVelocity.put(1, this.listener.velocity.y);
        this.listenerVelocity.put(2, this.listener.velocity.z);
        AL10.alListener((int)4102, (FloatBuffer)this.listenerVelocity);
    }

    public void dopplerChanged() {
        super.dopplerChanged();
        AL10.alDopplerFactor((float)SoundSystemConfig.getDopplerFactor());
        this.checkALError();
        AL10.alDopplerVelocity((float)SoundSystemConfig.getDopplerVelocity());
        this.checkALError();
    }

    private boolean checkALError() {
        switch (AL10.alGetError()) {
            case 0: {
                return false;
            }
            case 40961: {
                this.errorMessage("Invalid name parameter.");
                return true;
            }
            case 40962: {
                this.errorMessage("Invalid parameter.");
                return true;
            }
            case 40963: {
                this.errorMessage("Invalid enumerated parameter value.");
                return true;
            }
            case 40964: {
                this.errorMessage("Illegal call.");
                return true;
            }
            case 40965: {
                this.errorMessage("Unable to allocate memory.");
                return true;
            }
        }
        this.errorMessage("An unrecognized error occurred.");
        return true;
    }

    public static boolean alPitchSupported() {
        return LibraryLWJGLOpenAL.alPitchSupported(false, false);
    }

    private static synchronized boolean alPitchSupported(boolean bl2, boolean bl3) {
        if (bl2) {
            alPitchSupported = bl3;
        }
        return alPitchSupported;
    }

    public static String getTitle() {
        return "LWJGL OpenAL";
    }

    public static String getDescription() {
        return "The LWJGL binding of OpenAL.  For more information, see http://www.lwjgl.org";
    }

    public String getClassName() {
        return "LibraryLWJGLOpenAL";
    }
}

