/*
 * Decompiled with CFR 0.152.
 */
package elliandetector;

import elliandetector.EllianDetector;
import elliandetector.EllianDetector2MinecraftProxy;
import elliandetector.EllianDetectorConfiguration;
import elliandetector.Vein;
import java.util.HashMap;

public class EllianDetectorCalculator {
    private static EllianDetectorCalculator calculator = null;
    private int distance = 10;
    private HashMap<String, Vein> veins = new HashMap();

    public static EllianDetectorCalculator getInstance() {
        if (calculator == null) {
            calculator = new EllianDetectorCalculator();
        }
        return calculator;
    }

    private synchronized void clearVeins(EllianDetector detector) {
        int i = 0;
        while (i < this.veins.size()) {
            Vein vein = (Vein)this.veins.values().toArray()[i];
            String key = String.valueOf(vein.getX() - 1) + "_" + (vein.getZ() - 1);
            if (this.veins.containsKey(key)) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX()) + "_" + (vein.getZ() - 1))) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX() + 1) + "_" + (vein.getZ() - 1))) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX() - 1) + "_" + vein.getZ())) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX() + 1) + "_" + vein.getZ())) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX() - 1) + "_" + (vein.getZ() + 1))) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX()) + "_" + (vein.getZ() + 1))) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX() + 1) + "_" + (vein.getZ() + 1))) {
                this.veins.remove(key);
            }
            ++i;
        }
    }

    public HashMap<String, Vein> getVeins() {
        return this.veins;
    }

    public void mapCalcDetector(EllianDetector detector) {
        this.veins = new HashMap();
        int lastZoom = detector.getZoom();
        int multi = (int)Math.pow(2.0, lastZoom);
        int i = EllianDetector2MinecraftProxy.xCoord();
        int j = EllianDetector2MinecraftProxy.yCoord();
        int alt = EllianDetector2MinecraftProxy.zCoord();
        if (detector.isVertical()) {
            i = EllianDetector2MinecraftProxy.zCoord();
            j = EllianDetector2MinecraftProxy.xCoord();
            alt = EllianDetector2MinecraftProxy.yCoord();
        }
        detector.setLastX(EllianDetector2MinecraftProxy.xCoord());
        detector.setLastZ(EllianDetector2MinecraftProxy.zCoord());
        detector.setLastY(EllianDetector2MinecraftProxy.yCoord());
        if (!detector.isVertical()) {
            j += 16 * multi;
        }
        i -= 16 * multi;
        int k = 0;
        int m = 0;
        while (m < 32 * multi) {
            int n = 0;
            while (n < 32 * multi) {
                k = 0x737373;
                boolean check = false;
                if (Math.sqrt((16 * multi - m) * (16 * multi - m) + (16 * multi - n) * (16 * multi - n)) < (double)(16 * multi - (int)Math.sqrt(multi))) {
                    check = true;
                }
                int floor = EllianDetector2MinecraftProxy.getFloor(i + m, j - n);
                if (detector.isVertical()) {
                    floor = EllianDetector2MinecraftProxy.getFloor(i + m, j - n);
                }
                if (check) {
                    k = EllianDetector.getBlockColor(EllianDetector2MinecraftProxy.getMaterial(i + m, alt - 1, j - n), EllianDetector2MinecraftProxy.getMaterialSubType(i + m, alt - 1, j - n));
                    if (detector.isVertical()) {
                        int X = j + (int)Math.round((double)(n - 16 * multi) * Math.cos(1.5707963267948966 + Math.toRadians(detector.getDirection())));
                        int Y = alt - (int)Math.round((double)(n - 16 * multi) * Math.sin(1.5707963267948966 + Math.toRadians(detector.getDirection())));
                        k = EllianDetector.getBlockColor(EllianDetector2MinecraftProxy.getMaterial(X, i + m, Y), EllianDetector2MinecraftProxy.getMaterialSubType(X, i + m, Y));
                    }
                    if (!detector.isVertical()) {
                        int block;
                        int min = 2;
                        int max = floor;
                        if (detector.isFiltered()) {
                            min = Math.max(2, alt - this.distance);
                            max = Math.min(floor, alt + this.distance);
                            if (detector.isVertical()) {
                                min = -2;
                                max = 2;
                            }
                        }
                        int deep = min;
                        while (deep < max) {
                            int blockSub;
                            block = EllianDetector2MinecraftProxy.getMaterial(i + m, deep, j - n);
                            if (detector.isSameHasCurrentMaterial(block, blockSub = EllianDetector2MinecraftProxy.getMaterialSubType(i + m, deep, j - n))) {
                                String materialName = detector.getCurrentMaterialName();
                                Vein vein = new Vein(materialName.substring(0, 1), i + m, j - n, deep - alt);
                                this.veins.put(vein.getKey(), vein);
                                break;
                            }
                            ++deep;
                        }
                        min = Math.max(2, alt - 3);
                        max = Math.min(floor, alt + 3);
                        if (detector.isVertical()) {
                            min = -2;
                            max = 2;
                        }
                        deep = min;
                        while (deep < max) {
                            block = EllianDetector2MinecraftProxy.getMaterial(i + m, deep, j - n);
                            int subType = EllianDetector2MinecraftProxy.getMaterialSubType(i + m, deep, j - n);
                            if (detector.isVertical()) {
                                block = EllianDetector2MinecraftProxy.getMaterial(j - n, i + m, deep);
                                subType = EllianDetector2MinecraftProxy.getMaterialSubType(i + m, deep, j - n);
                            }
                            if (block == EllianDetectorConfiguration.MAT_LAVA_STAT) {
                                k = EllianDetector.getBlockColor(String.valueOf(EllianDetectorConfiguration.MAT_LAVA_STAT));
                                break;
                            }
                            if (block == EllianDetectorConfiguration.MAT_WATER_STAT) {
                                k = EllianDetector.getBlockColor(String.valueOf(EllianDetectorConfiguration.MAT_WATER_STAT));
                                break;
                            }
                            if (detector.isInMaterials(block + ":" + subType)) {
                                k = EllianDetector.getBlockColor(block, subType);
                                break;
                            }
                            ++deep;
                        }
                    }
                }
                if (k != EllianDetectorConfiguration.COLOR_TRANSPARENT && k != 0 && check) {
                    int i3 = 255;
                    if (i3 > 255) {
                        i3 = 255;
                    }
                    if (i3 < 32) {
                        i3 = 32;
                    }
                    k = i3 * 0x1000000 + k;
                }
                detector.getMapImage(lastZoom).setRGB(n, m, k);
                ++n;
            }
            ++m;
        }
        this.clearVeins(detector);
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }
}

