/*
 * Decompiled with CFR 0.152.
 */
package elliandetector;

import elliandetector.EllianDetector;
import elliandetector.EllianDetectorRenderer;
import elliandetector.EnumOptionValue;
import elliandetector.Material;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;

public class EllianDetectorConfiguration {
    private static String BIGGER = "Bigger";
    private static String DIRECTION_KEY = "DirectionKey";
    private static String MENU_KEY = "MenuKey";
    private static String FILTERED = "Filtered";
    private static String HIDDEN = "Hidden";
    public static int MAT_DIAMOND = 56;
    public static int MAT_IRON = 15;
    public static int MAT_LAVA_STAT = 11;
    public static int MAT_WATER_STAT = 9;
    private static String MATERIAL = "Material";
    private static String MATERIAL_KEY = "MaterialKey";
    private static String POSITION = "Position";
    private static String VERTICAL = "Vertical";
    private static String ZOOM_KEY = "ZoomKey";
    private static String ZOOM_LEVEL = "ZoomLevel";
    public static int COLOR_TRANSPARENT = 0xC0C0C0;
    public static String CONFIG_FOLDER = EllianDetectorConfiguration.getAppDir("minecraft") + File.separator + "config";

    public static File getAppDir(String app) {
        return Minecraft.a((String)app);
    }

    public static void loadBlockColors(EllianDetector detector) {
        HashMap<String, Integer> blockColors = new HashMap<String, Integer>();
        blockColors.put("1", 0x686868);
        blockColors.put("2", 7648330);
        blockColors.put("3", 7951674);
        blockColors.put("4", 0x959595);
        blockColors.put("5", 12359778);
        blockColors.put("6", 9724968);
        blockColors.put("7", 0x333333);
        blockColors.put("8", 3299071);
        blockColors.put("9", 3299071);
        blockColors.put("10", 14247188);
        blockColors.put("11", 14247188);
        blockColors.put("12", 14538656);
        blockColors.put("13", 0x747474);
        blockColors.put("14", 16710493);
        blockColors.put("15", 0xE9E9E9);
        blockColors.put("16", 0x720000);
        blockColors.put("17", 3418393);
        blockColors.put("18", 1461516);
        blockColors.put("19", 0xE5E54E);
        blockColors.put("20", 0xFFFFFF);
        blockColors.put("24", 13024621);
        blockColors.put("35", 0xF1F1F1);
        blockColors.put("37", 15857922);
        blockColors.put("38", 0xF7070F);
        blockColors.put("39", 9530709);
        blockColors.put("40", 10098460);
        blockColors.put("41", 16710493);
        blockColors.put("42", 0xE9E9E9);
        blockColors.put("43", 0xA8A8A8);
        blockColors.put("44", 0xA8A8A8);
        blockColors.put("45", 11162683);
        blockColors.put("46", 14369818);
        blockColors.put("47", 11833434);
        blockColors.put("48", 2049823);
        blockColors.put("49", 0x101018);
        blockColors.put("50", 16766976);
        blockColors.put("51", 12605953);
        blockColors.put("52", 2514823);
        blockColors.put("53", 12359778);
        blockColors.put("54", 9398557);
        blockColors.put("55", 0x480000);
        blockColors.put("56", 3327487);
        blockColors.put("57", 8578272);
        blockColors.put("58", 10644286);
        blockColors.put("59", 57872);
        blockColors.put("60", 6504228);
        blockColors.put("61", 0x747474);
        blockColors.put("62", 0x747474);
        blockColors.put("63", 11833434);
        blockColors.put("64", 8018731);
        blockColors.put("65", 11307090);
        blockColors.put("66", 0xA4A4A4);
        blockColors.put("67", 0x9E9E9E);
        blockColors.put("68", 10454093);
        blockColors.put("69", 6902835);
        blockColors.put("70", 0x8F8F8F);
        blockColors.put("71", 0xC1C1C1);
        blockColors.put("72", 12359778);
        blockColors.put("73", 9830912);
        blockColors.put("74", 9830912);
        blockColors.put("75", 0x290000);
        blockColors.put("76", 0xFD0000);
        blockColors.put("77", 0x747474);
        blockColors.put("78", 0xFBFFFF);
        blockColors.put("79", 9355263);
        blockColors.put("80", 0xFFFFFF);
        blockColors.put("81", 1146910);
        blockColors.put("82", 0xFFFFFF);
        blockColors.put("83", 10594226);
        blockColors.put("84", 11197300);
        blockColors.put("85", 10184267);
        blockColors.put("86", 12359778);
        blockColors.put("87", 5775896);
        blockColors.put("88", 10053425);
        blockColors.put("89", 13477944);
        blockColors.put("90", 7545990);
        blockColors.put("91", 16763021);
        blockColors.put("92", 0xC5C5C5);
        blockColors.put("93", 0x999999);
        blockColors.put("94", 0x999999);
        blockColors.put("95", 4140301);
        blockColors.put("96", 8676658);
        blockColors.put("97", 0x707070);
        blockColors.put("98", 0x707070);
        blockColors.put("99", 8676173);
        blockColors.put("100", 11083035);
        blockColors.put("101", 0xFFFFFF);
        blockColors.put("102", 0xFFFFFF);
        blockColors.put("103", 7831328);
        blockColors.put("104", 9224030);
        blockColors.put("105", 9224030);
        blockColors.put("106", 2316811);
        blockColors.put("107", 3155736);
        blockColors.put("108", 10385775);
        blockColors.put("109", 0x4F4F4F);
        blockColors.put("110", 6182745);
        blockColors.put("111", 1337632);
        blockColors.put("112", 2560791);
        blockColors.put("113", 2560791);
        blockColors.put("114", 2560791);
        blockColors.put("115", 7603718);
        blockColors.put("116", 0x520000);
        blockColors.put("117", 0x292929);
        blockColors.put("118", 2560791);
        blockColors.put("119", 2560791);
        blockColors.put("120", 3562068);
        blockColors.put("121", 14409647);
        blockColors.put("122", 2560791);
        blockColors.put("123", 1839112);
        blockColors.put("124", 5128233);
        blockColors.put("125", 10058829);
        blockColors.put("126", 10058829);
        blockColors.put("127", 11101993);
        blockColors.put("128", 0xC9C191);
        blockColors.put("129", 39168);
        blockColors.put("130", 2438456);
        blockColors.put("131", 7099957);
        blockColors.put("132", 0xD5D5D5);
        blockColors.put("133", 4705901);
        blockColors.put("134", 6507052);
        blockColors.put("135", 12233076);
        blockColors.put("136", 10515538);
        blockColors.put("137", 10786185);
        blockColors.put("138", 13565435);
        blockColors.put("139", 0x959595);
        blockColors.put("140", 7027245);
        blockColors.put("141", 430592);
        blockColors.put("142", 1355308);
        blockColors.put("143", 9730888);
        blockColors.put("144", 0x9D9D9D);
        blockColors.put("145", 0x3F3C3C);
        blockColors.put("146", 9922593);
        blockColors.put("147", 15590721);
        blockColors.put("148", 0xD5D5D5);
        blockColors.put("149", 0xA9A9A9);
        blockColors.put("150", 0xA9A9A9);
        blockColors.put("151", 12760740);
        blockColors.put("152", 12263433);
        blockColors.put("153", 7823453);
        blockColors.put("154", 0x3A3A3A);
        blockColors.put("155", 0xDDDCD6);
        blockColors.put("156", 0xEEECE7);
        blockColors.put("242", 6766615);
        blockColors.put("244", 0x11FF00);
        blockColors.put("247", 0x11FF00);
        blockColors.put("248", 0x99FFCC);
        blockColors.put("249", 0xCC99FF);
        try {
            File settingsFile = new File(CONFIG_FOLDER, "materialsColours.txt");
            if (settingsFile.exists()) {
                String sCurrentLine;
                BufferedReader in = new BufferedReader(new FileReader(settingsFile));
                while ((sCurrentLine = in.readLine()) != null) {
                    String[] curLine = sCurrentLine.split("=");
                    try {
                        if (curLine.length != 2) continue;
                        blockColors.put(curLine[0], Integer.parseInt(curLine[1], 16));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        blockColors.put(curLine[0], COLOR_TRANSPARENT);
                    }
                }
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EllianDetector.blockColors = blockColors;
    }

    public static void loadCurrentConf(EllianDetector detector) {
        File settingsFile = new File(CONFIG_FOLDER, "EllianDetector.current.settings");
        try {
            if (settingsFile.exists()) {
                Properties settings = new Properties();
                settings.load(new BufferedReader(new FileReader(settingsFile)));
                if (settings.containsKey(ZOOM_LEVEL)) {
                    detector.setZoom(Integer.parseInt(settings.getProperty(ZOOM_LEVEL)));
                } else {
                    detector.setZoom(1);
                }
                if (settings.containsKey(MATERIAL)) {
                    detector.setMaterial(settings.getProperty(MATERIAL));
                } else {
                    detector.changeMaterial();
                }
                if (settings.containsKey(FILTERED)) {
                    detector.setFiltered(Boolean.parseBoolean(settings.getProperty(FILTERED)));
                }
                if (settings.containsKey(VERTICAL)) {
                    detector.setVertical(Boolean.parseBoolean(settings.getProperty(VERTICAL)));
                }
                if (settings.containsKey(HIDDEN)) {
                    detector.setHidden(Boolean.parseBoolean(settings.getProperty(HIDDEN)));
                } else {
                    detector.setHidden(false);
                }
                if (settings.containsKey(BIGGER)) {
                    EllianDetectorRenderer.getInstance().setBigger(EnumOptionValue.Enum2Bigger(EnumOptionValue.valueOf(settings.getProperty(BIGGER))));
                } else {
                    EllianDetectorRenderer.getInstance().setBigger(1.0f);
                }
                if (settings.containsKey(POSITION)) {
                    EllianDetectorRenderer.getInstance().updatePosition(settings.getProperty(POSITION));
                } else {
                    EllianDetectorRenderer.getInstance().updatePosition("RIGHT_MIDDLE");
                }
                if (settings.containsKey(MATERIAL_KEY)) {
                    EllianDetector.KEY_MATERIAL.setKeyIndex(Keyboard.getKeyIndex((String)settings.getProperty(MATERIAL_KEY)));
                    settings.remove(MATERIAL_KEY);
                }
                if (settings.containsKey(ZOOM_KEY)) {
                    EllianDetector.KEY_ZOOM.setKeyIndex(Keyboard.getKeyIndex((String)settings.getProperty(ZOOM_KEY)));
                    settings.remove(ZOOM_KEY);
                }
                if (settings.containsKey(MENU_KEY)) {
                    EllianDetector.KEY_MENU.setKeyIndex(Keyboard.getKeyIndex((String)settings.getProperty(MENU_KEY)));
                    settings.remove(MENU_KEY);
                }
                if (settings.containsKey(DIRECTION_KEY)) {
                    EllianDetector.KEY_DIRECTION.setKeyIndex(Keyboard.getKeyIndex((String)settings.getProperty(DIRECTION_KEY)));
                    settings.remove(DIRECTION_KEY);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadMaterials(EllianDetector detector) {
        File materialsFile = new File(CONFIG_FOLDER, "EllianDetector.materials.settings");
        try {
            if (materialsFile.exists()) {
                HashMap<String, Material> materials = new HashMap<String, Material>();
                Properties settings = new Properties();
                settings.load(new BufferedReader(new FileReader(materialsFile)));
                for (Object key : settings.keySet()) {
                    String id;
                    if (!((String)key).startsWith("@")) {
                        id = settings.getProperty((String)key);
                        materials.put(id, new Material((String)key, true, id));
                        continue;
                    }
                    id = settings.getProperty((String)key);
                    materials.put(id, new Material(((String)key).substring(1), false, id));
                }
                if (materials.size() == 0) {
                    materials.put(String.valueOf(MAT_DIAMOND), new Material("Diamond", true, MAT_DIAMOND, 0));
                    materials.put(String.valueOf(MAT_IRON), new Material("Iron", true, MAT_IRON, 0));
                }
                detector.setMaterials(materials);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeCurrentColors(EllianDetector detector) {
        File settingsFile = new File(CONFIG_FOLDER, "materialsColours.txt");
        try {
            PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
            for (String blockId : EllianDetector.blockColors.keySet()) {
                out.println(String.valueOf(blockId) + "=" + Integer.toHexString(EllianDetector.blockColors.get(blockId)));
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeCurrentConf(EllianDetector detector) {
        File settingsFile = new File(CONFIG_FOLDER, "EllianDetector.current.settings");
        try {
            PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
            out.println(String.valueOf(ZOOM_LEVEL) + "=" + detector.getZoom());
            out.println(String.valueOf(MATERIAL) + "=" + detector.getCurrentMaterialId());
            out.println(String.valueOf(FILTERED) + "=" + detector.isFiltered());
            out.println(String.valueOf(VERTICAL) + "=" + detector.isVertical());
            out.println(String.valueOf(BIGGER) + "=" + EnumOptionValue.Bigger2Enum().key());
            out.println(String.valueOf(HIDDEN) + "=" + detector.isHidden());
            out.println(String.valueOf(POSITION) + "=" + EllianDetectorRenderer.getInstance().getPosition());
            out.println(String.valueOf(ZOOM_KEY) + "=" + EllianDetector.KEY_ZOOM.getKeyName());
            out.println(String.valueOf(MENU_KEY) + "=" + EllianDetector.KEY_MENU.getKeyName());
            out.println(String.valueOf(MATERIAL_KEY) + "=" + EllianDetector.KEY_MATERIAL.getKeyName());
            out.println(String.valueOf(DIRECTION_KEY) + "=" + EllianDetector.KEY_DIRECTION.getKeyName());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeMaterials(EllianDetector detector) {
        File materialsFile = new File(CONFIG_FOLDER, "EllianDetector.materials.settings");
        try {
            PrintWriter out = new PrintWriter(new FileWriter(materialsFile));
            for (Material material : detector.getMaterials()) {
                if (material.isEnable()) {
                    out.println(material.toString());
                    continue;
                }
                out.println("@" + material.toString());
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

