/*
 * Decompiled with CFR 0.152.
 */
package elliandetector;

import elliandetector.EllianDetector;
import elliandetector.EllianDetector2MinecraftProxy;
import elliandetector.EllianDetectorCalculator;
import elliandetector.Vein;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;

public class EllianDetectorRenderer {
    private static EllianDetectorRenderer renderer = null;
    private float bigger = 1.0f;
    private float direction = 0.0f;
    private int posX = 2;
    private int posY = 1;
    private int[] indexes = new int[8];
    private BufferedImage[] images = new BufferedImage[8];
    private static final int INDEX_MAP = 0;
    private static final int INDEX_ROUNDH = 1;
    private static final int INDEX_ROUNDV = 2;
    private static final int INDEX_ABOVEABOVE = 3;
    private static final int INDEX_ABOVE = 4;
    private static final int INDEX_BELOWBELOW = 5;
    private static final int INDEX_BELOW = 6;
    private static final int INDEX_SAME = 7;
    private int scHeight;
    private int scWidth;
    private int zoom = 1;
    private String position = "";

    public static EllianDetectorRenderer getInstance() {
        if (renderer == null) {
            renderer = new EllianDetectorRenderer();
        }
        return renderer;
    }

    private EllianDetectorRenderer() {
        this.images[3] = EllianDetectorRenderer.readImage("/elliandetector/aboveabove.png");
        this.images[4] = EllianDetectorRenderer.readImage("/elliandetector/above.png");
        this.images[2] = EllianDetectorRenderer.readImage("/elliandetector/mat_Vroundmap.png");
        this.images[1] = EllianDetectorRenderer.readImage("/elliandetector/mat_roundmap.png");
        this.images[5] = EllianDetectorRenderer.readImage("/elliandetector/belowbelow.png");
        this.images[6] = EllianDetectorRenderer.readImage("/elliandetector/below.png");
        this.images[7] = EllianDetectorRenderer.readImage("/elliandetector/same.png");
    }

    private void drawDirections(EllianDetector detector) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)this.bigger * 64.0 * Math.sin(Math.toRadians(-((double)this.direction - 90.0)))), (double)((double)this.bigger * 64.0 * Math.cos(Math.toRadians(-((double)this.direction - 90.0)))), (double)0.0);
        EllianDetector2MinecraftProxy.write("W", (int)((float)(this.scWidth * 2) - this.bigger * 66.0f), (int)(this.bigger * 70.0f), 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)this.bigger * 64.0 * Math.sin(Math.toRadians(-this.direction))), (double)((double)this.bigger * 64.0 * Math.cos(Math.toRadians(-this.direction))), (double)0.0);
        EllianDetector2MinecraftProxy.write("N", (int)((float)(this.scWidth * 2) - this.bigger * 66.0f), (int)(this.bigger * 70.0f), 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)this.bigger * 64.0 * Math.sin(Math.toRadians(-((double)this.direction + 90.0)))), (double)((double)this.bigger * 64.0 * Math.cos(Math.toRadians(-((double)this.direction + 90.0)))), (double)0.0);
        EllianDetector2MinecraftProxy.write("E", (int)((float)(this.scWidth * 2) - this.bigger * 66.0f), (int)(this.bigger * 70.0f), 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)this.bigger * 64.0 * Math.sin(Math.toRadians(-((double)this.direction + 180.0)))), (double)((double)this.bigger * 64.0 * Math.cos(Math.toRadians(-((double)this.direction + 180.0)))), (double)0.0);
        EllianDetector2MinecraftProxy.write("S", (int)((float)(this.scWidth * 2) - this.bigger * 66.0f), (int)(this.bigger * 70.0f), 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)this.bigger * 64.0 * Math.sin(Math.toRadians(0.0)) - 12.0), (double)((double)this.bigger * 64.0 * Math.cos(Math.toRadians(0.0)) + 7.0), (double)0.0);
        String str = "Zoom ";
        if (this.zoom == 2) {
            str = String.valueOf(str) + "1x";
        } else if (this.zoom == 1) {
            str = String.valueOf(str) + "2x";
        } else if (this.zoom == 0) {
            str = String.valueOf(str) + "4x";
        }
        EllianDetector2MinecraftProxy.write(str, (int)((float)(this.scWidth * 2) - this.bigger * 66.0f), (int)(this.bigger * 70.0f), 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)this.bigger * 64.0 * Math.sin(Math.toRadians(180.0)) - 12.0), (double)((double)this.bigger * 64.0 * Math.cos(Math.toRadians(180.0)) - 10.0), (double)0.0);
        if (!detector.isVertical()) {
            EllianDetector2MinecraftProxy.write(detector.getCurrentMaterialName(), (int)((float)(this.scWidth * 2) - this.bigger * 66.0f), (int)(this.bigger * 70.0f), 0xFFFFFF);
        } else {
            EllianDetector2MinecraftProxy.write("V mode", (int)((float)(this.scWidth * 2) - this.bigger * 66.0f), (int)(this.bigger * 70.0f), 0xFFFFFF);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)this.bigger * 64.0 * Math.sin(Math.toRadians(0.0)) + 28.0), (double)((double)this.bigger * 64.0 * Math.cos(Math.toRadians(0.0)) - 5.0), (double)0.0);
        EllianDetector2MinecraftProxy.write("Menu=" + EllianDetector.KEY_MENU.getKeyName(), (int)((float)(this.scWidth * 2) - this.bigger * 66.0f), (int)(this.bigger * 70.0f), 0xFFFFFF);
        GL11.glPopMatrix();
    }

    private void drawMap() {
        EllianDetector2MinecraftProxy.ldrawthree((double)this.scWidth - (double)this.bigger * 64.0, (double)this.bigger * 64.0 + 5.0, 1.0, 0.0, 1.0);
        EllianDetector2MinecraftProxy.ldrawthree(this.scWidth, (double)this.bigger * 64.0 + 5.0, 1.0, 1.0, 1.0);
        EllianDetector2MinecraftProxy.ldrawthree(this.scWidth, 5.0, 1.0, 1.0, 0.0);
        EllianDetector2MinecraftProxy.ldrawthree((double)this.scWidth - (double)this.bigger * 64.0, 5.0, 1.0, 0.0, 0.0);
    }

    private void drawRound(EllianDetector detector) {
        try {
            if (detector.isVertical()) {
                this.indexes[2] = EllianDetector2MinecraftProxy.tex(this.images[2]);
                EllianDetector2MinecraftProxy.disp(this.indexes[2]);
            } else {
                this.indexes[1] = EllianDetector2MinecraftProxy.tex(this.images[1]);
                EllianDetector2MinecraftProxy.disp(this.indexes[1]);
            }
            EllianDetector2MinecraftProxy.drawPre();
            this.drawMap();
            EllianDetector2MinecraftProxy.drawPost();
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }

    private static BufferedImage readImage(String stream) {
        InputStream in = EllianDetectorRenderer.class.getResourceAsStream(stream);
        if (in == null) {
            return null;
        }
        BufferedImage bufferedimage = null;
        try {
            bufferedimage = ImageIO.read(in);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            in.close();
        }
        catch (Exception exception) {}
        return bufferedimage;
    }

    public void refreshWindowSize() {
        this.scWidth = EllianDetector2MinecraftProxy.getWidth();
        this.scHeight = EllianDetector2MinecraftProxy.getHeight();
        this.scWidth -= 5;
    }

    private void deleteTextures() {
        int i = 0;
        while (i < this.indexes.length) {
            if (this.indexes[i] != 0) {
                EllianDetector2MinecraftProxy.deleteTex(this.indexes[i]);
                this.indexes[i] = 0;
            }
            ++i;
        }
    }

    private void drawTexture(int index) {
        this.indexes[index] = EllianDetector2MinecraftProxy.tex(this.images[index]);
        EllianDetector2MinecraftProxy.disp(this.indexes[index]);
    }

    public void renderMap(EllianDetector detector) {
        float x = 0.0f;
        if (this.posX == 2) {
            x = 0.0f;
        } else if (this.posX == 1) {
            x = (int)((double)(-this.scWidth) * 0.5 + (double)(this.bigger * 32.0f)) + 5;
        } else if (this.posX == 0) {
            x = (int)((float)(-this.scWidth) + 2.0f * this.bigger * 32.0f) + 7;
        }
        float y = 5.0f;
        if (this.posY == 0) {
            y = 5.0f;
        } else if (this.posY == 1) {
            y = (int)((float)(this.scHeight / 2) - this.bigger * 32.0f) - 5;
        } else if (this.posY == 2) {
            y = (int)((float)this.scHeight - 2.0f * this.bigger * 32.0f) - 12;
        }
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!detector.isHidden()) {
            this.deleteTextures();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            this.indexes[0] = this.bigger != 1.0f ? EllianDetector2MinecraftProxy.tex(this.zoom(detector.getMapImage(this.zoom), this.bigger)) : EllianDetector2MinecraftProxy.tex(detector.getMapImage(this.zoom));
            if (!detector.isVertical()) {
                GL11.glTranslatef((float)((float)this.scWidth - this.bigger * 32.0f), (float)(this.bigger * 32.0f + 5.0f), (float)0.0f);
                GL11.glRotatef((float)(this.direction + 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-((float)this.scWidth - this.bigger * 32.0f)), (float)(-(this.bigger * 32.0f + 5.0f)), (float)0.0f);
            } else {
                GL11.glTranslatef((float)((float)this.scWidth - this.bigger * 32.0f), (float)(this.bigger * 32.0f + 5.0f), (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-((float)this.scWidth - this.bigger * 32.0f)), (float)(-(this.bigger * 32.0f + 5.0f)), (float)0.0f);
            }
            if (this.zoom == 0) {
                GL11.glTranslatef((float)-1.1f, (float)-0.8f, (float)0.0f);
            } else {
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            }
            EllianDetector2MinecraftProxy.drawPre();
            this.drawMap();
            EllianDetector2MinecraftProxy.drawPost();
            GL11.glPopMatrix();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            this.drawRound(detector);
            this.drawDirections(detector);
            for (Vein vein : EllianDetectorCalculator.getInstance().getVeins().values()) {
                double diam;
                int wayX = EllianDetector2MinecraftProxy.xCoord() - vein.getX();
                int wayY = EllianDetector2MinecraftProxy.yCoord() - vein.getZ();
                float locate = (float)Math.toDegrees(Math.atan2(wayX, wayY));
                double hypot = Math.sqrt(wayX * wayX + wayY * wayY) / (Math.pow(2.0, this.zoom) / 2.0);
                if (hypot < (diam = 31.0 * (double)this.bigger)) {
                    try {
                        try {
                            GL11.glPushMatrix();
                            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                            if (vein.getDirection() > 0) {
                                if (vein.getDirection() > 10) {
                                    this.drawTexture(3);
                                } else {
                                    this.drawTexture(4);
                                }
                            } else if (vein.getDirection() < 0) {
                                if (vein.getDirection() < -10) {
                                    this.drawTexture(5);
                                } else {
                                    this.drawTexture(6);
                                }
                            } else {
                                this.drawTexture(7);
                            }
                            if (!detector.isVertical()) {
                                GL11.glTranslatef((float)((float)this.scWidth - this.bigger * 32.0f), (float)(this.bigger * 32.0f + 5.0f), (float)0.0f);
                                GL11.glRotatef((float)(-locate + this.direction + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                                GL11.glTranslated((double)0.0, (double)(-hypot * (double)this.bigger), (double)0.0);
                                GL11.glRotatef((float)(-(-locate + this.direction + 180.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
                                GL11.glTranslated((double)0.0, (double)(hypot * (double)this.bigger), (double)0.0);
                                GL11.glTranslatef((float)(-((float)this.scWidth - this.bigger * 32.0f)), (float)(-(this.bigger * 32.0f + 5.0f)), (float)0.0f);
                                GL11.glTranslated((double)0.0, (double)(-hypot * (double)this.bigger), (double)0.0);
                            }
                            EllianDetector2MinecraftProxy.drawPre();
                            this.drawMap();
                            EllianDetector2MinecraftProxy.drawPost();
                        }
                        catch (Exception localException) {
                            localException.printStackTrace();
                            GL11.glPopMatrix();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        GL11.glPopMatrix();
                        throw throwable;
                    }
                    GL11.glPopMatrix();
                    continue;
                }
                diam = 10.0;
            }
            GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
        }
    }

    public void setBigger(float bigger) {
        this.bigger = bigger;
    }

    public float getBigger() {
        return this.bigger;
    }

    public void setDirection(float direction) {
        this.direction = direction;
    }

    public void setScHeight(int scHeight) {
        this.scHeight = scHeight;
    }

    public void setScWidth(int scWidth) {
        this.scWidth = scWidth;
    }

    public void setXPosition(int x) {
        this.posX = x;
    }

    public void setYPosition(int y) {
        this.posY = y;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    private BufferedImage zoom(BufferedImage bi, double zoomValue) {
        if (bi == null) {
            return null;
        }
        BufferedImage biNew = new BufferedImage((int)((double)bi.getWidth() * zoomValue), (int)((double)bi.getHeight() * zoomValue), bi.getType());
        int it = 0;
        while (it < biNew.getWidth()) {
            int jt = 0;
            while (jt < biNew.getHeight()) {
                biNew.setRGB(it, jt, bi.getRGB((int)((double)it / zoomValue), (int)((double)jt / zoomValue)));
                ++jt;
            }
            ++it;
        }
        return biNew;
    }

    public String getPosition() {
        return this.position;
    }

    public void updatePosition(String pos) {
        this.position = pos;
        if (pos.equals("RIGHT_MIDDLE")) {
            this.posX = 2;
            this.posY = 1;
        } else if (pos.equals("RIGHT_TOP")) {
            this.posX = 2;
            this.posY = 0;
        } else if (pos.equals("RIGHT_BOTTOM")) {
            this.posX = 2;
            this.posY = 2;
        } else if (pos.equals("LEFT_MIDDLE")) {
            this.posX = 0;
            this.posY = 1;
        } else if (pos.equals("LEFT_TOP")) {
            this.posX = 0;
            this.posY = 0;
        } else if (pos.equals("LEFT_BOTTOM")) {
            this.posX = 0;
            this.posY = 2;
        } else if (pos.equals("CENTER_TOP")) {
            this.posX = 1;
            this.posY = 0;
        }
    }
}

