/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RandomMobs {
    private static Map textureVariantsMap = new HashMap();
    private static bfz renderGlobal = null;
    private static boolean initialized = false;
    private static Random random = new Random();
    private static boolean working = false;

    public static void entityLoaded(mp entity) {
        int randomId;
        if (!(entity instanceof ng)) {
            return;
        }
        if (entity instanceof sq) {
            return;
        }
        ng el2 = (ng)entity;
        iz ws2 = Config.getWorldServer();
        if (ws2 == null) {
            return;
        }
        mp es2 = ws2.a(entity.k);
        if (!(es2 instanceof ng)) {
            return;
        }
        ng els = (ng)es2;
        el2.persistentId = randomId = els.persistentId;
    }

    public static void worldChanged(aab oldWorld, aab newWorld) {
        if (newWorld != null) {
            List entityList = newWorld.B();
            for (int e2 = 0; e2 < entityList.size(); ++e2) {
                mp entity = (mp)entityList.get(e2);
                RandomMobs.entityLoaded(entity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTexture(String texture) {
        if (working) {
            return texture;
        }
        try {
            working = true;
            if (!initialized) {
                RandomMobs.initialize();
            }
            if (renderGlobal == null) {
                String string = texture;
                return string;
            }
            mp entity = RandomMobs.renderGlobal.renderedEntity;
            if (entity == null) {
                String string = texture;
                return string;
            }
            if (!(entity instanceof ng)) {
                String string = texture;
                return string;
            }
            ng entityLiving = (ng)entity;
            if (!texture.startsWith("/mob/")) {
                String string = texture;
                return string;
            }
            String string = RandomMobs.getTexture(texture, entityLiving.persistentId);
            return string;
        }
        finally {
            working = false;
        }
    }

    private static String getTexture(String texture, int randomId) {
        if (randomId <= 0) {
            return texture;
        }
        String[] texs = (String[])textureVariantsMap.get(texture);
        if (texs == null) {
            texs = RandomMobs.getTextureVariants(texture);
            textureVariantsMap.put(texture, texs);
        }
        if (texs == null || texs.length <= 0) {
            return texture;
        }
        int index = randomId % texs.length;
        String tex = texs[index];
        return tex;
    }

    private static String[] getTextureVariants(String texture) {
        String suffix;
        bgf renderEngine = Config.getRenderEngine();
        renderEngine.f(texture);
        String[] texs = new String[]{};
        int pointPos = texture.lastIndexOf(46);
        if (pointPos < 0) {
            return texs;
        }
        String prefix = texture.substring(0, pointPos);
        int countVariants = RandomMobs.getCountTextureVariants(texture, prefix, suffix = texture.substring(pointPos));
        if (countVariants <= 1) {
            return texs;
        }
        texs = new String[countVariants];
        texs[0] = texture;
        for (int i2 = 1; i2 < texs.length; ++i2) {
            String texName;
            int texNum = i2 + 1;
            texs[i2] = texName = prefix + texNum + suffix;
            renderEngine.f(texName);
        }
        Config.dbg("RandomMobs: " + texture + ", variants: " + texs.length);
        return texs;
    }

    private static int getCountTextureVariants(String texture, String prefix, String suffix) {
        bgf renderEngine = Config.getRenderEngine();
        int maxNum = 1000;
        for (int num = 2; num < maxNum; ++num) {
            String variant = prefix + num + suffix;
            try {
                InputStream in = renderEngine.g.e().a(variant);
                if (in != null) {
                    in.close();
                    continue;
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            return num - 1;
        }
        return maxNum;
    }

    public static void resetTextures() {
        textureVariantsMap.clear();
        if (Config.isRandomMobs()) {
            RandomMobs.initialize();
        }
    }

    private static void initialize() {
        renderGlobal = Config.getRenderGlobal();
        if (renderGlobal == null) {
            return;
        }
        initialized = true;
        ArrayList<String> list = new ArrayList<String>();
        list.add("bat");
        list.add("cat_black");
        list.add("cat_red");
        list.add("cat_siamese");
        list.add("cavespider");
        list.add("chicken");
        list.add("cow");
        list.add("creeper");
        list.add("enderman");
        list.add("enderman_eyes");
        list.add("fire");
        list.add("ghast");
        list.add("ghast_fire");
        list.add("lava");
        list.add("ozelot");
        list.add("pig");
        list.add("pigman");
        list.add("pigzombie");
        list.add("redcow");
        list.add("saddle");
        list.add("sheep");
        list.add("sheep_fur");
        list.add("silverfish");
        list.add("skeleton");
        list.add("skeleton_wither");
        list.add("slime");
        list.add("snowman");
        list.add("spider");
        list.add("spider_eyes");
        list.add("squid");
        list.add("villager");
        list.add("villager_golem");
        list.add("wither");
        list.add("wither_invul");
        list.add("wolf");
        list.add("wolf_angry");
        list.add("wolf_collar");
        list.add("wolf_tame");
        list.add("zombie");
        list.add("zombie_villager");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String name = (String)list.get(i2);
            String tex = "/mob/" + name + ".png";
            RandomMobs.getTexture(tex, 100);
        }
    }
}

