/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.lepko.easycrafting.block.BlockEasyCraftingTable;
import net.lepko.easycrafting.block.TileEntityEasyCrafting;
import net.lepko.easycrafting.config.ConfigHandler;
import net.lepko.easycrafting.handlers.EventHandler;
import net.lepko.easycrafting.handlers.GuiHandler;
import net.lepko.easycrafting.handlers.ModCompatibilityHandler;
import net.lepko.easycrafting.helpers.EasyLog;
import net.lepko.easycrafting.helpers.RecipeHelper;
import net.lepko.easycrafting.helpers.VersionHelper;
import net.lepko.easycrafting.network.PacketHandler;
import net.lepko.easycrafting.proxy.Proxy;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="EasyCrafting", name="Easy Crafting", version="1.1.4")
@NetworkMod(clientSideRequired=true, serverSideRequired=true, channels={"EasyCrafting"}, packetHandler=PacketHandler.class)
public class ModEasyCrafting {
    @Mod.Instance(value="EasyCrafting")
    public static ModEasyCrafting instance = new ModEasyCrafting();
    public static Block blockEasyCraftingTable;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        EasyLog.log("Loading Easy Crafting version 1.1.4.");
        ConfigHandler.initialize(event.getSuggestedConfigurationFile());
        VersionHelper.performCheck();
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        blockEasyCraftingTable = new BlockEasyCraftingTable(ConfigHandler.EASYCRAFTINGTABLE_ID);
        LanguageRegistry.addName((Object)blockEasyCraftingTable, (String)"Easy Crafting Table");
        GameRegistry.registerBlock((Block)blockEasyCraftingTable, (String)"blockEasyCraftingTable");
        GameRegistry.registerTileEntity(TileEntityEasyCrafting.class, (String)"tileEntityEasyCrafting");
        String recipeItems = ConfigHandler.CUSTOM_RECIPE_INGREDIENTS;
        String[] items = recipeItems.split(",");
        Object[] array = new Object[items.length];
        for (int i = 0; i < items.length; ++i) {
            try {
                array[i] = new ItemStack(Integer.parseInt(items[i]), 1, Short.MAX_VALUE);
                continue;
            }
            catch (NumberFormatException nfe) {
                EasyLog.warning("customRecipeItems: '" + recipeItems + "' is not valid; Using default!");
                array = new Object[]{Block.field_72060_ay, Item.field_77760_aL, Item.field_77767_aC};
                break;
            }
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockEasyCraftingTable, 1), (Object[])array);
        Proxy.proxy.onLoad();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        ModCompatibilityHandler.load();
        RecipeHelper.checkForNewRecipes();
    }
}

