/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.easyobjects;

import ic2.api.ElectricItem;
import ic2.api.IElectricItem;
import java.util.ArrayList;
import net.lepko.easycrafting.modcompat.ModCompat;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class EasyItemStack {
    private int id;
    private int damage;
    private int size;
    private int charge;
    private NBTTagCompound stackTagCompound;
    public ArrayList usedIngredients;

    public EasyItemStack(int id, int damage, int size, int charge) {
        this.id = id;
        this.damage = damage;
        this.size = size;
        this.charge = charge;
    }

    public EasyItemStack(int id, int damage, int size) {
        this(id, damage, size, 0);
    }

    public EasyItemStack(int id, int damage) {
        this(id, damage, 1, 0);
    }

    public EasyItemStack(int id) {
        this(id, 0, 1, 0);
    }

    public int getID() {
        return this.id;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getSize() {
        return this.size;
    }

    public int getCharge() {
        return this.charge;
    }

    public ItemStack toItemStack() {
        ItemStack is = new ItemStack(this.id, this.size, this.damage);
        is.func_77982_d(this.stackTagCompound);
        if (ModCompat.isLoaded("IC2") && is.func_77973_b() instanceof IElectricItem && this.charge > 0) {
            ElectricItem.discharge(is, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
            ElectricItem.charge(is, this.charge, Integer.MAX_VALUE, true, false);
        }
        return is;
    }

    public static EasyItemStack fromItemStack(ItemStack is) {
        int charge = 0;
        if (ModCompat.isLoaded("IC2") && is.func_77973_b() instanceof IElectricItem) {
            charge = ElectricItem.discharge(is, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
        }
        EasyItemStack eis = new EasyItemStack(is.field_77993_c, is.func_77960_j(), is.field_77994_a, charge);
        eis.stackTagCompound = is.func_77978_p();
        return eis;
    }

    public static boolean areStackTagsEqual(EasyItemStack is0, ItemStack is1) {
        if (is0 == null && is1 == null) {
            return true;
        }
        if (is0 != null && is1 != null) {
            if (is0.stackTagCompound == null && is1.field_77990_d != null) {
                return false;
            }
            return is0.stackTagCompound == null || is0.stackTagCompound.equals((Object)is1.field_77990_d);
        }
        return false;
    }

    public String toString() {
        return "EasyItemStack [id=" + this.id + ", damage=" + this.damage + ", size=" + this.size + "]";
    }

    public boolean equals(Object obj) {
        return this.equals(obj, false);
    }

    public boolean equals(Object obj, boolean ignoreSize) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EasyItemStack other = (EasyItemStack)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.damage != other.damage && this.damage != Short.MAX_VALUE && other.damage != Short.MAX_VALUE && !(Item.field_77698_e[this.id] instanceof IElectricItem)) {
            return false;
        }
        return ignoreSize || this.size == other.size;
    }

    public boolean equalsItemStack(ItemStack is) {
        return this.equalsItemStack(is, false);
    }

    public boolean equalsItemStack(ItemStack is, boolean ignoreSize) {
        if (is == null) {
            return false;
        }
        if (this.id != is.field_77993_c) {
            return false;
        }
        if (this.damage != is.func_77960_j() && this.damage != Short.MAX_VALUE && is.func_77960_j() != Short.MAX_VALUE && is.func_77981_g() && !(Item.field_77698_e[this.id] instanceof IElectricItem)) {
            return false;
        }
        return ignoreSize || this.size == is.field_77994_a;
    }

    public void setCharge(ArrayList usedIngredients) {
        int outputCharge = 0;
        if (usedIngredients != null) {
            for (int i = 0; i < usedIngredients.size(); ++i) {
                ItemStack ingredient = (ItemStack)usedIngredients.get(i);
                if (!ModCompat.isLoaded("IC2") || !(ingredient.func_77973_b() instanceof IElectricItem)) continue;
                outputCharge += ElectricItem.discharge(ingredient, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
            }
        }
        this.charge = outputCharge;
        this.usedIngredients = usedIngredients;
    }
}

