/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.helpers;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.lepko.easycrafting.easyobjects.EasyItemStack;
import net.lepko.easycrafting.easyobjects.EasyRecipe;
import net.lepko.easycrafting.handlers.ModCompatibilityHandler;
import net.lepko.easycrafting.helpers.EasyLog;
import net.lepko.easycrafting.helpers.InventoryHelper;
import net.lepko.easycrafting.inventory.gui.GuiEasyCrafting;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeHelper {
    private static int lastRecipeListSize = 0;
    public static List scannedRecipes = new ArrayList();

    public static void checkForNewRecipes() {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        if (lastRecipeListSize < recipes.size()) {
            ArrayList newRecipes = new ArrayList();
            for (int i = lastRecipeListSize; i < recipes.size(); ++i) {
                newRecipes.add(recipes.get(i));
            }
            lastRecipeListSize = recipes.size();
            RecipeHelper.scanRecipes(newRecipes);
        }
    }

    public static void scanRecipes(List recipes) {
        long beforeTime = System.nanoTime();
        int size = recipes.size();
        ModCompatibilityHandler.scanRecipes(recipes);
        ArrayList<EasyRecipe> tmp = new ArrayList<EasyRecipe>();
        for (IRecipe r : recipes) {
            ArrayList ingredients = RecipeHelper.getIngredientList(r);
            if (ingredients != null && r.func_77571_b() != null) {
                tmp.add(new EasyRecipe(EasyItemStack.fromItemStack(r.func_77571_b()), ingredients));
                continue;
            }
            EasyLog.log("Unknown Recipe: " + r.getClass().getName());
        }
        scannedRecipes.addAll(tmp);
        Collections.sort(scannedRecipes, new RecipeComparator());
        EasyLog.log(String.format("Scanned %d new recipes in %.8f seconds", size, (double)(System.nanoTime() - beforeTime) / 1.0E9));
    }

    public static ImmutableList getAllRecipes() {
        return ImmutableList.copyOf((Collection)scannedRecipes);
    }

    public static ArrayList getCraftableRecipes(InventoryPlayer inventory, int maxRecursion, List recipesToCheck) {
        ArrayList<EasyRecipe> tmpCraftable = new ArrayList<EasyRecipe>();
        ArrayList tmpAll = new ArrayList(recipesToCheck);
        for (EasyRecipe er : tmpAll) {
            if (!RecipeHelper.canCraft(er, inventory)) continue;
            tmpCraftable.add(er);
        }
        tmpAll.removeAll(tmpCraftable);
        if (!tmpCraftable.isEmpty()) {
            for (int recursion = 0; recursion < maxRecursion && !tmpAll.isEmpty(); ++recursion) {
                ImmutableList immutableCraftable = ImmutableList.copyOf(tmpCraftable);
                for (EasyRecipe er : tmpAll) {
                    if (!RecipeHelper.canCraft(er, inventory, immutableCraftable, maxRecursion)) continue;
                    tmpCraftable.add(er);
                }
                tmpAll.removeAll(tmpCraftable);
                if (immutableCraftable.size() == tmpCraftable.size()) break;
            }
        }
        return tmpCraftable;
    }

    public static boolean canCraft(EasyRecipe recipe, InventoryPlayer inventory) {
        return RecipeHelper.canCraft(recipe, inventory, null, false, 1, 0) > 0;
    }

    public static boolean canCraft(EasyRecipe recipe, InventoryPlayer inventory, ImmutableList recipesToCheck, int recursion) {
        return RecipeHelper.canCraft(recipe, inventory, recipesToCheck, false, 1, recursion) > 0;
    }

    public static int canCraft(EasyRecipe recipe, InventoryPlayer inventory, ImmutableList recipesToCheck, boolean take, int maxTimes, int recursion) {
        int timesCrafted;
        if (recursion < 0) {
            return 0;
        }
        recipe.getResult().setCharge(null);
        InventoryPlayer tmp = new InventoryPlayer(inventory.field_70458_d);
        InventoryPlayer tmp2 = new InventoryPlayer(inventory.field_70458_d);
        tmp.func_70455_b(inventory);
        ArrayList<ItemStack> usedIngredients = new ArrayList<ItemStack>();
        block0: for (timesCrafted = 0; timesCrafted < maxTimes; ++timesCrafted) {
            block1: for (int ii = 0; ii < recipe.getIngredientsSize(); ++ii) {
                ItemStack usedItemStack;
                ItemStack is;
                ArrayList list;
                int inventoryIndex;
                if (recipe.getIngredient(ii) instanceof EasyItemStack) {
                    EasyItemStack ingredient = (EasyItemStack)recipe.getIngredient(ii);
                    inventoryIndex = InventoryHelper.isItemInInventory((IInventory)tmp, ingredient);
                    if (inventoryIndex != -1 && InventoryHelper.consumeItemForCrafting((IInventory)tmp, inventoryIndex, usedIngredients)) continue;
                    if (recipesToCheck == null || recursion - 1 < 0) break block0;
                    list = RecipeHelper.getRecipesForItemFromList(ingredient, recipesToCheck);
                    for (EasyRecipe er : list) {
                        if (RecipeHelper.canCraft(er, tmp, recipesToCheck, true, 1, recursion - 1) <= 0) continue;
                        is = er.getResult().toItemStack();
                        --is.field_77994_a;
                        if (is.field_77994_a > 0 && !tmp.func_70441_a(is)) break block0;
                        usedItemStack = is.func_77946_l();
                        usedItemStack.field_77994_a = 1;
                        usedIngredients.add(usedItemStack);
                        continue block1;
                    }
                } else {
                    ArrayList ingredients;
                    if (!(recipe.getIngredient(ii) instanceof ArrayList) || (inventoryIndex = InventoryHelper.isItemInInventory((IInventory)tmp, ingredients = (ArrayList)recipe.getIngredient(ii))) != -1 && InventoryHelper.consumeItemForCrafting((IInventory)tmp, inventoryIndex, usedIngredients)) continue;
                    if (recipesToCheck == null || recursion - 1 < 0) break block0;
                    list = RecipeHelper.getRecipesForItemFromList(ingredients, recipesToCheck);
                    for (EasyRecipe er : list) {
                        if (RecipeHelper.canCraft(er, tmp, recipesToCheck, true, 1, recursion - 1) <= 0) continue;
                        is = er.getResult().toItemStack();
                        --is.field_77994_a;
                        if (is.field_77994_a > 0 && !tmp.func_70441_a(is)) break block0;
                        usedItemStack = is.func_77946_l();
                        usedItemStack.field_77994_a = 1;
                        usedIngredients.add(usedItemStack);
                        continue block1;
                    }
                }
                break block0;
            }
            tmp2.func_70455_b(tmp);
        }
        if (timesCrafted > 0) {
            recipe.getResult().setCharge(usedIngredients);
            if (take) {
                inventory.func_70455_b(tmp2);
            }
        }
        return timesCrafted;
    }

    private static ArrayList getRecipesForItemFromList(EasyItemStack ingredient, ImmutableList recipesToCheck) {
        ArrayList<EasyRecipe> returnList = new ArrayList<EasyRecipe>();
        for (EasyRecipe er : recipesToCheck) {
            if (!er.getResult().equals(ingredient, true)) continue;
            returnList.add(er);
        }
        return returnList;
    }

    private static ArrayList getRecipesForItemFromList(ArrayList ingredients, ImmutableList recipesToCheck) {
        ArrayList returnList = new ArrayList();
        for (ItemStack is : ingredients) {
            returnList.addAll(RecipeHelper.getRecipesForItemFromList(EasyItemStack.fromItemStack(is), recipesToCheck));
        }
        return returnList;
    }

    public static EasyRecipe getValidRecipe(EasyItemStack result, ItemStack[] ingredients) {
        ImmutableList all = RecipeHelper.getAllRecipes();
        block0: for (EasyRecipe r : all) {
            if (!r.getResult().equals(result) || r.getIngredientsSize() != ingredients.length) continue;
            for (int j = 0; j < r.getIngredientsSize(); ++j) {
                EasyItemStack eis;
                if (r.getIngredient(j) instanceof EasyItemStack ? !(eis = (EasyItemStack)r.getIngredient(j)).equalsItemStack(ingredients[j]) : r.getIngredient(j) instanceof ArrayList && ingredients[j].field_77993_c != -1) continue block0;
            }
            return r;
        }
        return null;
    }

    public static int calculateCraftingMultiplierUntilMaxStack(ItemStack result, ItemStack inHand) {
        int diff;
        int maxTimes = (int)((double)result.func_77976_d() / (double)result.field_77994_a);
        if (inHand != null && inHand.field_77994_a > (diff = result.func_77976_d() - maxTimes * result.field_77994_a)) {
            maxTimes -= (int)((double)(inHand.field_77994_a - diff) / (double)result.field_77994_a + 1.0);
        }
        return maxTimes;
    }

    @SideOnly(value=Side.CLIENT)
    public static EasyRecipe getValidRecipe(GuiEasyCrafting gui, int slot_index, ItemStack result) {
        EasyRecipe r;
        int recipe_index = slot_index + gui.currentScroll * 8;
        if (recipe_index >= 0 && gui.renderList != null && recipe_index < gui.renderList.size() && (r = (EasyRecipe)gui.renderList.get(recipe_index)).getResult().equalsItemStack(result) && gui.craftableList != null && gui.craftableList.contains((Object)r)) {
            return r;
        }
        return null;
    }

    public static ArrayList resolveOreAndLiquidDictionaries(String string) {
        if (string.startsWith("liquid$")) {
            int id;
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            int separator = string.indexOf(58);
            int meta = -1;
            try {
                if (separator > -1) {
                    id = Integer.parseInt(string.substring(7, separator - 1));
                    meta = Integer.parseInt(string.substring(separator + 1));
                } else {
                    id = Integer.parseInt(string.substring(7));
                }
            }
            catch (NumberFormatException e) {
                EasyLog.warning("Execption while resolving liquid dictionary!", e);
                return result;
            }
            for (LiquidContainerData data : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
                if (data.stillLiquid.itemID != id || meta != -1 && data.stillLiquid.itemMeta != meta) continue;
                result.add(data.filled);
            }
            return result;
        }
        return OreDictionary.getOres((String)string);
    }

    public static ArrayList getIngredientList(IRecipe recipe) {
        ArrayList<Object> ingredients = null;
        if (recipe instanceof ShapedRecipes) {
            ingredients = new ArrayList<ItemStack>(Arrays.asList(((ShapedRecipes)recipe).field_77574_d));
        } else if (recipe instanceof ShapelessRecipes) {
            ingredients = new ArrayList(((ShapelessRecipes)recipe).field_77579_b);
        } else if (recipe instanceof ShapedOreRecipe) {
            Object[] input = (Object[])ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (int)3);
            ingredients = new ArrayList<Object>(Arrays.asList(input));
        } else if (recipe instanceof ShapelessOreRecipe) {
            List input = (List)ReflectionHelper.getPrivateValue(ShapelessOreRecipe.class, (Object)((ShapelessOreRecipe)recipe), (int)1);
            ingredients = new ArrayList(input);
        }
        if (ingredients != null) {
            ingredients.removeAll(Collections.singleton(null));
        }
        return ingredients;
    }

    public static class RecipeComparator
    implements Comparator {
        public int compare(EasyRecipe o1, EasyRecipe o2) {
            if (o1.getResult().getID() > o2.getResult().getID()) {
                return 1;
            }
            if (o1.getResult().getID() < o2.getResult().getID()) {
                return -1;
            }
            if (o1.getResult().getDamage() > o2.getResult().getDamage()) {
                return 1;
            }
            if (o1.getResult().getDamage() < o2.getResult().getDamage()) {
                return -1;
            }
            if (o1.getResult().getSize() > o2.getResult().getSize()) {
                return 1;
            }
            if (o1.getResult().getSize() < o2.getResult().getSize()) {
                return -1;
            }
            return 0;
        }
    }
}

