/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.inventory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.lepko.easycrafting.block.SlotEasyCraftingOutput;
import net.lepko.easycrafting.block.SlotInterceptor;
import net.lepko.easycrafting.block.TileEntityEasyCrafting;
import net.lepko.easycrafting.config.ConfigHandler;
import net.lepko.easycrafting.easyobjects.EasyRecipe;
import net.lepko.easycrafting.helpers.RecipeHelper;
import net.lepko.easycrafting.inventory.gui.GuiEasyCrafting;
import net.lepko.easycrafting.network.PacketHandler;
import net.lepko.easycrafting.network.packet.PacketEasyCrafting;
import net.lepko.easycrafting.proxy.Proxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerEasyCrafting
extends Container {
    protected TileEntityEasyCrafting tile_entity;
    public GuiEasyCrafting gui;

    public ContainerEasyCrafting(TileEntityEasyCrafting tile_entity, InventoryPlayer player_inventory) {
        this.tile_entity = tile_entity;
        int offset2 = 94;
        int offset = offset2 + 36 + 4;
        int offset3 = offset + 54 + 5;
        int count = 0;
        for (int g = 0; g < 5; ++g) {
            for (int h = 0; h < 8; ++h) {
                this.func_75146_a(new SlotEasyCraftingOutput(tile_entity, count++, 8 + h * 18, 18 + g * 18));
            }
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)tile_entity, count++, 8 + j * 18, 18 + i * 18 + offset2));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.func_75146_a(new SlotInterceptor((IInventory)player_inventory, l + k * 9 + 9, 8 + l * 18, 18 + k * 18 + offset));
            }
        }
        for (int m = 0; m < 9; ++m) {
            this.func_75146_a(new SlotInterceptor((IInventory)player_inventory, m, 8 + m * 18, 18 + offset3));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tile_entity.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot_index) {
        ItemStack stack = null;
        Slot slot_object = (Slot)this.field_75151_b.get(slot_index);
        if (slot_object != null && slot_object.func_75216_d()) {
            ItemStack stack_in_slot = slot_object.func_75211_c();
            stack = stack_in_slot.func_77946_l();
            if (slot_index < 40) {
                return null;
            }
            if (slot_index >= 40 && slot_index <= 57 ? !this.func_75135_a(stack_in_slot, 58, this.field_75151_b.size(), true) : !this.func_75135_a(stack_in_slot, 40, 58, false)) {
                return null;
            }
            if (stack_in_slot.field_77994_a == 0) {
                slot_object.func_75215_d(null);
            } else {
                slot_object.func_75218_e();
            }
        }
        return stack;
    }

    public ItemStack func_75144_a(int slot_index, int mouse_button, int modifier, EntityPlayer player) {
        if (slot_index >= 0 && this.field_75151_b.get(slot_index) instanceof SlotEasyCraftingOutput) {
            return this.slotClickEasyCraftingOutput(slot_index, mouse_button, modifier, player);
        }
        return super.func_75144_a(slot_index, mouse_button, modifier, player);
    }

    private ItemStack slotClickEasyCraftingOutput(int slot_index, int mouse_button, int modifier, EntityPlayer player) {
        EasyRecipe recipe;
        if (!Proxy.proxy.isClient()) {
            return null;
        }
        if (this.gui == null) {
            return null;
        }
        if (mouse_button != 0 && mouse_button != 1 || modifier != 0 && modifier != 1) {
            return null;
        }
        Slot clicked_slot = (Slot)this.field_75151_b.get(slot_index);
        if (clicked_slot == null) {
            return null;
        }
        ItemStack stack_in_slot = clicked_slot.func_75211_c();
        if (stack_in_slot == null) {
            return null;
        }
        ItemStack stack_in_hand = player.field_71071_by.func_70445_o();
        ItemStack return_stack = null;
        int return_size = 0;
        if (stack_in_hand == null) {
            return_stack = stack_in_slot.func_77946_l();
            return_size = stack_in_slot.field_77994_a;
        } else if (stack_in_slot.field_77993_c == stack_in_hand.field_77993_c && stack_in_hand.func_77976_d() >= stack_in_slot.field_77994_a + stack_in_hand.field_77994_a && (!stack_in_slot.func_77981_g() || stack_in_slot.func_77960_j() == stack_in_hand.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack_in_slot, (ItemStack)stack_in_hand)) {
            return_stack = stack_in_slot.func_77946_l();
            return_size = stack_in_slot.field_77994_a + stack_in_hand.field_77994_a;
        }
        if (return_stack != null && (recipe = RecipeHelper.getValidRecipe(this.gui, slot_index, return_stack)) != null) {
            boolean isRightClick = mouse_button != 0;
            PacketEasyCrafting packet = new PacketEasyCrafting(recipe, isRightClick);
            PacketHandler.sendPacket(packet);
            if (isRightClick) {
                int maxTimes = RecipeHelper.calculateCraftingMultiplierUntilMaxStack(stack_in_slot, stack_in_hand);
                int timesCrafted = RecipeHelper.canCraft(recipe, player.field_71071_by, RecipeHelper.getAllRecipes(), false, maxTimes, ConfigHandler.MAX_RECURSION);
                if (timesCrafted > 0) {
                    return_stack.field_77994_a = return_size + (timesCrafted - 1) * stack_in_slot.field_77994_a;
                    player.field_71071_by.func_70437_b(return_stack);
                    return return_stack;
                }
            } else {
                return_stack.field_77994_a = return_size;
                player.field_71071_by.func_70437_b(return_stack);
                return return_stack;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void scrollTo(int currentScroll, List renderList) {
        if (renderList != null) {
            int offset = currentScroll * 8;
            for (int i = 0; i < 40; ++i) {
                if (i + offset >= renderList.size() || i + offset < 0) {
                    this.tile_entity.func_70299_a(i, null);
                    continue;
                }
                ItemStack is = ((EasyRecipe)renderList.get(i + offset)).getResult().toItemStack();
                this.tile_entity.func_70299_a(i, is);
            }
        }
    }
}

