/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.modcompat;

import cpw.mods.fml.common.Loader;
import java.util.List;
import net.lepko.easycrafting.handlers.ModCompatibilityHandler;
import net.lepko.easycrafting.helpers.EasyLog;

public abstract class ModCompat {
    public boolean isModLoaded = false;
    public String modID;

    public ModCompat(String modID) {
        this.modID = modID;
        ModCompatibilityHandler.modules.put(modID, this);
    }

    public void load() {
        this.log("Checking for mod...");
        if (!Loader.isModLoaded((String)this.modID)) {
            this.log("Mod not found.");
            return;
        }
        this.log("Mod found.");
        this.isModLoaded = true;
    }

    public abstract void scanRecipes(List var1);

    protected void log(String msg) {
        EasyLog.log("[ModCompat] [" + this.modID + "] " + msg);
    }

    public static final boolean isLoaded(String modID) {
        if (ModCompatibilityHandler.modules.get(modID) != null) {
            return ((ModCompat)ModCompatibilityHandler.modules.get((Object)modID)).isModLoaded;
        }
        return false;
    }
}

