/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.modcompat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.lepko.easycrafting.helpers.EasyLog;
import net.lepko.easycrafting.helpers.RecipeHelper;
import net.lepko.easycrafting.modcompat.ModCompat;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class ModCompatEE3
extends ModCompat {
    private static Class transmutationStoneInterface;

    public ModCompatEE3() {
        super("EE3");
    }

    @Override
    public void scanRecipes(List recipes) {
        try {
            Iterator iterator = recipes.iterator();
            while (iterator.hasNext()) {
                IRecipe r = (IRecipe)iterator.next();
                ArrayList ingredients = RecipeHelper.getIngredientList(r);
                if (ingredients == null) continue;
                for (Object o : ingredients) {
                    if (!(o instanceof ItemStack) || !ModCompatEE3.isTransmutationStone((ItemStack)o)) continue;
                    iterator.remove();
                }
            }
        }
        catch (Exception e) {
            EasyLog.warning("[ModCompat] [" + this.modID + "] Exception while scanning recipes.", e);
            return;
        }
    }

    public static boolean isTransmutationStone(ItemStack itemstack) {
        if (transmutationStoneInterface == null) {
            try {
                transmutationStoneInterface = Class.forName("com.pahimar.ee3.item.ITransmutationStone");
            }
            catch (Exception e) {
                EasyLog.warning("Exception when trying to get transmutation stone interface.", e);
                return false;
            }
        }
        return itemstack.func_77973_b().getClass().getName().startsWith("com.pahimar") && transmutationStoneInterface.isInstance(itemstack.func_77973_b());
    }
}

