/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.network.packet;

import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.lepko.easycrafting.helpers.EasyLog;

public abstract class EasyPacket {
    public int packetID;

    public EasyPacket(int packetID) {
        this.packetID = packetID;
    }

    public void read(DataInputStream data) {
        try {
            this.readData(data);
        }
        catch (IOException e) {
            EasyLog.warning("Exception while reading packet: " + this.packetID + "!", e);
        }
    }

    public byte[] getBytes() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeByte(this.packetID);
            this.writeData(dos);
        }
        catch (IOException e) {
            EasyLog.warning("Exception while writing to packet: " + this.packetID + "!", e);
        }
        return bos.toByteArray();
    }

    public abstract void run(Player var1);

    protected abstract void readData(DataInputStream var1) throws IOException;

    protected abstract void writeData(DataOutputStream var1) throws IOException;
}

