/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.network.packet;

import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.lepko.easycrafting.config.ConfigHandler;
import net.lepko.easycrafting.easyobjects.EasyItemStack;
import net.lepko.easycrafting.easyobjects.EasyRecipe;
import net.lepko.easycrafting.helpers.RecipeHelper;
import net.lepko.easycrafting.network.packet.EasyPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PacketEasyCrafting
extends EasyPacket {
    private EasyItemStack result;
    ItemStack[] ingredients;
    private boolean isRightClick = false;

    public PacketEasyCrafting() {
        super(1);
    }

    public PacketEasyCrafting(EasyRecipe recipe, boolean isRightClick) {
        this();
        this.setRecipe(recipe);
        this.isRightClick = isRightClick;
    }

    public void setRecipe(EasyRecipe recipe) {
        this.result = recipe.getResult();
        this.ingredients = new ItemStack[recipe.getIngredientsSize()];
        for (int i = 0; i < recipe.getIngredientsSize(); ++i) {
            if (recipe.getIngredient(i) instanceof EasyItemStack) {
                EasyItemStack eis = (EasyItemStack)recipe.getIngredient(i);
                this.ingredients[i] = new ItemStack(eis.getID(), eis.getSize(), eis.getDamage());
                continue;
            }
            if (!(recipe.getIngredient(i) instanceof List)) continue;
            this.ingredients[i] = new ItemStack(-1, -1, -1);
        }
    }

    @Override
    public void run(Player player) {
        EasyRecipe recipe = RecipeHelper.getValidRecipe(this.result, this.ingredients);
        if (recipe == null) {
            return;
        }
        EntityPlayer sender = (EntityPlayer)player;
        ItemStack stack_in_hand = sender.field_71071_by.func_70445_o();
        ItemStack return_stack = null;
        int return_size = 0;
        if (stack_in_hand == null) {
            return_stack = recipe.getResult().toItemStack();
            return_size = recipe.getResult().getSize();
        } else if (recipe.getResult().equalsItemStack(stack_in_hand, true) && stack_in_hand.func_77976_d() >= recipe.getResult().getSize() + stack_in_hand.field_77994_a && EasyItemStack.areStackTagsEqual(recipe.getResult(), stack_in_hand)) {
            return_stack = recipe.getResult().toItemStack();
            return_size = recipe.getResult().getSize() + stack_in_hand.field_77994_a;
        }
        if (return_stack != null) {
            if (!this.isRightClick) {
                if (RecipeHelper.canCraft(recipe, sender.field_71071_by, RecipeHelper.getAllRecipes(), true, 1, ConfigHandler.MAX_RECURSION) > 0) {
                    return_stack.field_77994_a = return_size;
                    sender.field_71071_by.func_70437_b(return_stack);
                }
            } else {
                int maxTimes = RecipeHelper.calculateCraftingMultiplierUntilMaxStack(return_stack, stack_in_hand);
                int timesCrafted = RecipeHelper.canCraft(recipe, sender.field_71071_by, RecipeHelper.getAllRecipes(), true, maxTimes, ConfigHandler.MAX_RECURSION);
                if (timesCrafted > 0) {
                    return_stack.field_77994_a = return_size + (timesCrafted - 1) * recipe.getResult().getSize();
                    sender.field_71071_by.func_70437_b(return_stack);
                }
            }
        }
    }

    @Override
    protected void readData(DataInputStream data) throws IOException {
        this.isRightClick = data.readBoolean();
        short id = data.readShort();
        int damage = data.readInt();
        byte size = data.readByte();
        this.result = new EasyItemStack(id, damage, size);
        int length = data.readByte();
        this.ingredients = new ItemStack[length];
        for (int i = 0; i < length; ++i) {
            short _id = data.readShort();
            int _damage = data.readInt();
            byte _size = data.readByte();
            this.ingredients[i] = new ItemStack((int)_id, (int)_size, _damage);
        }
    }

    @Override
    protected void writeData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.isRightClick);
        data.writeShort(this.result.getID());
        data.writeInt(this.result.getDamage());
        data.writeByte(this.result.getSize());
        data.writeByte(this.ingredients.length);
        for (ItemStack is : this.ingredients) {
            data.writeShort(is.field_77993_c);
            data.writeInt(is.func_77960_j());
            data.writeByte(is.field_77994_a);
        }
    }
}

