/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;

public class WrUpdaterSmooth
implements IWrUpdater {
    private long lastUpdateStartTimeNs = 0L;
    private long updateStartTimeNs = 0L;
    private long updateTimeNs = 10000000L;
    private WorldRendererSmooth currentUpdateRenderer = null;
    private int renderersUpdated = 0;
    private int renderersFound = 0;

    public void initialize() {
    }

    public void terminate() {
    }

    public bfm makeWorldRenderer(aab worldObj, List tileEntities, int x2, int y2, int z2, int glRenderListBase) {
        return new WorldRendererSmooth(worldObj, tileEntities, x2, y2, z2, glRenderListBase);
    }

    public boolean updateRenderers(bfy rg2, ng entityliving, boolean flag) {
        this.lastUpdateStartTimeNs = this.updateStartTimeNs;
        this.updateStartTimeNs = System.nanoTime();
        long finishTimeNs = this.updateStartTimeNs + this.updateTimeNs;
        int maxNum = Config.getUpdatesPerFrame();
        if (Config.isDynamicUpdates() && !rg2.isMoving(entityliving)) {
            maxNum *= 3;
        }
        this.renderersUpdated = 0;
        do {
            this.renderersFound = 0;
            this.updateRenderersImpl(rg2, entityliving, flag);
        } while (this.renderersFound > 0 && System.nanoTime() - finishTimeNs < 0L);
        if (this.renderersFound > 0) {
            maxNum = Math.min(maxNum, this.renderersFound);
            long diff = 400000L;
            if (this.renderersUpdated > maxNum) {
                this.updateTimeNs -= 2L * diff;
            }
            if (this.renderersUpdated < maxNum) {
                this.updateTimeNs += diff;
            }
        } else {
            this.updateTimeNs = 0L;
            this.updateTimeNs -= 200000L;
        }
        if (this.updateTimeNs < 0L) {
            this.updateTimeNs = 0L;
        }
        return this.renderersUpdated > 0;
    }

    private void updateRenderersImpl(bfy rg2, ng entityliving, boolean flag) {
        this.renderersFound = 0;
        boolean currentUpdateFinished = true;
        if (this.currentUpdateRenderer != null) {
            ++this.renderersFound;
            currentUpdateFinished = this.updateRenderer(this.currentUpdateRenderer);
            if (currentUpdateFinished) {
                ++this.renderersUpdated;
            }
        }
        if (rg2.j.size() <= 0) {
            return;
        }
        int NOT_IN_FRUSTRUM_MUL = 4;
        WorldRendererSmooth wrBest = null;
        float distSqBest = Float.MAX_VALUE;
        int indexBest = -1;
        for (int i2 = 0; i2 < rg2.j.size(); ++i2) {
            WorldRendererSmooth wr2 = (WorldRendererSmooth)rg2.j.get(i2);
            if (wr2 == null) continue;
            ++this.renderersFound;
            if (!wr2.q) {
                rg2.j.set(i2, null);
                continue;
            }
            float distSq = wr2.a(entityliving);
            if (distSq <= 256.0f && rg2.isActingNow()) {
                wr2.a();
                wr2.q = false;
                rg2.j.set(i2, null);
                ++this.renderersUpdated;
                continue;
            }
            if (!wr2.l) {
                distSq *= (float)NOT_IN_FRUSTRUM_MUL;
            }
            if (wrBest == null) {
                wrBest = wr2;
                distSqBest = distSq;
                indexBest = i2;
                continue;
            }
            if (!(distSq < distSqBest)) continue;
            wrBest = wr2;
            distSqBest = distSq;
            indexBest = i2;
        }
        if (this.currentUpdateRenderer != null && !currentUpdateFinished) {
            return;
        }
        if (wrBest != null) {
            rg2.j.set(indexBest, null);
            if (!this.updateRenderer(wrBest)) {
                return;
            }
            ++this.renderersUpdated;
            if (System.nanoTime() > this.updateStartTimeNs + this.updateTimeNs) {
                return;
            }
            float maxDiffDistSq = distSqBest / 5.0f;
            for (int i3 = 0; i3 < rg2.j.size(); ++i3) {
                float diffDistSq;
                WorldRendererSmooth wr3 = (WorldRendererSmooth)rg2.j.get(i3);
                if (wr3 == null) continue;
                float distSq = wr3.a(entityliving);
                if (!wr3.l) {
                    distSq *= (float)NOT_IN_FRUSTRUM_MUL;
                }
                if (!((diffDistSq = Math.abs(distSq - distSqBest)) < maxDiffDistSq)) continue;
                rg2.j.set(i3, null);
                if (!this.updateRenderer(wr3)) {
                    return;
                }
                ++this.renderersUpdated;
                if (System.nanoTime() > this.updateStartTimeNs + this.updateTimeNs) break;
            }
        }
        if (this.renderersFound == 0) {
            rg2.j.clear();
        }
        if (rg2.j.size() > 100 && this.renderersFound < rg2.j.size() * 4 / 5) {
            int dstIndex = 0;
            for (int srcIndex = 0; srcIndex < rg2.j.size(); ++srcIndex) {
                Object wr4 = rg2.j.get(srcIndex);
                if (wr4 == null) continue;
                if (srcIndex != dstIndex) {
                    rg2.j.set(dstIndex, wr4);
                }
                ++dstIndex;
            }
            for (int i4 = rg2.j.size() - 1; i4 >= dstIndex; --i4) {
                rg2.j.remove(i4);
            }
        }
    }

    private boolean updateRenderer(WorldRendererSmooth wr2) {
        long finishTime = this.updateStartTimeNs + this.updateTimeNs;
        wr2.q = false;
        boolean ready = wr2.updateRenderer(finishTime);
        if (!ready) {
            this.currentUpdateRenderer = wr2;
            return false;
        }
        wr2.finishUpdate();
        this.currentUpdateRenderer = null;
        return true;
    }

    public void finishCurrentUpdate() {
    }

    public void resumeBackgroundUpdates() {
    }

    public void pauseBackgroundUpdates() {
    }

    public void preRender(bfy rg2, ng player) {
    }

    public void postRender() {
    }
}

