/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

final class BlockData
implements Comparable {
    static final Object ETC_EMPTY = "EMPTY";
    final int renderType;
    final int renderPass;
    final String textureName;
    final float minX;
    final float minY;
    final float minZ;
    final float maxX;
    final float maxY;
    final float maxZ;
    final int hashCode;
    final Object extend;

    BlockData(int renderType, int renderPass, String textureName, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Object ex2) {
        if (textureName == null) {
            throw new IllegalArgumentException();
        }
        if (ex2 == null) {
            ex2 = ETC_EMPTY;
        }
        this.renderType = renderType;
        this.renderPass = renderPass;
        this.textureName = textureName;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.extend = ex2;
        int hash = renderType;
        hash ^= textureName.hashCode();
        hash ^= Float.floatToRawIntBits(minX + 1.0f);
        hash ^= Float.floatToRawIntBits(minY + 2.0f);
        hash ^= Float.floatToRawIntBits(minZ + 3.0f);
        hash ^= Float.floatToRawIntBits(maxX + 4.0f);
        hash ^= Float.floatToRawIntBits(maxZ + 5.0f);
        hash ^= Float.floatToRawIntBits(maxY + 6.0f);
        this.hashCode = hash ^= ex2.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj != null && this == obj || obj instanceof BlockData && this.equals((BlockData)obj);
    }

    private boolean equals(BlockData obj) {
        return this.renderType == obj.renderType && this.minX == obj.minX && this.minY == obj.minY && this.minZ == obj.minZ && this.maxX == obj.maxX && this.maxY == obj.maxY && this.maxZ == obj.maxZ && BlockData.equals(this.textureName, obj.textureName) && this.extend.equals(obj.extend);
    }

    private static boolean equals(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    public int compareTo(BlockData o2) {
        int i2 = this.textureName.compareTo(o2.textureName);
        if (i2 != 0) {
            return i2;
        }
        return this.renderType != o2.renderType ? this.renderType - o2.renderType : (this.renderPass != o2.renderPass ? this.renderPass - o2.renderPass : this.extend.toString().compareTo(o2.extend.toString()));
    }

    public String toString() {
        return String.format("%s:%d (%1.6f,%1.6f,%1.6f)-(%1.6f,%1.6f,%1.6f) : %s", this.textureName, this.renderType, Float.valueOf(this.minX), Float.valueOf(this.minY), Float.valueOf(this.minZ), Float.valueOf(this.maxX), Float.valueOf(this.maxY), Float.valueOf(this.maxZ), this.extend);
    }
}

