/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import reifnsk.minimap.GLTextureBufferedImage;

public class GLTexture {
    private static String DEFAULT_PACK;
    private static String pack;
    private static ArrayList list;
    private static GLTexture missing;
    static final GLTexture TEMPERATURE;
    static final GLTexture HUMIDITY;
    static final GLTexture ROUND_MAP;
    static final GLTexture ROUND_MAP_MASK;
    static final GLTexture SQUARE_MAP;
    static final GLTexture SQUARE_MAP_MASK;
    static final GLTexture ENTITY;
    static final GLTexture ENTITY2;
    static final GLTexture LIGHTNING;
    static final GLTexture N;
    static final GLTexture E;
    static final GLTexture W;
    static final GLTexture S;
    static final GLTexture MMARROW;
    static final GLTexture WAYPOINT1;
    static final GLTexture WAYPOINT2;
    static final GLTexture MARKER1;
    static final GLTexture MARKER2;
    private final String fileName;
    private final boolean blur;
    private final boolean clamp;
    private int textureId;

    static void setPack(String newPack) {
        if (newPack.equals(pack)) {
            return;
        }
        for (GLTexture glt : list) {
            glt.release();
        }
        pack = newPack;
    }

    private GLTexture(String name, boolean blur, boolean clamp) {
        this.fileName = name;
        this.blur = blur;
        this.clamp = clamp;
        list.add(this);
    }

    int[] getData() {
        BufferedImage image = GLTexture.read(this.fileName);
        int w2 = image.getWidth();
        int h2 = image.getHeight();
        int[] rgbArray = new int[w2 * h2];
        image.getRGB(0, 0, w2, h2, rgbArray, 0, w2);
        return rgbArray;
    }

    void bind() {
        if (this.textureId == 0) {
            BufferedImage image = GLTexture.read(this.fileName);
            if (image == null) {
                this.textureId = this == missing ? -2 : -1;
            } else {
                this.textureId = GL11.glGenTextures();
                int w2 = image.getWidth();
                int h2 = image.getHeight();
                int[] rgbArray = new int[w2 * h2];
                image.getRGB(0, 0, w2, h2, rgbArray, 0, w2);
                GLTextureBufferedImage.createTexture(rgbArray, w2, h2, this.textureId, this.blur, this.clamp);
            }
        }
        if (this.textureId == -2) {
            GL11.glBindTexture((int)3553, (int)0);
            return;
        }
        if (this.textureId == -1) {
            missing.bind();
        }
        GL11.glBindTexture((int)3553, (int)this.textureId);
    }

    void release() {
        if (this.textureId > 0) {
            GL11.glDeleteTextures((int)this.textureId);
        }
        this.textureId = 0;
    }

    private static BufferedImage read(String name) {
        BufferedImage image = GLTexture.readImage(pack + name);
        return image == null ? GLTexture.readImage(DEFAULT_PACK + name) : image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage readImage(String stream) {
        InputStream in = GLTexture.class.getResourceAsStream(stream);
        if (in == null) {
            return null;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        catch (Exception e2) {
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e3) {}
        }
    }

    static {
        pack = DEFAULT_PACK = "/reifnsk/minimap/";
        list = new ArrayList();
        missing = new GLTexture("missing.png", true, false);
        TEMPERATURE = new GLTexture("temperature.png", true, true);
        HUMIDITY = new GLTexture("humidity.png", true, true);
        ROUND_MAP = new GLTexture("roundmap.png", true, true);
        ROUND_MAP_MASK = new GLTexture("roundmap_mask.png", false, true);
        SQUARE_MAP = new GLTexture("squaremap.png", true, true);
        SQUARE_MAP_MASK = new GLTexture("squaremap_mask.png", false, true);
        ENTITY = new GLTexture("entity.png", true, true);
        ENTITY2 = new GLTexture("entity2.png", true, true);
        LIGHTNING = new GLTexture("lightning.png", true, true);
        N = new GLTexture("n.png", true, true);
        E = new GLTexture("e.png", true, true);
        W = new GLTexture("w.png", true, true);
        S = new GLTexture("s.png", true, true);
        MMARROW = new GLTexture("mmarrow.png", true, true);
        WAYPOINT1 = new GLTexture("waypoint.png", true, true);
        WAYPOINT2 = new GLTexture("waypoint2.png", true, true);
        MARKER1 = new GLTexture("marker.png", true, true);
        MARKER2 = new GLTexture("marker2.png", true, true);
    }
}

