/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import reifnsk.minimap.GLTexture;

public class Waypoint {
    private static final int MAX_TYPE_VALUE = 1;
    public static final int NORMAL = 0;
    public static final int DEATH_POINT = 1;
    static final GLTexture[] FILE = new GLTexture[]{GLTexture.WAYPOINT1, GLTexture.WAYPOINT2};
    static final GLTexture[] MARKER = new GLTexture[]{GLTexture.MARKER1, GLTexture.MARKER2};
    public String name;
    public int x;
    public int y;
    public int z;
    public boolean enable;
    public float red;
    public float green;
    public float blue;
    public int type;

    public Waypoint(String name, int x2, int y2, int z2, boolean flag, float r2, float g2, float b2) {
        this.name = name == null ? "" : name;
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.enable = flag;
        this.red = r2;
        this.green = g2;
        this.blue = b2;
    }

    Waypoint(String name, int x2, int y2, int z2, boolean flag, float r2, float g2, float b2, int type) {
        this.name = name == null ? "" : name;
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.enable = flag;
        this.red = r2;
        this.green = g2;
        this.blue = b2;
        this.type = Math.max(0, type <= 1 ? type : 0);
    }

    Waypoint(Waypoint pt2) {
        this.set(pt2);
    }

    void set(Waypoint pt2) {
        this.name = pt2.name;
        this.x = pt2.x;
        this.y = pt2.y;
        this.z = pt2.z;
        this.enable = pt2.enable;
        this.red = pt2.red;
        this.green = pt2.green;
        this.blue = pt2.blue;
        this.type = Math.max(0, pt2.type <= 1 ? pt2.type : 0);
    }

    static Waypoint load(String line) {
        try {
            String[] elements = line.split(":");
            String name = elements[0];
            int x2 = Integer.parseInt(elements[1]);
            int y2 = Integer.parseInt(elements[2]);
            int z2 = Integer.parseInt(elements[3]);
            boolean flag = Boolean.parseBoolean(elements[4]);
            int rgb = Integer.parseInt(elements[5], 16);
            float r2 = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g2 = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b2 = (float)(rgb >> 0 & 0xFF) / 255.0f;
            int type = elements.length >= 7 ? Integer.parseInt(elements[6]) : 0;
            return new Waypoint(name, x2, y2, z2, flag, r2, g2, b2, type);
        }
        catch (RuntimeException re2) {
            re2.printStackTrace();
            return null;
        }
    }

    public String toString() {
        int r2 = (int)(this.red * 255.0f) & 0xFF;
        int g2 = (int)(this.green * 255.0f) & 0xFF;
        int b2 = (int)(this.blue * 255.0f) & 0xFF;
        int rgb = r2 << 16 | g2 << 8 | b2;
        return String.format(this.type == 0 ? "%s:%d:%d:%d:%s:%06X" : "%s:%d:%d:%d:%s:%06X:%d", this.name, this.x, this.y, this.z, this.enable, rgb, this.type);
    }
}

