/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.easyobjects;

import java.util.ArrayList;
import java.util.Collections;
import net.lepko.easycrafting.easyobjects.EasyItemStack;
import net.lepko.easycrafting.helpers.RecipeHelper;
import net.minecraft.item.ItemStack;

public class EasyRecipe {
    private ArrayList ingredients;
    private EasyItemStack result;

    public EasyRecipe(EasyItemStack result, ArrayList ingredients) {
        this.result = result;
        ingredients.removeAll(Collections.singleton(null));
        this.ingredients = ingredients;
    }

    public Object getIngredient(int index) {
        if (index < 0 || index > this.ingredients.size()) {
            return null;
        }
        Object o = this.ingredients.get(index);
        if (o instanceof EasyItemStack) {
            return o;
        }
        if (o instanceof ArrayList) {
            return o;
        }
        if (o instanceof ItemStack) {
            EasyItemStack eis = EasyItemStack.fromItemStack((ItemStack)o);
            this.ingredients.set(index, eis);
            return eis;
        }
        if (o instanceof String) {
            ArrayList list = RecipeHelper.resolveOreAndLiquidDictionaries((String)o);
            this.ingredients.set(index, list);
            return list;
        }
        return null;
    }

    public int getIngredientsSize() {
        return this.ingredients.size();
    }

    public EasyItemStack getResult() {
        return this.result;
    }

    public ArrayList getCompactIngredientList() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (this.result.usedIngredients == null) {
            block0: for (int i = 0; i < this.ingredients.size(); ++i) {
                Object o = this.getIngredient(i);
                EasyItemStack eis = null;
                if (o instanceof EasyItemStack) {
                    eis = (EasyItemStack)o;
                } else if (o instanceof ArrayList) {
                    ArrayList list2 = (ArrayList)o;
                    if (list2.isEmpty()) {
                        return null;
                    }
                    eis = EasyItemStack.fromItemStack((ItemStack)list2.get(0));
                } else {
                    return null;
                }
                for (ItemStack is2 : list) {
                    if (!eis.equalsItemStack(is2, true)) continue;
                    ++is2.field_77994_a;
                    continue block0;
                }
                ItemStack is = eis.toItemStack();
                is.field_77994_a = 1;
                list.add(is);
            }
        } else {
            block2: for (ItemStack is : this.result.usedIngredients) {
                EasyItemStack eis = EasyItemStack.fromItemStack(is);
                for (ItemStack is2 : list) {
                    if (!eis.equalsItemStack(is2, true)) continue;
                    ++is2.field_77994_a;
                    continue block2;
                }
                list.add(eis.toItemStack());
            }
        }
        return list;
    }
}

