/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.helpers;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import net.lepko.easycrafting.config.ConfigHandler;
import net.lepko.easycrafting.helpers.EasyLog;
import net.lepko.easycrafting.helpers.RecipeHelper;
import net.lepko.easycrafting.proxy.Proxy;
import net.minecraft.entity.player.InventoryPlayer;

public class RecipeWorker
implements Runnable {
    private ArrayList craftableRecipes = new ArrayList();
    private boolean displayed = true;
    private boolean requested = false;
    private static RecipeWorker instance;
    private static Thread workerThread;
    public static ReentrantLock lock;

    private void setCraftableRecipes() {
        long beforeTime = System.nanoTime();
        InventoryPlayer player_inventory = FMLClientHandler.instance().getClient().field_71439_g.field_71071_by;
        int maxRecursion = ConfigHandler.MAX_RECURSION;
        ArrayList tmp = RecipeHelper.getCraftableRecipes(player_inventory, maxRecursion, (List)RecipeHelper.getAllRecipes());
        Collections.sort(tmp, new RecipeHelper.RecipeComparator());
        this.craftableRecipes = tmp;
        EasyLog.log(String.format("%d/%d craftable | %.8f seconds", this.craftableRecipes.size(), RecipeHelper.getAllRecipes().size(), (double)(System.nanoTime() - beforeTime) / 1.0E9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (this.requested) {
                lock.lock();
                try {
                    this.setCraftableRecipes();
                    this.requested = false;
                    this.displayed = false;
                }
                finally {
                    lock.unlock();
                }
            }
            try {
                Thread.sleep(75L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void requestNewRecipeList() {
        this.requested = true;
    }

    public void setDisplayed() {
        this.displayed = true;
    }

    public ImmutableList getCraftableRecipes() {
        return ImmutableList.copyOf((Collection)this.craftableRecipes);
    }

    public boolean refreshDisplay() {
        return !this.displayed && !this.requested;
    }

    public static RecipeWorker instance() {
        if (!Proxy.proxy.isClient()) {
            throw new RuntimeException("Worker thread should only be run on client!");
        }
        if (instance == null) {
            instance = new RecipeWorker();
        }
        if (workerThread == null || !workerThread.isAlive()) {
            workerThread = new Thread((Runnable)instance, "EasyCrafting-WorkerThread");
            workerThread.setDaemon(true);
            workerThread.start();
            EasyLog.log("Started Worker Thread");
        }
        if (!lock.isHeldByCurrentThread()) {
            EasyLog.warning("Trying to access RecipeWorker instance without acquiring a thread lock!");
        }
        if (lock.getHoldCount() > 1) {
            EasyLog.warning("Current thread holds more than one lock!");
        }
        return instance;
    }

    static {
        lock = new ReentrantLock();
    }
}

