/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.inventory.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.lepko.easycrafting.ModEasyCrafting;
import net.lepko.easycrafting.block.TileEntityEasyCrafting;
import net.lepko.easycrafting.easyobjects.EasyRecipe;
import net.lepko.easycrafting.handlers.TickHandlerClient;
import net.lepko.easycrafting.helpers.RecipeHelper;
import net.lepko.easycrafting.helpers.RecipeWorker;
import net.lepko.easycrafting.inventory.ContainerEasyCrafting;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiEasyCrafting
extends GuiContainer {
    private static final String GUI_TEXTURE = "/mods/EasyCrafting/textures/gui/easycraftinggui.png";
    private static final int TABINDEX_CRAFTING = 0;
    private static final int TABINDEX_SEARCH = 1;
    private static int selectedTabIndex = 0;
    private static String lastSearch = "";
    public int currentScroll = 0;
    private int maxScroll = 0;
    private float scrollbarOffset = 0.0f;
    public ImmutableList renderList;
    public ImmutableList craftableList;
    private boolean[] canCraftCache;
    private boolean wasClicking = false;
    private boolean isScrolling = false;
    private ItemStack[] tabIcons = new ItemStack[]{new ItemStack(ModEasyCrafting.blockEasyCraftingTable), new ItemStack(Item.field_77750_aQ)};
    private String[] tabDescriptions = new String[]{"Available Recipes", "Search Recipes"};
    private GuiTextField searchField;

    public GuiEasyCrafting(InventoryPlayer player_inventory, TileEntityEasyCrafting tile_entity) {
        super((Container)new ContainerEasyCrafting(tile_entity, player_inventory));
        if (this.field_74193_d != null && this.field_74193_d instanceof ContainerEasyCrafting) {
            ((ContainerEasyCrafting)this.field_74193_d).gui = this;
        }
        this.field_74195_c = 235;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchField = new GuiTextField(this.field_73886_k, this.field_74198_m + 82, this.field_74197_n + 6, 89, this.field_73886_k.field_78288_b);
        this.searchField.func_73804_f(15);
        this.searchField.func_73786_a(false);
        this.searchField.func_73790_e(false);
        this.searchField.func_73794_g(0xFFFFFF);
        this.switchToTab(selectedTabIndex);
    }

    public void func_73874_b() {
        super.func_73874_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_74189_g(int i, int j) {
        int offsetX = 0;
        if (selectedTabIndex != 1) {
            this.field_73886_k.func_78276_b("Easy Crafting Table", 8, 6, 0x404040);
            offsetX = 159;
        } else {
            this.field_73886_k.func_78276_b("Search:", 8, 6, 0x404040);
            offsetX = 70;
        }
        if (RecipeWorker.lock.isLocked()) {
            this.field_73886_k.func_78276_b(EnumChatFormatting.OBFUSCATED + "x", offsetX, 6, 0x404040);
        }
    }

    protected void func_74185_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        this.field_73882_e.field_71446_o.func_98187_b(GUI_TEXTURE);
        this.drawTabs();
        this.field_73882_e.field_71446_o.func_98187_b(GUI_TEXTURE);
        int x = (this.field_73880_f - this.field_74194_b) / 2;
        int y = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_74194_b, this.field_74195_c);
        if (selectedTabIndex == 1) {
            int xSearchTex = this.field_74194_b - 90 - 7;
            this.func_73729_b(this.field_74198_m + xSearchTex, y + 4, xSearchTex, 244, 90, 12);
            this.searchField.func_73795_f();
            if (this.canCraftCache != null) {
                int offset = this.currentScroll * 8;
                for (int k = 0; k < 40 && k + offset < this.canCraftCache.length; ++k) {
                    this.renderSlotBackColor(this.field_74193_d.func_75139_a(k), this.canCraftCache[k + offset]);
                }
            }
        }
        for (int l = 0; l < 18; ++l) {
            this.renderSlotBackColor(this.field_74193_d.func_75139_a(l + 40), false);
        }
        this.field_73882_e.field_71446_o.func_98187_b(GUI_TEXTURE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xTex = this.maxScroll == 0 ? 12 : 0;
        this.func_73729_b(x + 156, y + 17 + (int)(this.scrollbarOffset * 73.0f), xTex, 240, 12, 16);
        this.drawTab(selectedTabIndex);
    }

    private void drawTabs() {
        for (int i = 0; i < 2; ++i) {
            if (i == selectedTabIndex) continue;
            this.drawTab(i);
        }
    }

    private void drawTab(int i) {
        int width = 32;
        int height = 28;
        int texLeft = 256 - width;
        int texTop = i * height;
        int x = this.field_74198_m - 28 - 2;
        int y = this.field_74197_n + i * (height + 1);
        if (i == selectedTabIndex) {
            texLeft -= width;
            x += 2;
        }
        GL11.glDisable((int)2896);
        this.func_73729_b(x, y, texLeft, texTop, width, height);
        this.field_73735_i = 100.0f;
        GuiEasyCrafting.field_74196_a.field_77023_b = 100.0f;
        int n = i == selectedTabIndex ? -1 : 1;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        ItemStack iconItemStack = this.tabIcons[i];
        field_74196_a.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, iconItemStack, x += 10 + n, y += 6);
        GL11.glDisable((int)2896);
        GuiEasyCrafting.field_74196_a.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    protected void func_73869_a(char par1, int par2) {
        if (selectedTabIndex != 1) {
            if (Keyboard.isKeyDown((int)this.field_73882_e.field_71474_y.field_74310_D.field_74512_d)) {
                this.switchToTab(1);
            } else {
                super.func_73869_a(par1, par2);
            }
        } else if (!this.func_82319_a(par2)) {
            if (this.searchField.func_73802_a(par1, par2)) {
                this.updateSearch();
            } else {
                super.func_73869_a(par1, par2);
            }
        }
    }

    public void func_73867_d() {
        int delta = Mouse.getEventDWheel();
        if (delta == 0) {
            super.func_73867_d();
        } else {
            this.setScrollPosition(this.currentScroll + (delta > 0 ? -1 : 1));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        boolean leftMouseDown = Mouse.isButtonDown((int)0);
        int left = this.field_74198_m + 155;
        int top = this.field_74197_n + 18;
        int right = left + 14;
        int bottom = top + 89;
        if (!this.wasClicking && leftMouseDown && mouseX >= left && mouseY >= top && mouseX < right && mouseY < bottom) {
            this.isScrolling = this.maxScroll > 0;
        } else if (!leftMouseDown) {
            this.isScrolling = false;
        }
        this.wasClicking = leftMouseDown;
        if (this.isScrolling) {
            this.setScrollPosition(((float)(mouseY - top) - 7.5f) / ((float)(bottom - top) - 15.0f));
        }
        super.func_73863_a(mouseX, mouseY, par3);
        for (int i = 0; i < this.tabDescriptions.length; ++i) {
            if (!this.isOverTab(i, mouseX, mouseY)) continue;
            this.func_74190_a(this.tabDescriptions[i], mouseX, mouseY);
        }
        for (int j = 0; j < 40; ++j) {
            Slot slot = this.field_74193_d.func_75139_a(j);
            if (!this.func_74188_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY)) continue;
            this.drawIngredientTooltip(j, mouseX, mouseY);
        }
        RenderHelper.func_74519_b();
    }

    protected void func_73864_a(int x, int y, int button) {
        if (button == 0) {
            for (int i = 0; i < this.tabDescriptions.length; ++i) {
                if (i == selectedTabIndex || !this.isOverTab(i, x, y)) continue;
                this.switchToTab(i);
                return;
            }
        }
        super.func_73864_a(x, y, button);
    }

    private boolean isOverTab(int tabIndex, int x, int y) {
        int width = 32;
        int height = 28;
        int tabX = this.field_74198_m - 28 - 2;
        int tabY = this.field_74197_n + tabIndex * (height + 1);
        return x > tabX && x < tabX + width && y > tabY && y < tabY + height;
    }

    private void switchToTab(int tabIndex) {
        if (this.searchField != null) {
            if (tabIndex == 1) {
                this.searchField.func_73790_e(true);
                this.searchField.func_73805_d(false);
                this.searchField.func_73796_b(true);
                this.searchField.func_73782_a(lastSearch);
            } else {
                this.searchField.func_73790_e(false);
                this.searchField.func_73805_d(true);
                this.searchField.func_73796_b(false);
            }
        }
        selectedTabIndex = tabIndex;
        this.updateSearch();
    }

    public void renderSlotBackColor(Slot slot, boolean canCraft) {
        int x = this.field_74198_m + slot.field_75223_e;
        int y = this.field_74197_n + slot.field_75221_f;
        int w = 16;
        int h = 16;
        int color = canCraft ? -2147442688 : -2136997888;
        Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)color);
    }

    private void updateSearch() {
        if (selectedTabIndex == 1) {
            ImmutableList all = RecipeHelper.getAllRecipes();
            ArrayList<EasyRecipe> list = new ArrayList<EasyRecipe>();
            lastSearch = this.searchField.func_73781_b().toLowerCase();
            block0: for (int i = 0; i < all.size(); ++i) {
                EasyRecipe r = (EasyRecipe)all.get(i);
                List itemProps = r.getResult().toItemStack().func_82840_a((EntityPlayer)this.field_73882_e.field_71439_g, this.field_73882_e.field_71474_y.field_82882_x);
                for (int j = 0; j < itemProps.size(); ++j) {
                    if (!((String)itemProps.get(j)).toLowerCase().contains(lastSearch)) continue;
                    list.add(r);
                    continue block0;
                }
            }
            this.renderList = ImmutableList.copyOf(list);
        }
        this.currentScroll = 0;
        this.scrollbarOffset = 0.0f;
        TickHandlerClient.updateEasyCraftingOutput();
    }

    public void refreshCraftingOutput() {
        this.craftableList = RecipeWorker.instance().getCraftableRecipes();
        if (selectedTabIndex == 0) {
            this.renderList = this.craftableList;
        } else if (selectedTabIndex == 1) {
            this.updateSlotBackgroundCache();
        }
        this.maxScroll = (int)(Math.ceil((double)this.renderList.size() / 8.0) - 5.0);
        if (this.maxScroll < 0) {
            this.maxScroll = 0;
        }
        if (this.currentScroll > this.maxScroll) {
            this.setScrollPosition(this.maxScroll);
        } else {
            ContainerEasyCrafting c = (ContainerEasyCrafting)this.field_74193_d;
            c.scrollTo(this.currentScroll, (List)this.renderList);
        }
    }

    private void updateSlotBackgroundCache() {
        this.canCraftCache = new boolean[this.renderList.size()];
        for (int i = 0; i < this.renderList.size(); ++i) {
            this.canCraftCache[i] = this.craftableList.contains(this.renderList.get(i));
        }
    }

    private void setScrollPosition(int scroll) {
        if (scroll < 0) {
            scroll = 0;
        } else if (scroll > this.maxScroll) {
            scroll = this.maxScroll;
        }
        this.currentScroll = scroll;
        this.scrollbarOffset = (float)this.currentScroll / (float)this.maxScroll;
        if (this.scrollbarOffset < 0.0f || Float.isNaN(this.scrollbarOffset)) {
            this.scrollbarOffset = 0.0f;
        } else if (this.scrollbarOffset > 1.0f) {
            this.scrollbarOffset = 1.0f;
        }
        ContainerEasyCrafting c = (ContainerEasyCrafting)this.field_74193_d;
        c.scrollTo(this.currentScroll, (List)this.renderList);
    }

    private void setScrollPosition(float scrollOffset) {
        if (scrollOffset < 0.0f || Float.isNaN(scrollOffset)) {
            scrollOffset = 0.0f;
        } else if (scrollOffset > 1.0f) {
            scrollOffset = 1.0f;
        }
        if (this.scrollbarOffset == scrollOffset) {
            return;
        }
        this.scrollbarOffset = scrollOffset;
        this.currentScroll = (int)(this.scrollbarOffset * (float)this.maxScroll);
        if (this.currentScroll < 0) {
            this.currentScroll = 0;
        } else if (this.currentScroll > this.maxScroll) {
            this.currentScroll = this.maxScroll;
        }
        ContainerEasyCrafting c = (ContainerEasyCrafting)this.field_74193_d;
        c.scrollTo(this.currentScroll, (List)this.renderList);
    }

    protected void drawIngredientTooltip(int slotIndex, int mouseX, int mouseY) {
        EasyRecipe r;
        EasyRecipe recipe = null;
        int recipe_index = slotIndex + this.currentScroll * 8;
        if (recipe_index >= 0 && this.renderList != null && recipe_index < this.renderList.size() && (r = (EasyRecipe)this.renderList.get(recipe_index)).getResult().equalsItemStack(this.field_74193_d.func_75139_a(slotIndex).func_75211_c())) {
            recipe = r;
        }
        if (recipe == null) {
            return;
        }
        ArrayList ingredientList = recipe.getCompactIngredientList();
        if (ingredientList != null && !ingredientList.isEmpty()) {
            int width = 16;
            int height = 16;
            int xPos = mouseX - width - 12;
            int yPos = mouseY - 4;
            if (ingredientList.size() > 1) {
                height += (ingredientList.size() - 1) * (height + 2);
            }
            if (this.field_74197_n + yPos + height + 6 > this.field_73881_g) {
                yPos = this.field_73881_g - height - this.field_74197_n - 6;
            }
            int bgColor = -267386864;
            int borderColor = 0x505000FF;
            int borderColorDark = (borderColor & 0xFEFEFE) >> 1 | borderColor & 0xFF000000;
            this.field_73735_i = 300.0f;
            GuiEasyCrafting.field_74196_a.field_77023_b = 300.0f;
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)32826);
            this.func_73733_a(xPos - 3, yPos - 4, xPos + width + 3, yPos - 3, bgColor, bgColor);
            this.func_73733_a(xPos - 3, yPos + height + 3, xPos + width + 3, yPos + height + 4, bgColor, bgColor);
            this.func_73733_a(xPos - 3, yPos - 3, xPos + width + 3, yPos + height + 3, bgColor, bgColor);
            this.func_73733_a(xPos - 4, yPos - 3, xPos - 3, yPos + height + 3, bgColor, bgColor);
            this.func_73733_a(xPos + width + 3, yPos - 3, xPos + width + 4, yPos + height + 3, bgColor, bgColor);
            this.func_73733_a(xPos - 3, yPos - 3 + 1, xPos - 3 + 1, yPos + height + 3 - 1, borderColor, borderColorDark);
            this.func_73733_a(xPos + width + 2, yPos - 3 + 1, xPos + width + 3, yPos + height + 3 - 1, borderColor, borderColorDark);
            this.func_73733_a(xPos - 3, yPos - 3, xPos + width + 3, yPos - 3 + 1, borderColor, borderColor);
            this.func_73733_a(xPos - 3, yPos + height + 2, xPos + width + 3, yPos + height + 3, borderColorDark, borderColorDark);
            RenderHelper.func_74520_c();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
            for (ItemStack is : ingredientList) {
                if (is.func_77960_j() == Short.MAX_VALUE) {
                    ItemStack is2 = is.func_77946_l();
                    is2.func_77964_b(0);
                    field_74196_a.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, is2, xPos, yPos);
                    field_74196_a.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, is2, xPos, yPos);
                } else {
                    field_74196_a.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, is, xPos, yPos);
                    field_74196_a.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, is, xPos, yPos);
                }
                yPos += 18;
            }
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)2896);
            this.field_73735_i = 0.0f;
            GuiEasyCrafting.field_74196_a.field_77023_b = 0.0f;
        }
    }
}

