/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.modcompat;

import ic2.api.item.ElectricItem;
import ic2.api.item.ICustomElectricItem;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.lepko.easycrafting.easyobjects.EasyItemStack;
import net.lepko.easycrafting.easyobjects.EasyRecipe;
import net.lepko.easycrafting.helpers.EasyLog;
import net.lepko.easycrafting.helpers.RecipeHelper;
import net.lepko.easycrafting.modcompat.ModCompat;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class ModCompatIC2
extends ModCompat {
    public ModCompatIC2() {
        super("IC2");
    }

    @Override
    public void scanRecipes(List recipes) {
        try {
            Iterator iterator = recipes.iterator();
            while (iterator.hasNext()) {
                IRecipe r = (IRecipe)iterator.next();
                String className = r.getClass().getName();
                if (!className.equals("ic2.core.AdvRecipe") && !className.equals("ic2.core.AdvShapelessRecipe")) continue;
                Object[] input = (Object[])Class.forName(className).getField("input").get(r);
                ArrayList<Object> ingredients = new ArrayList<Object>(Arrays.asList(input));
                RecipeHelper.scannedRecipes.add(new EasyRecipe(EasyItemStack.fromItemStack(r.func_77571_b()), ingredients));
                iterator.remove();
            }
        }
        catch (Exception e) {
            EasyLog.warning("[ModCompat] [" + this.modID + "] Exception while scanning recipes.", e);
            return;
        }
    }

    public static boolean isElectric(ItemStack is) {
        return ModCompat.isLoaded("IC2") && is.func_77973_b() instanceof IElectricItem;
    }

    public static int charge(ItemStack is, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (!ModCompatIC2.isElectric(is)) {
            return 0;
        }
        if (is.func_77973_b() instanceof ICustomElectricItem) {
            return ((ICustomElectricItem)is.func_77973_b()).charge(is, amount, tier, ignoreTransferLimit, simulate);
        }
        return ElectricItem.charge(is, amount, tier, ignoreTransferLimit, simulate);
    }

    public static int discharge(ItemStack is, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (!ModCompatIC2.isElectric(is)) {
            return 0;
        }
        if (is.func_77973_b() instanceof ICustomElectricItem) {
            return ((ICustomElectricItem)is.func_77973_b()).discharge(is, amount, tier, ignoreTransferLimit, simulate);
        }
        return ElectricItem.discharge(is, amount, tier, ignoreTransferLimit, simulate);
    }
}

