/*
 * Decompiled with CFR 0.152.
 */
package eplus.inventory;

import eplus.helper.EnchantHelper;
import eplus.inventory.SlotEnchant;
import eplus.inventory.SlotEnchantTable;
import eplus.inventory.TileEnchantTable;
import eplus.lib.ConfigurationSettings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ContainerEnchantTable
extends Container {
    public final World worldObj;
    public final IInventory tableInventory = new SlotEnchantTable(this, "Enchant", true, 1);
    final TileEnchantTable tileEnchantTable;
    private final int xPos;
    private final int yPos;
    private final int zPos;
    private Map<Integer, Integer> enchantments;

    public ContainerEnchantTable(InventoryPlayer par1InventoryPlayer, World par2World, int par3, int par4, int par5, TileEnchantTable tileEntity) {
        int l;
        this.worldObj = par2World;
        this.xPos = par3;
        this.yPos = par4;
        this.zPos = par5;
        this.tileEnchantTable = tileEntity;
        this.func_75146_a(new SlotEnchant(this, this.tableInventory, 0, 11, 31));
        for (l = 0; l < 3; ++l) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)par1InventoryPlayer, i1 + l * 9 + 9, 17 + i1 * 18, 91 + l * 18));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)par1InventoryPlayer, l, 17 + l * 18, 149));
        }
        this.func_75141_a(0, tileEntity.itemInTable);
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void func_75130_a(IInventory par1IInventory) {
        super.func_75130_a(par1IInventory);
        this.tileEnchantTable.func_70314_l().func_72902_n(this.tileEnchantTable.field_70329_l, this.tileEnchantTable.field_70330_m, this.tileEnchantTable.field_70327_n);
        this.readItems();
    }

    public Map<Integer, Integer> getEnchantments() {
        return this.enchantments;
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        this.tileEnchantTable.itemInTable = this.tableInventory.func_70301_a(0);
        this.tileEnchantTable.func_70314_l().func_72902_n(this.tileEnchantTable.field_70329_l, this.tileEnchantTable.field_70330_m, this.tileEnchantTable.field_70327_n);
    }

    private void readItems() {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        LinkedHashMap<Integer, Integer> temp = new LinkedHashMap<Integer, Integer>();
        if (itemStack != null && !itemStack.func_77951_h()) {
            this.tileEnchantTable.itemInTable = itemStack.func_77946_l();
            if (EnchantHelper.isItemEnchanted(itemStack)) {
                temp.putAll(EnchantmentHelper.func_82781_a((ItemStack)itemStack));
            }
            if (EnchantHelper.isItemEnchantable(itemStack)) {
                for (Enchantment obj : Enchantment.field_77331_b) {
                    if (obj == null || !EnchantHelper.canEnchantItem(itemStack, obj)) continue;
                    temp.put(obj.field_77352_x, 0);
                }
            } else {
                for (Enchantment obj : Enchantment.field_77331_b) {
                    boolean add = true;
                    for (Object enc : ((HashMap)temp).keySet()) {
                        Enchantment enchantment = Enchantment.field_77331_b[(Integer)enc];
                        if (obj == null || obj.func_77326_a(enchantment) && enchantment.func_77326_a(obj)) continue;
                        add = false;
                    }
                    if (obj == null || !EnchantHelper.canEnchantItem(itemStack, obj) || !add) continue;
                    temp.put(obj.field_77352_x, 0);
                }
            }
            if (this.enchantments != temp) {
                this.enchantments = temp;
            }
        } else {
            this.enchantments = temp;
        }
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(par2);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            ItemStack tempStack = stack.func_77946_l();
            itemStack = stack.func_77946_l();
            tempStack.field_77994_a = 1;
            if (par2 != 0) {
                Slot slot1 = (Slot)this.field_75151_b.get(0);
                if (!slot1.func_75216_d() && slot1.func_75214_a(tempStack) && this.func_75135_a(tempStack, 0, 1, false)) {
                    --stack.field_77994_a;
                    itemStack = stack.func_77946_l();
                }
            } else if (!this.func_75135_a(stack, 1, 37, false)) {
                return null;
            }
            if (stack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemStack.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(par1EntityPlayer, stack);
        }
        return itemStack;
    }

    public void enchant(EntityPlayer player, HashMap<Integer, Integer> map, int cost) {
        Integer level;
        ItemStack itemstack = this.func_75139_a(0).func_75211_c();
        HashMap<Integer, Integer> temp = new HashMap<Integer, Integer>();
        int serverCost = 0;
        if (itemstack == null) {
            return;
        }
        for (Integer enchantId : map.keySet()) {
            level = map.get(enchantId);
            Integer startingLevel = this.enchantments.get(enchantId);
            if (level > startingLevel) {
                serverCost += this.enchantmentCost(enchantId, level, startingLevel);
                continue;
            }
            if (level >= startingLevel) continue;
            serverCost += this.disenchantmentCost(enchantId, level, startingLevel);
        }
        if (cost != serverCost) {
            return;
        }
        for (Integer enchantId : this.enchantments.keySet()) {
            level = this.enchantments.get(enchantId);
            if (level == 0 || map.containsKey(enchantId)) continue;
            map.put(enchantId, level);
        }
        for (Integer enchantId : map.keySet()) {
            level = map.get(enchantId);
            if (level != 0) continue;
            temp.put(enchantId, level);
        }
        for (Integer object : temp.keySet()) {
            map.remove(object);
        }
        if (this.canPurchase(player, serverCost)) {
            EnchantHelper.setEnchantments(map, itemstack);
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_82242_a(-cost);
            }
        }
        this.func_75130_a(this.tableInventory);
    }

    public boolean canPurchase(EntityPlayer player, int cost) {
        return player.field_71075_bZ.field_75098_d || (player.field_71068_ca >= cost && ConfigurationSettings.needsBookShelves ? (float)cost <= this.bookCases() : cost <= player.field_71068_ca);
    }

    public int enchantmentCost(int enchantmentId, int enchantmentLevel, Integer level) {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (itemStack == null) {
            return 0;
        }
        Enchantment enchantment = Enchantment.field_77331_b[enchantmentId];
        int maxLevel = enchantment.func_77325_b();
        if (enchantmentLevel > maxLevel) {
            return 0;
        }
        int averageCost = (enchantment.func_77321_a(enchantmentLevel) + enchantment.func_77317_b(enchantmentLevel)) / 2;
        int adjustedCost = (int)((double)(averageCost * (enchantmentLevel - level)) / ((double)maxLevel * 4.0));
        if (!ConfigurationSettings.needsBookShelves) {
            int temp = (int)((float)adjustedCost * (60.0f / (this.bookCases() + 1.0f)));
            if ((temp /= 20) > adjustedCost) {
                adjustedCost = temp;
            }
        }
        return Math.max(1, adjustedCost);
    }

    public int disenchantmentCost(int enchantmentId, int enchantmentLevel, Integer level) {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (itemStack == null) {
            return 0;
        }
        Enchantment enchantment = Enchantment.field_77331_b[enchantmentId];
        int maxLevel = enchantment.func_77325_b();
        if (enchantmentLevel > maxLevel) {
            return 0;
        }
        int averageCost = (enchantment.func_77321_a(level.intValue()) + enchantment.func_77317_b(level.intValue())) / 2;
        int adjustedCost = (int)((double)(averageCost * (enchantmentLevel - level)) / ((double)maxLevel * 5.0));
        if (!ConfigurationSettings.needsBookShelves) {
            int temp = (int)((float)adjustedCost * (60.0f / (this.bookCases() + 1.0f)));
            if ((temp /= 20) > adjustedCost) {
                adjustedCost = temp;
            }
        }
        int enchantmentCost = this.enchantmentCost(enchantmentId, level - 1, enchantmentLevel);
        return Math.max(adjustedCost, -enchantmentCost);
    }

    public int repairCost() {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (itemStack == null) {
            return 0;
        }
        if (!itemStack.func_77948_v()) {
            return 0;
        }
        int cost = 0;
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        for (Object enchantment : enchantments.keySet()) {
            Integer enchantmentId = (Integer)enchantment;
            Integer enchantmentLevel = (Integer)enchantments.get(enchantment);
            cost += this.enchantmentCost(enchantmentId, enchantmentLevel, 0);
        }
        int maxDamage = itemStack.func_77958_k();
        int currentDamage = itemStack.func_77960_j();
        double percentDamage = (double)currentDamage / ((double)maxDamage * 2.0);
        return (int)Math.max(1.0, percentDamage * (double)cost);
    }

    public float bookCases() {
        float temp = 0.0f;
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (j == 0 && k == 0 || !this.worldObj.func_72799_c(this.xPos + k, this.yPos, this.zPos + j) || !this.worldObj.func_72799_c(this.xPos + k, this.yPos + 1, this.zPos + j)) continue;
                temp += ForgeHooks.getEnchantPower((World)this.worldObj, (int)(this.xPos + k * 2), (int)this.yPos, (int)(this.zPos + j * 2));
                temp += ForgeHooks.getEnchantPower((World)this.worldObj, (int)(this.xPos + k * 2), (int)(this.yPos + 1), (int)(this.zPos + j * 2));
                if (k == 0 || j == 0) continue;
                temp += ForgeHooks.getEnchantPower((World)this.worldObj, (int)(this.xPos + k * 2), (int)this.yPos, (int)(this.zPos + j));
                temp += ForgeHooks.getEnchantPower((World)this.worldObj, (int)(this.xPos + k * 2), (int)(this.yPos + 1), (int)(this.zPos + j));
                temp += ForgeHooks.getEnchantPower((World)this.worldObj, (int)(this.xPos + k), (int)this.yPos, (int)(this.zPos + j * 2));
                temp += ForgeHooks.getEnchantPower((World)this.worldObj, (int)(this.xPos + k), (int)(this.yPos + 1), (int)(this.zPos + j * 2));
            }
        }
        return temp * 2.0f;
    }

    public void repair(EntityPlayer player, int cost) {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (itemStack == null) {
            return;
        }
        int serverCost = this.repairCost();
        if (cost != serverCost || !itemStack.func_77948_v()) {
            return;
        }
        if (this.canPurchase(player, serverCost)) {
            itemStack.func_77964_b(0);
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_82242_a(-cost);
            }
        }
        this.func_75130_a(this.tableInventory);
    }
}

