/*
 * Decompiled with CFR 0.152.
 */
package eplus.network.packets;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import eplus.handlers.ConfigurationHandler;
import eplus.lib.ConfigurationSettings;
import eplus.network.packets.BasePacket;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class ConfigPacket
extends BasePacket {
    HashMap<String, String> configSettings = new HashMap();

    public ConfigPacket() {
    }

    public ConfigPacket(HashMap<String, String> configSettings) {
        this.configSettings = configSettings;
    }

    @Override
    public void write(ByteArrayDataOutput output) {
        output.writeInt(this.configSettings.size());
        for (String key : this.configSettings.keySet()) {
            output.writeUTF(key);
            output.writeUTF(this.configSettings.get(key));
        }
    }

    @Override
    public void read(ByteArrayDataInput input) {
        HashMap<String, String> temp = new HashMap<String, String>();
        int count = input.readInt();
        for (int i = 0; i < count; ++i) {
            temp.put(input.readUTF(), input.readUTF());
        }
        this.configSettings = temp;
    }

    @Override
    public void execute(EntityPlayer player, Side side) {
        if (side.isServer()) {
            for (String key : this.configSettings.keySet()) {
                Field field = ReflectionHelper.findField(ConfigurationSettings.class, (String[])new String[]{key});
                Class<?> type = field.getType();
                if (type != Boolean.TYPE) continue;
                NBTTagCompound entityData = player.getEntityData();
                entityData.func_74757_a("eplus:" + key, Boolean.parseBoolean(this.configSettings.get(key)));
            }
        } else {
            for (String key : this.configSettings.keySet()) {
                ConfigurationHandler.set(key, this.configSettings.get(key));
            }
        }
    }
}

