/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.BlockSpring;
import buildcraft.core.BuildCraftConfiguration;
import buildcraft.core.CommandBuildCraft;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityEnergyLaser;
import buildcraft.core.EntityPowerLaser;
import buildcraft.core.EntityRobot;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.ItemSpring;
import buildcraft.core.ItemWrench;
import buildcraft.core.RedstonePowerFramework;
import buildcraft.core.SpringPopulate;
import buildcraft.core.TickHandlerCoreClient;
import buildcraft.core.Version;
import buildcraft.core.blueprints.BptItem;
import buildcraft.core.network.PacketHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.ActionMachineControl;
import buildcraft.core.triggers.ActionRedstoneOutput;
import buildcraft.core.triggers.ActionTriggerIconProvider;
import buildcraft.core.triggers.BCAction;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.triggers.DefaultActionProvider;
import buildcraft.core.triggers.DefaultTriggerProvider;
import buildcraft.core.triggers.TriggerInventory;
import buildcraft.core.triggers.TriggerLiquidContainer;
import buildcraft.core.triggers.TriggerMachine;
import buildcraft.core.utils.Localization;
import buildcraft.transport.triggers.TriggerRedstoneInput;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.TreeMap;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;

@Mod(name="BuildCraft", version="3.5.3", useMetadata=false, modid="BuildCraft|Core", dependencies="required-after:Forge@[7.7.2.682,)")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandler.class, clientSideRequired=true, serverSideRequired=true)
public class BuildCraftCore {
    public static RenderMode render = RenderMode.Full;
    public static boolean debugMode = false;
    public static boolean modifyWorld = false;
    public static boolean trackNetworkUsage = false;
    public static boolean dropBrokenBlocks = true;
    public static int itemLifespan = 1200;
    public static int updateFactor = 10;
    public static long longUpdateFactor = 40L;
    public static BuildCraftConfiguration mainConfiguration;
    public static TreeMap bufferedDescriptions;
    public static final int trackedPassiveEntityId = 156;
    public static boolean continuousCurrentModel;
    public static Block springBlock;
    public static Item woodenGearItem;
    public static Item stoneGearItem;
    public static Item ironGearItem;
    public static Item goldGearItem;
    public static Item diamondGearItem;
    public static Item wrenchItem;
    @SideOnly(value=Side.CLIENT)
    public static Icon redLaserTexture;
    @SideOnly(value=Side.CLIENT)
    public static Icon blueLaserTexture;
    @SideOnly(value=Side.CLIENT)
    public static Icon stripesLaserTexture;
    @SideOnly(value=Side.CLIENT)
    public static Icon transparentTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIconProvider iconProvider;
    public static int blockByEntityModel;
    public static int legacyPipeModel;
    public static int markerModel;
    public static int oilModel;
    public static BCTrigger triggerMachineActive;
    public static BCTrigger triggerMachineInactive;
    public static BCTrigger triggerEmptyInventory;
    public static BCTrigger triggerContainsInventory;
    public static BCTrigger triggerSpaceInventory;
    public static BCTrigger triggerFullInventory;
    public static BCTrigger triggerEmptyLiquid;
    public static BCTrigger triggerContainsLiquid;
    public static BCTrigger triggerSpaceLiquid;
    public static BCTrigger triggerFullLiquid;
    public static BCTrigger triggerRedstoneActive;
    public static BCTrigger triggerRedstoneInactive;
    public static BCAction actionRedstone;
    public static BCAction actionOn;
    public static BCAction actionOff;
    public static BCAction actionLoop;
    public static boolean loadDefaultRecipes;
    public static boolean forcePneumaticPower;
    public static boolean consumeWaterSources;
    public static BptItem[] itemBptProps;
    public static Logger bcLog;
    public IIconProvider actionTriggerIconProvider = new ActionTriggerIconProvider();
    @Mod.Instance(value="BuildCraft|Core")
    public static BuildCraftCore instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.PreInit
    public void loadConfiguration(FMLPreInitializationEvent evt) {
        Version.check();
        bcLog.setParent(FMLLog.getLogger());
        bcLog.info("Starting BuildCraft " + Version.getVersion());
        bcLog.info("Copyright (c) SpaceToad, 2011");
        bcLog.info("http://www.mod-buildcraft.com");
        mainConfiguration = new BuildCraftConfiguration(new File(evt.getModConfigurationDirectory(), "buildcraft/main.conf"));
        try {
            mainConfiguration.load();
            Property continuousCurrent = mainConfiguration.get("general", "current.continuous", DefaultProps.CURRENT_CONTINUOUS);
            continuousCurrent.comment = "set to true for allowing machines to be driven by continuous current";
            continuousCurrentModel = continuousCurrent.getBoolean(DefaultProps.CURRENT_CONTINUOUS);
            Property trackNetwork = mainConfiguration.get("general", "trackNetworkUsage", false);
            trackNetworkUsage = trackNetwork.getBoolean(false);
            Property dropBlock = mainConfiguration.get("general", "dropBrokenBlocks", true);
            dropBlock.comment = "set to false to prevent fillers from dropping blocks.";
            dropBrokenBlocks = dropBlock.getBoolean(true);
            Property lifespan = mainConfiguration.get("general", "itemLifespan", itemLifespan);
            lifespan.comment = "the lifespan in ticks of items dropped on the ground by pipes and machines, vanilla = 6000, default = 1200";
            itemLifespan = lifespan.getInt(itemLifespan);
            if (itemLifespan < 100) {
                itemLifespan = 100;
            }
            Property powerFrameworkClass = mainConfiguration.get("general", "power.framework", "buildcraft.energy.PneumaticPowerFramework");
            Property factor = mainConfiguration.get("general", "network.updateFactor", 10);
            factor.comment = "increasing this number will decrease network update frequency, useful for overloaded servers";
            updateFactor = factor.getInt(10);
            Property longFactor = mainConfiguration.get("general", "network.stateRefreshPeriod", 40);
            longFactor.comment = "delay between full client sync packets, increasing it saves bandwidth, decreasing makes for better client syncronization.";
            longUpdateFactor = longFactor.getInt(40);
            String powerFrameworkClassName = "buildcraft.energy.PneumaticPowerFramework";
            if (!forcePneumaticPower) {
                powerFrameworkClassName = powerFrameworkClass.getString();
            }
            try {
                PowerFramework.currentFramework = (PowerFramework)Class.forName(powerFrameworkClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                bcLog.throwing("BuildCraftCore", "loadConfiguration", e);
                PowerFramework.currentFramework = new RedstonePowerFramework();
            }
            Property wrenchId = mainConfiguration.getItem("wrench.id", DefaultProps.WRENCH_ID);
            wrenchItem = new ItemWrench(wrenchId.getInt(DefaultProps.WRENCH_ID)).func_77655_b("wrenchItem");
            LanguageRegistry.addName((Object)wrenchItem, (String)"Wrench");
            CoreProxy.proxy.registerItem(wrenchItem);
            Property springId = mainConfiguration.getBlock("springBlock.id", DefaultProps.SPRING_ID);
            Property woodenGearId = mainConfiguration.getItem("woodenGearItem.id", DefaultProps.WOODEN_GEAR_ID);
            Property stoneGearId = mainConfiguration.getItem("stoneGearItem.id", DefaultProps.STONE_GEAR_ID);
            Property ironGearId = mainConfiguration.getItem("ironGearItem.id", DefaultProps.IRON_GEAR_ID);
            Property goldenGearId = mainConfiguration.getItem("goldenGearItem.id", DefaultProps.GOLDEN_GEAR_ID);
            Property diamondGearId = mainConfiguration.getItem("diamondGearItem.id", DefaultProps.DIAMOND_GEAR_ID);
            Property modifyWorld = mainConfiguration.get("general", "modifyWorld", true);
            modifyWorld.comment = "set to false if BuildCraft should not generate custom blocks (e.g. oil)";
            BuildCraftCore.modifyWorld = modifyWorld.getBoolean(true);
            if (BuildCraftCore.modifyWorld) {
                springBlock = new BlockSpring(springId.getInt()).func_71864_b("eternalSpring");
                CoreProxy.proxy.registerBlock(springBlock, ItemSpring.class);
            }
            woodenGearItem = new ItemBuildCraft(woodenGearId.getInt()).func_77655_b("woodenGearItem");
            LanguageRegistry.addName((Object)woodenGearItem, (String)"Wooden Gear");
            CoreProxy.proxy.registerItem(woodenGearItem);
            stoneGearItem = new ItemBuildCraft(stoneGearId.getInt()).func_77655_b("stoneGearItem");
            LanguageRegistry.addName((Object)stoneGearItem, (String)"Stone Gear");
            CoreProxy.proxy.registerItem(stoneGearItem);
            ironGearItem = new ItemBuildCraft(ironGearId.getInt()).func_77655_b("ironGearItem");
            LanguageRegistry.addName((Object)ironGearItem, (String)"Iron Gear");
            CoreProxy.proxy.registerItem(ironGearItem);
            goldGearItem = new ItemBuildCraft(goldenGearId.getInt()).func_77655_b("goldGearItem");
            LanguageRegistry.addName((Object)goldGearItem, (String)"Gold Gear");
            CoreProxy.proxy.registerItem(goldGearItem);
            diamondGearItem = new ItemBuildCraft(diamondGearId.getInt()).func_77655_b("diamondGearItem");
            LanguageRegistry.addName((Object)diamondGearItem, (String)"Diamond Gear");
            CoreProxy.proxy.registerItem(diamondGearItem);
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        finally {
            if (mainConfiguration.hasChanged()) {
                mainConfiguration.save();
            }
        }
    }

    @Mod.Init
    public void initialize(FMLInitializationEvent evt) {
        ActionManager.registerTriggerProvider(new DefaultTriggerProvider());
        ActionManager.registerActionProvider(new DefaultActionProvider());
        if (modifyWorld) {
            MinecraftForge.EVENT_BUS.register((Object)new SpringPopulate());
        }
        if (loadDefaultRecipes) {
            this.loadRecipes();
        }
        EntityRegistry.registerModEntity(EntityRobot.class, (String)"bcRobot", (int)10, (Object)instance, (int)50, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityPowerLaser.class, (String)"bcLaser", (int)30, (Object)instance, (int)50, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityEnergyLaser.class, (String)"bcEnergyLaser", (int)20, (Object)instance, (int)50, (int)1, (boolean)true);
        EntityList.field_75626_c.remove(EntityRobot.class);
        EntityList.field_75626_c.remove(EntityPowerLaser.class);
        EntityList.field_75626_c.remove(EntityEnergyLaser.class);
        EntityList.field_75625_b.remove("BuildCraft|Core.bcRobot");
        EntityList.field_75625_b.remove("BuildCraft|Core.bcLaser");
        EntityList.field_75625_b.remove("BuildCraft|Core.bcEnergyLaser");
        CoreProxy.proxy.initializeRendering();
        CoreProxy.proxy.initializeEntityRendering();
        Localization.addLocalization("/lang/buildcraft/", "en_US");
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        for (Block block : Block.field_71973_m) {
            if (!(block instanceof BlockFluid) && !(block instanceof IPlantable)) continue;
            BuildCraftAPI.softBlocks[block.field_71990_ca] = true;
        }
        BuildCraftAPI.softBlocks[Block.field_72037_aS.field_71990_ca] = true;
        BuildCraftAPI.softBlocks[Block.field_71998_bu.field_71990_ca] = true;
        BuildCraftAPI.softBlocks[Block.field_72067_ar.field_71990_ca] = true;
        TickRegistry.registerTickHandler((ITickHandler)new TickHandlerCoreClient(), (Side)Side.CLIENT);
    }

    @Mod.ServerStarting
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBuildCraft());
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) {
        if (event.map == Minecraft.func_71410_x().field_71446_o.field_94155_m) {
            iconProvider = new CoreIconProvider();
            iconProvider.registerIcons((IconRegister)event.map);
            this.actionTriggerIconProvider.registerIcons((IconRegister)event.map);
        } else if (event.map == Minecraft.func_71410_x().field_71446_o.field_94154_l) {
            redLaserTexture = event.map.func_94245_a("buildcraft:blockRedLaser");
            blueLaserTexture = event.map.func_94245_a("buildcraft:blockBlueLaser");
            stripesLaserTexture = event.map.func_94245_a("buildcraft:blockStripesLaser");
            transparentTexture = event.map.func_94245_a("buildcraft:blockTransparentLaser");
        }
    }

    public void loadRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(wrenchItem), (Object[])new Object[]{"I I", " G ", " I ", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('G'), stoneGearItem});
        GameRegistry.addRecipe((ItemStack)new ItemStack(woodenGearItem), (Object[])new Object[]{" S ", "S S", " S ", Character.valueOf('S'), Item.field_77669_D});
        GameRegistry.addRecipe((ItemStack)new ItemStack(stoneGearItem), (Object[])new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), Block.field_71978_w, Character.valueOf('G'), woodenGearItem});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ironGearItem), (Object[])new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('G'), stoneGearItem});
        GameRegistry.addRecipe((ItemStack)new ItemStack(goldGearItem), (Object[])new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), Item.field_77717_p, Character.valueOf('G'), ironGearItem});
        GameRegistry.addRecipe((ItemStack)new ItemStack(diamondGearItem), (Object[])new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), Item.field_77702_n, Character.valueOf('G'), goldGearItem});
    }

    static {
        bufferedDescriptions = new TreeMap();
        triggerMachineActive = new TriggerMachine(DefaultProps.TRIGGER_MACHINE_ACTIVE, true);
        triggerMachineInactive = new TriggerMachine(DefaultProps.TRIGGER_MACHINE_INACTIVE, false);
        triggerEmptyInventory = new TriggerInventory(DefaultProps.TRIGGER_EMPTY_INVENTORY, TriggerInventory.State.Empty);
        triggerContainsInventory = new TriggerInventory(DefaultProps.TRIGGER_CONTAINS_INVENTORY, TriggerInventory.State.Contains);
        triggerSpaceInventory = new TriggerInventory(DefaultProps.TRIGGER_SPACE_INVENTORY, TriggerInventory.State.Space);
        triggerFullInventory = new TriggerInventory(DefaultProps.TRIGGER_FULL_INVENTORY, TriggerInventory.State.Full);
        triggerEmptyLiquid = new TriggerLiquidContainer(DefaultProps.TRIGGER_EMPTY_LIQUID, TriggerLiquidContainer.State.Empty);
        triggerContainsLiquid = new TriggerLiquidContainer(DefaultProps.TRIGGER_CONTAINS_LIQUID, TriggerLiquidContainer.State.Contains);
        triggerSpaceLiquid = new TriggerLiquidContainer(DefaultProps.TRIGGER_SPACE_LIQUID, TriggerLiquidContainer.State.Space);
        triggerFullLiquid = new TriggerLiquidContainer(DefaultProps.TRIGGER_FULL_LIQUID, TriggerLiquidContainer.State.Full);
        triggerRedstoneActive = new TriggerRedstoneInput(DefaultProps.TRIGGER_REDSTONE_ACTIVE, true);
        triggerRedstoneInactive = new TriggerRedstoneInput(DefaultProps.TRIGGER_REDSTONE_INACTIVE, false);
        actionRedstone = new ActionRedstoneOutput(DefaultProps.ACTION_REDSTONE);
        actionOn = new ActionMachineControl(DefaultProps.ACTION_ON, ActionMachineControl.Mode.On);
        actionOff = new ActionMachineControl(DefaultProps.ACTION_OFF, ActionMachineControl.Mode.Off);
        actionLoop = new ActionMachineControl(DefaultProps.ACTION_LOOP, ActionMachineControl.Mode.Loop);
        loadDefaultRecipes = true;
        forcePneumaticPower = true;
        consumeWaterSources = true;
        itemBptProps = new BptItem[Item.field_77698_e.length];
        bcLog = Logger.getLogger("Buildcraft");
    }

    public static enum RenderMode {
        Full,
        NoDynamic;

    }
}

