/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.core.IBox;
import buildcraft.builders.BuilderProxyClient;
import buildcraft.builders.FillerPattern;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;

public class FillerFlattener
extends FillerPattern {
    @Override
    public boolean iteratePattern(TileEntity tile, IBox box, ItemStack stackToPlace) {
        int xMin = (int)box.pMin().x;
        int yMin = (int)box.pMin().y;
        int zMin = (int)box.pMin().z;
        int xMax = (int)box.pMax().x;
        int zMax = (int)box.pMax().z;
        int sizeX = xMax - xMin + 1;
        int sizeZ = zMax - zMin + 1;
        boolean[][] blockedColumns = new boolean[sizeX][sizeZ];
        int lastX = Integer.MAX_VALUE;
        int lastY = Integer.MAX_VALUE;
        int lastZ = Integer.MAX_VALUE;
        for (int y = yMin - 1; y >= 0; --y) {
            boolean found = false;
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (!BlockUtil.canChangeBlock(tile.field_70331_k, x, y, z)) {
                        return true;
                    }
                    if (blockedColumns[x - xMin][z - zMin]) continue;
                    if (!BlockUtil.isSoftBlock(tile.field_70331_k, x, y, z)) {
                        blockedColumns[x - xMin][z - zMin] = true;
                        continue;
                    }
                    found = true;
                    lastX = x;
                    lastY = y;
                    lastZ = z;
                }
            }
            if (!found) break;
        }
        if (lastX != Integer.MAX_VALUE && stackToPlace != null) {
            BlockUtil.breakBlock(tile.field_70331_k, lastX, lastY - 1, lastZ);
            stackToPlace.func_77973_b().func_77648_a(stackToPlace, CoreProxy.proxy.getBuildCraftPlayer(tile.field_70331_k), tile.field_70331_k, lastX, lastY - 1, lastZ, 1, 0.0f, 0.0f, 0.0f);
        }
        if (lastX != Integer.MAX_VALUE) {
            return false;
        }
        return !this.empty(xMin, yMin, zMin, xMax, 256, zMax, tile.field_70331_k);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getTexture() {
        return BuilderProxyClient.fillerFlattenTexture;
    }

    @Override
    public String getName() {
        return "Flatten";
    }
}

