/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.builders.ItemBptBase;
import buildcraft.builders.ItemBptBluePrint;
import buildcraft.builders.ItemBptTemplate;
import buildcraft.builders.TilePathMarker;
import buildcraft.core.BlockIndex;
import buildcraft.core.Box;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityLaser;
import buildcraft.core.EntityPowerLaser;
import buildcraft.core.EntityRobot;
import buildcraft.core.IBuilderInventory;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.blueprints.BptBase;
import buildcraft.core.blueprints.BptBlueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;

public class TileBuilder
extends TileBuildCraft
implements IBuilderInventory,
IPowerReceptor,
IMachine {
    private final ItemStack[] items = new ItemStack[28];
    private BptBuilderBase bluePrintBuilder;
    @TileNetworkData
    public Box box = new Box();
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    private LinkedList path;
    private LinkedList pathLasers;
    private EntityRobot builderRobot;
    public PathIterator currentPathIterator;
    private boolean done = true;

    public TileBuilder() {
        this.powerProvider.configure(10, 25, 25, 25, 25);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        for (int x = this.field_70329_l - 1; x <= this.field_70329_l + 1; ++x) {
            block1: for (int y = this.field_70330_m - 1; y <= this.field_70330_m + 1; ++y) {
                for (int z = this.field_70327_n - 1; z <= this.field_70327_n + 1; ++z) {
                    TileEntity tile = this.field_70331_k.func_72796_p(x, y, z);
                    if (!(tile instanceof TilePathMarker)) continue;
                    this.path = ((TilePathMarker)tile).getPath();
                    for (BlockIndex b : this.path) {
                        this.field_70331_k.func_94575_c(b.i, b.j, b.k, 0);
                        BuildCraftBuilders.pathMarkerBlock.func_71897_c(this.field_70331_k, b.i, b.j, b.k, BuildCraftBuilders.pathMarkerBlock.field_71990_ca, 0);
                    }
                    continue block1;
                }
            }
        }
        if (this.path != null && this.pathLasers == null) {
            ((BlockIndex)this.path.getFirst()).i = this.field_70329_l;
            ((BlockIndex)this.path.getFirst()).j = this.field_70330_m;
            ((BlockIndex)this.path.getFirst()).k = this.field_70327_n;
            this.createLasersForPath();
        }
        this.iterateBpt();
    }

    public void createLasersForPath() {
        this.pathLasers = new LinkedList();
        BlockIndex previous = null;
        for (BlockIndex b : this.path) {
            if (previous != null) {
                EntityPowerLaser laser = new EntityPowerLaser(this.field_70331_k, new Position((double)previous.i + 0.5, (double)previous.j + 0.5, (double)previous.k + 0.5), new Position((double)b.i + 0.5, (double)b.j + 0.5, (double)b.k + 0.5));
                laser.setTexture(DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_1.png");
                laser.show();
                this.field_70331_k.func_72838_d((Entity)laser);
                this.pathLasers.add(laser);
            }
            previous = b;
        }
    }

    public BptBuilderBase instanciateBluePrint(int x, int y, int z, ForgeDirection o) {
        BptBase bpt = BuildCraftBuilders.getBptRootIndex().getBluePrint(this.items[0].func_77960_j());
        if (bpt == null) {
            return null;
        }
        bpt = bpt.clone();
        BptContext context = new BptContext(this.field_70331_k, null, bpt.getBoxForPos(x, y, z));
        if (o != ForgeDirection.EAST) {
            if (o == ForgeDirection.SOUTH) {
                bpt.rotateLeft(context);
            } else if (o == ForgeDirection.WEST) {
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
            } else if (o == ForgeDirection.NORTH) {
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
            }
        }
        if (this.items[0].func_77973_b() instanceof ItemBptTemplate) {
            return new BptBuilderTemplate(bpt, this.field_70331_k, x, y, z);
        }
        if (this.items[0].func_77973_b() instanceof ItemBptBluePrint) {
            return new BptBuilderBlueprint((BptBlueprint)bpt, this.field_70331_k, x, y, z);
        }
        return null;
    }

    @Override
    public void doWork() {
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        if (this.done) {
            return;
        }
        if (this.builderRobot != null && !this.builderRobot.readyToBuild()) {
            return;
        }
        if (this.powerProvider.useEnergy(25.0f, 25.0f, true) < 25.0f) {
            return;
        }
        this.iterateBpt();
    }

    public void iterateBpt() {
        if (this.items[0] == null || !(this.items[0].func_77973_b() instanceof ItemBptBase)) {
            if (this.bluePrintBuilder != null) {
                this.bluePrintBuilder = null;
            }
            if (this.builderRobot != null) {
                this.builderRobot.func_70106_y();
                this.builderRobot = null;
            }
            if (this.box.isInitialized()) {
                this.box.deleteLasers();
                this.box.reset();
            }
            if (this.currentPathIterator != null) {
                this.currentPathIterator = null;
            }
            return;
        }
        if (this.bluePrintBuilder == null || this.bluePrintBuilder.done) {
            if (this.path != null && this.path.size() > 1) {
                if (this.currentPathIterator == null) {
                    Iterator it = this.path.iterator();
                    BlockIndex start = (BlockIndex)it.next();
                    this.currentPathIterator = new PathIterator(start, it);
                }
                if (this.bluePrintBuilder != null && this.builderRobot != null) {
                    this.builderRobot.markEndOfBlueprint(this.bluePrintBuilder);
                }
                this.bluePrintBuilder = this.currentPathIterator.next();
                if (this.bluePrintBuilder != null) {
                    this.box.deleteLasers();
                    this.box.reset();
                }
                if (this.builderRobot != null) {
                    this.builderRobot.setBox(this.box);
                }
                if (this.bluePrintBuilder == null) {
                    this.currentPathIterator = this.currentPathIterator.iterate();
                }
                if (this.currentPathIterator == null) {
                    this.done = true;
                }
            } else if (this.bluePrintBuilder != null && this.bluePrintBuilder.done) {
                if (this.builderRobot != null) {
                    this.builderRobot.markEndOfBlueprint(this.bluePrintBuilder);
                }
                this.done = true;
                this.bluePrintBuilder = null;
            } else {
                this.bluePrintBuilder = this.instanciateBluePrint(this.field_70329_l, this.field_70330_m, this.field_70327_n, ForgeDirection.values()[this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n)].getOpposite());
                if (this.bluePrintBuilder != null) {
                    this.box.initialize(this.bluePrintBuilder);
                    this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
                }
            }
        }
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack result;
        if (this.items[i] == null) {
            result = null;
        } else if (this.items[i].field_77994_a > j) {
            result = this.items[i].func_77979_a(j);
        } else {
            ItemStack tmp = this.items[i];
            this.items[i] = null;
            result = tmp;
        }
        if (i == 0) {
            this.iterateBpt();
        }
        return result;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.items[i] = itemstack;
        if (i == 0) {
            this.iterateBpt();
            this.done = false;
        }
    }

    public ItemStack func_70304_b(int slot) {
        if (this.items[slot] == null) {
            return null;
        }
        ItemStack toReturn = this.items[slot];
        this.items[slot] = null;
        return toReturn;
    }

    public String func_70303_b() {
        return "Builder";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this;
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        Utils.readStacksFromNBT(nbttagcompound, "Items", this.items);
        if (nbttagcompound.func_74764_b("box")) {
            this.box.initialize(nbttagcompound.func_74775_l("box"));
        }
        if (nbttagcompound.func_74764_b("path")) {
            this.path = new LinkedList();
            NBTTagList list = nbttagcompound.func_74761_m("path");
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.path.add(new BlockIndex((NBTTagCompound)list.func_74743_b(i)));
            }
        }
        this.done = nbttagcompound.func_74767_n("done");
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        Utils.writeStacksToNBT(nbttagcompound, "Items", this.items);
        if (this.box.isInitialized()) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbttagcompound.func_74782_a("box", (NBTBase)boxStore);
        }
        if (this.path != null) {
            NBTTagList list = new NBTTagList();
            for (BlockIndex i : this.path) {
                NBTTagCompound c = new NBTTagCompound();
                i.writeTo(c);
                list.func_74742_a((NBTBase)c);
            }
            nbttagcompound.func_74782_a("path", (NBTBase)list);
        }
        nbttagcompound.func_74757_a("done", this.done);
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.box.isInitialized()) {
            this.box.deleteLasers();
        }
        if (this.builderRobot != null) {
            this.builderRobot.func_70106_y();
            this.builderRobot = null;
        }
        this.cleanPathLasers();
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) {
        boolean initialized = this.box.isInitialized();
        super.handleDescriptionPacket(packet);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
        }
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        boolean initialized = this.box.isInitialized();
        super.handleUpdatePacket(packet);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        if (!(this.bluePrintBuilder == null && this.currentPathIterator == null || this.done)) {
            return this.powerProvider.getMaxEnergyReceived();
        }
        return 0;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if ((this.bluePrintBuilder == null || this.bluePrintBuilder.done) && this.box.isInitialized() && (this.builderRobot == null || this.builderRobot.done())) {
            this.box.deleteLasers();
            this.box.reset();
            if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
                this.sendNetworkUpdate();
            }
            return;
        }
        if (!this.box.isInitialized() && this.bluePrintBuilder == null && this.builderRobot != null) {
            this.builderRobot.func_70106_y();
            this.builderRobot = null;
        }
    }

    @Override
    public boolean isActive() {
        return !this.done;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    public void cleanPathLasers() {
        if (this.pathLasers != null) {
            for (EntityLaser laser : this.pathLasers) {
                laser.func_70106_y();
            }
            this.pathLasers = null;
        }
    }

    public boolean isBuildingBlueprint() {
        return this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemBptBluePrint;
    }

    public Collection getNeededItems() {
        if (this.bluePrintBuilder instanceof BptBuilderBlueprint) {
            return ((BptBuilderBlueprint)this.bluePrintBuilder).neededItems;
        }
        return null;
    }

    @Override
    public boolean isBuildingMaterial(int i) {
        return i != 0;
    }

    @Override
    public boolean allowActions() {
        return false;
    }

    private class PathIterator {
        public Iterator currentIterator;
        public double cx;
        public double cy;
        public double cz;
        public float ix;
        public float iy;
        public float iz;
        public BlockIndex to;
        public double lastDistance;
        AxisAlignedBB oldBoundingBox = null;
        ForgeDirection o = null;

        public PathIterator(BlockIndex from, Iterator it) {
            this.to = (BlockIndex)it.next();
            this.currentIterator = it;
            double dx = this.to.i - from.i;
            double dy = this.to.j - from.j;
            double dz = this.to.k - from.k;
            double size = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.cx = dx / size / 10.0;
            this.cy = dy / size / 10.0;
            this.cz = dz / size / 10.0;
            this.ix = from.i;
            this.iy = from.j;
            this.iz = from.k;
            this.lastDistance = (this.ix - (float)this.to.i) * (this.ix - (float)this.to.i) + (this.iy - (float)this.to.j) * (this.iy - (float)this.to.j) + (this.iz - (float)this.to.k) * (this.iz - (float)this.to.k);
            this.o = Math.abs(dx) > Math.abs(dz) ? (dx > 0.0 ? ForgeDirection.EAST : ForgeDirection.WEST) : (dz > 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH);
        }

        public BptBuilderBase next() {
            int newZ;
            int newY;
            int newX;
            BptBuilderBase bpt;
            while ((bpt = TileBuilder.this.instanciateBluePrint(newX = Math.round(this.ix), newY = Math.round(this.iy), newZ = Math.round(this.iz), this.o)) != null) {
                AxisAlignedBB boundingBox = bpt.getBoundingBox();
                if (this.oldBoundingBox == null || !this.collision(this.oldBoundingBox, boundingBox)) {
                    this.oldBoundingBox = boundingBox;
                    if (bpt != null) {
                        return bpt;
                    }
                }
                this.ix = (float)((double)this.ix + this.cx);
                this.iy = (float)((double)this.iy + this.cy);
                this.iz = (float)((double)this.iz + this.cz);
                double distance = (this.ix - (float)this.to.i) * (this.ix - (float)this.to.i) + (this.iy - (float)this.to.j) * (this.iy - (float)this.to.j) + (this.iz - (float)this.to.k) * (this.iz - (float)this.to.k);
                if (distance > this.lastDistance) {
                    return null;
                }
                this.lastDistance = distance;
            }
            return null;
        }

        public PathIterator iterate() {
            if (this.currentIterator.hasNext()) {
                PathIterator next = new PathIterator(this.to, this.currentIterator);
                next.oldBoundingBox = this.oldBoundingBox;
                return next;
            }
            return null;
        }

        public boolean collision(AxisAlignedBB left, AxisAlignedBB right) {
            if (left.field_72336_d < right.field_72340_a || left.field_72340_a > right.field_72336_d) {
                return false;
            }
            if (left.field_72337_e < right.field_72338_b || left.field_72338_b > right.field_72337_e) {
                return false;
            }
            return !(left.field_72334_f < right.field_72339_c) && !(left.field_72339_c > right.field_72334_f);
        }
    }
}

