/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.builders.TileMarker;
import buildcraft.core.Box;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.ActionMachineControl;
import buildcraft.core.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileFiller
extends TileBuildCraft
implements ISidedInventory,
IPowerReceptor,
IMachine,
IActionReceptor {
    @TileNetworkData
    public Box box = new Box();
    @TileNetworkData
    public int currentPatternId = 0;
    @TileNetworkData
    public boolean done = true;
    public IFillerPattern currentPattern;
    boolean forceDone = false;
    private ItemStack[] contents;
    IPowerProvider powerProvider;
    private ActionMachineControl.Mode lastMode = ActionMachineControl.Mode.Unknown;

    public TileFiller() {
        this.contents = new ItemStack[this.func_70302_i_()];
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.powerProvider.configure(20, 25, 50, 25, 100);
        this.powerProvider.configurePowerPerdition(25, 40);
    }

    @Override
    public void initialize() {
        IAreaProvider a;
        super.initialize();
        if (!CoreProxy.proxy.isRenderWorld(this.field_70331_k) && (a = Utils.getNearbyAreaProvider(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n)) != null) {
            this.box.initialize(a);
            if (a instanceof TileMarker) {
                ((TileMarker)a).removeFromWorld();
            }
            if (!CoreProxy.proxy.isRenderWorld(this.field_70331_k) && this.box.isInitialized()) {
                this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
            }
            this.sendNetworkUpdate();
        }
        this.computeRecipe();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.done) {
            if (this.lastMode == ActionMachineControl.Mode.Loop) {
                this.done = false;
            } else {
                return;
            }
        }
        if (this.powerProvider.getEnergyStored() >= 25.0f) {
            this.doWork();
        }
    }

    @Override
    public void doWork() {
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        if (this.lastMode == ActionMachineControl.Mode.Off) {
            return;
        }
        if (this.powerProvider.useEnergy(25.0f, 25.0f, true) < 25.0f) {
            return;
        }
        if (this.box.isInitialized() && this.currentPattern != null && !this.done) {
            ItemStack stack = null;
            int stackId = 0;
            for (int s = 9; s < this.func_70302_i_(); ++s) {
                if (this.func_70301_a(s) == null || this.func_70301_a((int)s).field_77994_a <= 0) continue;
                stack = this.contents[s];
                stackId = s;
                break;
            }
            this.done = this.currentPattern.iteratePattern(this, this.box, stack);
            if (stack != null && stack.field_77994_a == 0) {
                this.contents[stackId] = null;
            }
            if (this.done) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.sendNetworkUpdate();
            }
        }
        if (this.powerProvider.getEnergyStored() >= 25.0f) {
            this.doWork();
        }
    }

    public int func_70302_i_() {
        return 36;
    }

    public ItemStack func_70301_a(int i) {
        return this.contents[i];
    }

    public void computeRecipe() {
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        IFillerPattern newPattern = FillerManager.registry.findMatchingRecipe((IInventory)this);
        if (newPattern == this.currentPattern) {
            return;
        }
        this.currentPattern = newPattern;
        if (this.currentPattern == null || this.forceDone) {
            this.done = this.lastMode != ActionMachineControl.Mode.Loop;
            this.forceDone = false;
        } else {
            this.done = false;
        }
        if (this.field_70331_k != null) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        this.currentPatternId = this.currentPattern == null ? 0 : this.currentPattern.getId();
        if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            this.sendNetworkUpdate();
        }
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.contents[i] != null) {
            if (this.contents[i].field_77994_a <= j) {
                ItemStack itemstack = this.contents[i];
                this.contents[i] = null;
                this.computeRecipe();
                return itemstack;
            }
            ItemStack itemstack1 = this.contents[i].func_77979_a(j);
            if (this.contents[i].field_77994_a == 0) {
                this.contents[i] = null;
            }
            this.computeRecipe();
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.contents[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.computeRecipe();
    }

    public ItemStack func_70304_b(int slot) {
        if (this.contents[slot] == null) {
            return null;
        }
        ItemStack toReturn = this.contents[slot];
        this.contents[slot] = null;
        return toReturn;
    }

    public String func_70303_b() {
        return "Filler";
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        Utils.readStacksFromNBT(nbttagcompound, "Items", this.contents);
        if (nbttagcompound.func_74764_b("box")) {
            this.box.initialize(nbttagcompound.func_74775_l("box"));
        }
        this.done = nbttagcompound.func_74767_n("done");
        this.lastMode = ActionMachineControl.Mode.values()[nbttagcompound.func_74771_c("lastMode")];
        this.forceDone = this.done;
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        Utils.writeStacksToNBT(nbttagcompound, "Items", this.contents);
        if (this.box != null) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbttagcompound.func_74782_a("box", (NBTBase)boxStore);
        }
        nbttagcompound.func_74757_a("done", this.done);
        nbttagcompound.func_74774_a("lastMode", (byte)this.lastMode.ordinal());
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.box != null) {
            this.box.deleteLasers();
        }
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) {
        boolean initialized = this.box.isInitialized();
        super.handleDescriptionPacket(packet);
        this.currentPattern = FillerManager.registry.getPattern(this.currentPatternId);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
        }
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        boolean initialized = this.box.isInitialized();
        super.handleUpdatePacket(packet);
        this.currentPattern = FillerManager.registry.getPattern(this.currentPatternId);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
        }
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public boolean isActive() {
        return !this.done && this.lastMode != ActionMachineControl.Mode.Off;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        if (this.isActive()) {
            return this.powerProvider.getMaxEnergyReceived();
        }
        return 0;
    }

    @Override
    public void actionActivated(IAction action) {
        if (action == BuildCraftCore.actionOn) {
            this.lastMode = ActionMachineControl.Mode.On;
        } else if (action == BuildCraftCore.actionOff) {
            this.lastMode = ActionMachineControl.Mode.Off;
        } else if (action == BuildCraftCore.actionLoop) {
            this.lastMode = ActionMachineControl.Mode.Loop;
        }
    }

    @Override
    public boolean allowActions() {
        return true;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 9;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 9;
        }
        return this.func_70302_i_() - 9;
    }
}

