/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPassiveItemContribution;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.proxy.CoreProxy;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class EntityPassiveItem
implements IPipedItem {
    private TreeMap contributions = new TreeMap();
    protected static int maxId = 0;
    protected World worldObj;
    protected float speed = 0.01f;
    protected ItemStack item;
    protected TileEntity container;
    protected Position position;
    protected int entityId;

    public EntityPassiveItem(World world) {
        this(world, maxId < Short.MAX_VALUE ? (maxId = maxId + 1) : (maxId = Short.MIN_VALUE));
    }

    public EntityPassiveItem(World world, int id) {
        this.setEntityId(id);
        this.worldObj = world;
    }

    public EntityPassiveItem(World world, double d, double d1, double d2) {
        this(world);
        this.position = new Position(d, d1, d2);
        this.worldObj = world;
    }

    public EntityPassiveItem(World world, double d, double d1, double d2, ItemStack itemstack) {
        this(world, d, d1, d2);
        this.setItemStack(itemstack.func_77946_l());
    }

    public static IPipedItem getOrCreate(World world, int id) {
        return new EntityPassiveItem(world, id);
    }

    @Override
    public void remove() {
    }

    @Override
    public void setWorld(World world) {
        this.worldObj = world;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.position = new Position(x, y, z);
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }

    @Override
    public ItemStack getItemStack() {
        return this.item;
    }

    @Override
    public void setItemStack(ItemStack item) {
        this.item = item;
    }

    @Override
    public TileEntity getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(TileEntity container) {
        this.container = container;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.setPosition(nbttagcompound.func_74769_h("x"), nbttagcompound.func_74769_h("y"), nbttagcompound.func_74769_h("z"));
        this.setSpeed(nbttagcompound.func_74760_g("speed"));
        this.setItemStack(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("Item")));
        NBTTagList contribList = nbttagcompound.func_74761_m("contribList");
        for (int i = 0; i < contribList.func_74745_c(); ++i) {
            NBTTagCompound cpt = (NBTTagCompound)contribList.func_74743_b(i);
            String key = cpt.func_74779_i("key");
            String className = cpt.func_74779_i("class");
            if (this.getClass().getName().startsWith("net.minecraft.src")) {
                className = "net.minecraft.src." + className;
            }
            try {
                IPassiveItemContribution contrib = (IPassiveItemContribution)Class.forName(className).newInstance();
                contrib.readFromNBT(cpt);
                this.contributions.put(key, contrib);
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74780_a("x", this.position.x);
        nbttagcompound.func_74780_a("y", this.position.y);
        nbttagcompound.func_74780_a("z", this.position.z);
        nbttagcompound.func_74776_a("speed", this.getSpeed());
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        this.getItemStack().func_77955_b(nbttagcompound2);
        nbttagcompound.func_74766_a("Item", nbttagcompound2);
        NBTTagList contribList = new NBTTagList();
        for (String key : this.contributions.keySet()) {
            IPassiveItemContribution contrib = (IPassiveItemContribution)this.contributions.get(key);
            NBTTagCompound cpt = new NBTTagCompound();
            contrib.writeToNBT(cpt);
            cpt.func_74778_a("key", key);
            String className = contrib.getClass().getName();
            if (className.startsWith("net.minecraft.src.")) {
                className = className.replace("net.minecraft.src.", "");
            }
            cpt.func_74778_a("class", className);
            contribList.func_74742_a((NBTBase)cpt);
        }
        nbttagcompound.func_74782_a("contribList", (NBTBase)contribList);
    }

    @Override
    public EntityItem toEntityItem(ForgeDirection dir) {
        if (!CoreProxy.proxy.isRenderWorld(this.worldObj)) {
            if (this.getItemStack().field_77994_a <= 0) {
                return null;
            }
            Position motion = new Position(0.0, 0.0, 0.0, dir);
            motion.moveForwards(0.1 + (double)(this.getSpeed() * 2.0f));
            EntityItem entityitem = new EntityItem(this.worldObj, this.position.x, this.position.y, this.position.z, this.getItemStack());
            entityitem.lifespan = BuildCraftCore.itemLifespan;
            entityitem.field_70293_c = 10;
            float f3 = 0.0f + this.worldObj.field_73012_v.nextFloat() * 0.04f - 0.02f;
            entityitem.field_70159_w = (double)((float)this.worldObj.field_73012_v.nextGaussian() * f3) + motion.x;
            entityitem.field_70181_x = (double)((float)this.worldObj.field_73012_v.nextGaussian() * f3) + motion.y;
            entityitem.field_70179_y = (double)((float)this.worldObj.field_73012_v.nextGaussian() * f3) + motion.z;
            this.worldObj.func_72838_d((Entity)entityitem);
            this.remove();
            return entityitem;
        }
        return null;
    }

    @Override
    public float getEntityBrightness(float f) {
        int i = MathHelper.func_76128_c((double)this.position.x);
        int j = MathHelper.func_76128_c((double)this.position.z);
        this.worldObj.getClass();
        if (this.worldObj.func_72899_e(i, 64, j)) {
            double d = 0.66;
            int k = MathHelper.func_76128_c((double)(this.position.y + d));
            return this.worldObj.func_72801_o(i, k, j);
        }
        return 0.0f;
    }

    @Override
    public boolean isCorrupted() {
        return this.getItemStack() == null || this.getItemStack().field_77994_a <= 0 || Item.field_77698_e[this.getItemStack().field_77993_c] == null;
    }

    @Override
    public void addContribution(String key, IPassiveItemContribution contribution) {
        this.contributions.put(key, contribution);
    }

    @Override
    public IPassiveItemContribution getContribution(String key) {
        return (IPassiveItemContribution)this.contributions.get(key);
    }

    @Override
    public boolean hasContributions() {
        return this.contributions.size() > 0;
    }
}

