/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.SafeTimeTracker;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileBuffer {
    private int blockID = 0;
    private TileEntity tile;
    private SafeTimeTracker tracker = new SafeTimeTracker();
    private World world;
    int x;
    int y;
    int z;

    public void initialize(World world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.refresh();
    }

    public void refresh() {
        this.tile = null;
        this.blockID = this.world.func_72798_a(this.x, this.y, this.z);
        Block block = Block.field_71973_m[this.blockID];
        if (block != null && block.hasTileEntity(this.world.func_72805_g(this.x, this.y, this.z))) {
            this.tile = this.world.func_72796_p(this.x, this.y, this.z);
        }
    }

    public void set(int blockID, TileEntity tile) {
        this.blockID = blockID;
        this.tile = tile;
        this.tracker.markTime(this.world);
    }

    public int getBlockID() {
        if (this.tile != null && !this.tile.func_70320_p()) {
            return this.blockID;
        }
        if (this.tracker.markTimeIfDelay(this.world, 20L)) {
            this.refresh();
            if (this.tile != null && !this.tile.func_70320_p()) {
                return this.blockID;
            }
        }
        return 0;
    }

    public TileEntity getTile() {
        if (this.tile != null && !this.tile.func_70320_p()) {
            return this.tile;
        }
        if (this.tracker.markTimeIfDelay(this.world, 20L)) {
            this.refresh();
            if (this.tile != null && !this.tile.func_70320_p()) {
                return this.tile;
            }
        }
        return null;
    }
}

